/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.colorextractor;

import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.colorextractor.Clusterer;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ColorExtractor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ExtractedColor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ImageUtils;
import com.android.tools.pixelprobe.color.Colors;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DoublesColorExtractor
extends ColorExtractor {
    protected static final int MAX_IMAGE_SIZE = 300;
    protected static final int PARSE_INCREMENT = 7;
    protected static final int POINT_DIMENSION = 3;

    protected DoublesColorExtractor(Mockup mockup) {
        super(mockup);
    }

    protected DoublesColorExtractor(@NotNull BufferedImage image) {
        super(image);
    }

    @Override
    public void run(ColorExtractor.ColorExtractorCallback callback) {
        if (callback == null) {
            return;
        }
        this.myCallback = callback;
        BackgroundExtractTask task = new BackgroundExtractTask();
        task.addPropertyChangeListener(evt -> {
            if ("progress".equals(evt.getPropertyName())) {
                this.myCallback.progress((Integer)evt.getNewValue());
            }
        });
        task.execute();
    }

    @NotNull
    @VisibleForTesting
    static List<double[]> getLABPixels(BufferedImage image, HashMap<Integer, Integer> labToRgb, HashMap<Integer, double[]> rgbToLab, @Nullable List<Integer> treatedPixel) {
        float[] tempLAB = new float[3];
        ArrayList<double[]> clusterInput = new ArrayList<double[]>();
        int[] pixels = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        for (int i = 0; i < pixels.length; i += 7) {
            if (treatedPixel != null) {
                treatedPixel.add(i);
            }
            int rgb = pixels[i];
            new Color(rgb).getColorComponents(Colors.getLabColorSpace(), tempLAB);
            double[] LABDoubles = new double[]{tempLAB[0], tempLAB[1], tempLAB[2]};
            labToRgb.put(Arrays.hashCode(LABDoubles), rgb);
            rgbToLab.put(rgb, LABDoubles);
            clusterInput.add(LABDoubles);
        }
        return clusterInput;
    }

    abstract List<ExtractedColor> runClustering(HashMap<Integer, Integer> var1, List<double[]> var2, Clusterer.ProgressListener var3);

    protected class BackgroundExtractTask
    extends SwingWorker<Collection<ExtractedColor>, Object> {
        protected BackgroundExtractTask() {
        }

        @Override
        protected Collection<ExtractedColor> doInBackground() throws Exception {
            if (DoublesColorExtractor.this.myImage == null) {
                return Collections.emptyList();
            }
            return this.extractColors();
        }

        @NotNull
        private Collection<ExtractedColor> extractColors() {
            BufferedImage image = ImageUtils.createScaledImage(DoublesColorExtractor.this.myImage, 300);
            HashMap<Integer, Integer> labToRgb = new HashMap<Integer, Integer>();
            HashMap<Integer, double[]> rgbToLab = new HashMap<Integer, double[]>();
            List<double[]> clusterInput = DoublesColorExtractor.getLABPixels(image, labToRgb, rgbToLab, null);
            List<ExtractedColor> extractedColors = DoublesColorExtractor.this.runClustering(labToRgb, clusterInput, this::publishProgress);
            this.publishProgress(1.0f);
            return extractedColors;
        }

        protected void publishProgress(float progress) {
            this.setProgress(Math.max(0, Math.min(100, Math.round(progress * 100.0f))));
        }

        @Override
        protected void done() {
            try {
                DoublesColorExtractor.this.myCallback.result((Collection)this.get());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

