/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor;

import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.util.Consumer;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class AnimatedComponentSplitter
extends ThreeComponentsSplitter {
    private static final int DEFAULT_ANIMATION_DURATION = 150;
    private boolean myIsFirstShowing;
    private boolean myIsLastShowing;
    private int myFirstClosedSize = 0;
    private int myLastClosedSize = 0;
    private int myAnimationDuration = 150;

    public AnimatedComponentSplitter() {
    }

    public AnimatedComponentSplitter(boolean vertical) {
        super(vertical);
    }

    public AnimatedComponentSplitter(boolean vertical, boolean onePixelDividers) {
        super(vertical, onePixelDividers);
    }

    public boolean isFirstShowing() {
        return this.myIsFirstShowing;
    }

    public boolean isLastShowing() {
        return this.myIsLastShowing;
    }

    public void showAnimateFirst(boolean show) {
        int targetSize = show ? this.getFirstOpenSize() : this.myLastClosedSize;
        int startSize = this.getFirstSize();
        if (show && startSize > this.getFirstOpenSize() || !show && startSize < this.myFirstClosedSize) {
            return;
        }
        this.showAnimate((Consumer<Integer>)((Consumer)this::setFirstSize), targetSize, startSize);
    }

    public void showAnimateLast(boolean show) {
        int targetSize = show ? this.getLastOpenSize() : this.myLastClosedSize;
        int startSize = this.getLastSize();
        if (show && startSize > this.getLastOpenSize() || !show && startSize < this.myLastClosedSize) {
            return;
        }
        this.showAnimate((Consumer<Integer>)((Consumer)this::setLastSize), targetSize, startSize);
    }

    private void showAnimate(@NotNull Consumer<Integer> setSizeMethod, int targetSize, int startSize) {
        long startTime = System.currentTimeMillis();
        Timer timer = new Timer(20, e -> {
            float t = (float)(System.currentTimeMillis() - startTime) / (float)this.myAnimationDuration;
            if (t >= 1.0f) {
                t = 1.0f;
                ((Timer)e.getSource()).stop();
            }
            int delta = targetSize - startSize;
            int size = Math.round((float)startSize + (float)delta * t);
            setSizeMethod.consume((Object)size);
        });
        timer.setRepeats(true);
        timer.start();
    }

    public void showAnimateChild(@NotNull JComponent child, boolean show) {
        if (this.getFirstComponent() == child) {
            this.showAnimateFirst(show);
        } else if (this.getLastComponent() == child) {
            this.showAnimateLast(show);
        }
    }

    public void setFirstSize(int size) {
        this.myIsFirstShowing = size > 1;
        super.setFirstSize(size);
    }

    public void setLastSize(int size) {
        this.myIsLastShowing = size > 1;
        super.setLastSize(size);
    }

    protected int getFirstOpenSize() {
        return Math.round((float)this.getWidth() / 3.0f);
    }

    protected int getLastOpenSize() {
        return this.getFirstOpenSize();
    }

    public void setFirstClosedSize(int firstClosedSize) {
        this.myFirstClosedSize = firstClosedSize;
    }

    public void setLastClosedSize(int lastClosedSize) {
        this.myLastClosedSize = lastClosedSize;
    }
}

