/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.mockup.MockupFileHelper;
import com.android.tools.idea.uibuilder.mockup.editor.DeviceSelectionPopup;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.PixelProbe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class MockUpFileChooser {
    public static final MockUpFileChooser INSTANCE = new MockUpFileChooser();
    private String myLastOpenedFileName = null;

    private MockUpFileChooser() {
    }

    public void chooseMockUpFile(@NotNull NlComponent component2, @NotNull Consumer<String> callback) {
        VirtualFile file;
        String fileName = component2.getAttribute("http://schemas.android.com/tools", "mockup");
        VirtualFile virtualFile2 = file = fileName != null ? MockUpFileChooser.getVirtualFile(fileName) : null;
        if (file == null && this.myLastOpenedFileName != null) {
            file = MockUpFileChooser.getVirtualFile(this.myLastOpenedFileName);
        }
        FileChooser.chooseFile((FileChooserDescriptor)MockupFileHelper.getFileChooserDescriptor(), null, null, (VirtualFile)file, virtualFile -> this.handleFileSelection(component2, (VirtualFile)virtualFile, callback));
    }

    private void handleFileSelection(@NotNull NlComponent component2, @NotNull VirtualFile virtualFile, @NotNull Consumer<String> callback) {
        if (!virtualFile.exists() || virtualFile.isDirectory()) {
            return;
        }
        this.myLastOpenedFileName = virtualFile.getPath();
        if (component2.isRoot()) {
            MockUpFileChooser.openDeviceChoiceDialog(component2, virtualFile, callback);
        } else {
            MockUpFileChooser.accept(component2, virtualFile, callback);
        }
    }

    private static void accept(@NotNull NlComponent component2, @NotNull VirtualFile virtualFile, @NotNull Consumer<String> callback) {
        Path path = MockupFileHelper.getXMLFilePath(component2.getModel().getProject(), virtualFile.getPath());
        if (path != null) {
            callback.accept(path.toString());
        }
    }

    private static void openDeviceChoiceDialog(@NotNull NlComponent component2, @NotNull VirtualFile virtualFile, @NotNull Consumer<String> callback) {
        try {
            Image probe = PixelProbe.probe((InputStream)virtualFile.getInputStream());
            BufferedImage image = probe.getMergedImage();
            if (image == null) {
                return;
            }
            NlModel model = component2.getModel();
            Configuration configuration = model.getConfiguration();
            Device device = configuration.getDevice();
            if (device == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                DeviceSelectionPopup deviceSelectionPopup = new DeviceSelectionPopup(model.getProject(), configuration, image);
                if (deviceSelectionPopup.showAndGet()) {
                    MockUpFileChooser.accept(component2, virtualFile, callback);
                }
            });
        }
        catch (IOException e1) {
            Logger.getInstance(MockUpFileChooser.class).warn("Unable to open this file\n" + e1.getMessage());
        }
    }

    private static VirtualFile getVirtualFile(@NotNull String fileName) {
        return VfsUtil.findFileByIoFile((File)new File(FileUtil.toSystemIndependentName((String)fileName)), (boolean)false);
    }
}

