/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor;

import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.actions.MockupEditAction;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.MockupViewPanel;
import com.android.tools.idea.uibuilder.mockup.editor.tools.CropTool;
import com.android.tools.idea.uibuilder.mockup.editor.tools.ExtractWidgetTool;
import com.android.tools.idea.uibuilder.mockup.editor.tools.SelectionEditors;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockupEditor
extends JPanel
implements ToolContent<DesignSurface> {
    private static final String TITLE = "Mockup Editor";
    private static final String NO_MOCKUP_TEXT = "<html>No mockup available for this View.<br/>Click to add mockup</html>";
    private static final Dimension MINIMUM_SIZE = new Dimension(100, 100);
    private static final String CARD_MOCKUP_VIEW_PANEL = "mockupViewPanel";
    private static final String CARD_NO_MOCKUP = "noMockup";
    private final MyModelListener myModelListener;
    private final SelectionEditors mySelectionEditors;
    private final List<MockupEditorListener> myEditorListeners = new ArrayList<MockupEditorListener>();
    private final Set<Tool> myActiveTools = new HashSet<Tool>();
    private final ExtractWidgetTool myExtractWidgetTool;
    private final Mockup.MockupModelListener myMockupListener;
    private final DesignSurfaceListener myDesignSurfaceListener;
    private final JPanel myCenterPanel;
    private final CardLayout myCenterCardLayout;
    @Nullable
    private NlDesignSurface mySurface;
    @Nullable
    private NlModel myModel;
    @Nullable
    private Mockup myMockup;
    private final MockupViewPanel myMockupViewPanel;
    private final MyTopBar myTopBar;
    private final JPanel myBottomPanel;

    public MockupEditor() {
        super(new BorderLayout());
        JLabel addMockupIcon = MockupEditor.createNoMockupIcon(this.createAddMockupMouseAdapter());
        this.myMockupListener = (mockup, changedFlags) -> this.notifyListeners(mockup);
        this.myBottomPanel = new JPanel(new FlowLayout(2));
        this.myModelListener = new MyModelListener(this);
        this.myMockupViewPanel = new MockupViewPanel(this);
        this.myExtractWidgetTool = new ExtractWidgetTool(this);
        this.mySelectionEditors = new SelectionEditors(this.myMockupViewPanel);
        this.myTopBar = new MyTopBar(new CropTool(this), this.mySelectionEditors);
        this.myCenterCardLayout = new CardLayout();
        this.myCenterPanel = new JPanel(this.myCenterCardLayout);
        this.myCenterPanel.add((Component)this.myMockupViewPanel, CARD_MOCKUP_VIEW_PANEL);
        this.myCenterPanel.add((Component)addMockupIcon, CARD_NO_MOCKUP);
        this.add((Component)this.myTopBar, "North");
        this.add((Component)this.myCenterPanel, "Center");
        this.add((Component)this.myBottomPanel, "South");
        this.myDesignSurfaceListener = new MyDesignSurfaceListener(this);
        this.myExtractWidgetTool.enable(this);
        this.setMinimumSize(MINIMUM_SIZE);
        this.initSelection();
    }

    private void initSelection() {
        if (this.myModel != null) {
            ImmutableList<NlComponent> selection = this.myModel.getSelectionModel().getSelection();
            if (selection.isEmpty()) {
                selection = this.myModel.getComponents();
            }
            this.selectionUpdated(this.myModel, (List<NlComponent>)selection);
        }
    }

    private static JLabel createNoMockupIcon(MouseListener listener) {
        JBLabel addMockupIcon = new JBLabel(NO_MOCKUP_TEXT, AndroidIcons.Mockup.NoMockup, 0);
        addMockupIcon.setHorizontalTextPosition(0);
        addMockupIcon.setVerticalTextPosition(3);
        addMockupIcon.setIconTextGap(15);
        addMockupIcon.addMouseListener(listener);
        return addMockupIcon;
    }

    private void selectionUpdated(@Nullable NlModel model, @NotNull List<NlComponent> selection) {
        NlComponent selectedComponent = null;
        if (!selection.isEmpty()) {
            selectedComponent = selection.get(0);
        } else if (model != null && !(selection = model.getComponents()).isEmpty()) {
            selectedComponent = selection.get(0);
        }
        if (this.myMockup == null || selectedComponent != this.myMockup.getComponent()) {
            this.showMockupInEditor(selectedComponent != null ? Mockup.create(selectedComponent, false) : null);
        } else if (!Mockup.hasMockupAttribute(this.myMockup.getComponent())) {
            this.showNoMockup(true);
        } else {
            this.showNoMockup(false);
        }
    }

    private void showMockupInEditor(@Nullable Mockup mockup) {
        this.showNoMockup(mockup == null);
        if (mockup != this.myMockup) {
            this.setMockup(mockup);
        }
        this.resetTools();
        this.notifyListeners(mockup);
    }

    private void setMockup(@Nullable Mockup mockup) {
        if (this.myMockup != null) {
            this.myMockup.removeMockupListener(this.myMockupListener);
        }
        this.myMockup = mockup;
        if (this.myMockup != null) {
            this.myMockup.addMockupListener(this.myMockupListener);
        }
    }

    private void showNoMockup(boolean show) {
        this.myCenterCardLayout.show(this.myCenterPanel, show ? CARD_NO_MOCKUP : CARD_MOCKUP_VIEW_PANEL);
    }

    private void notifyListeners(Mockup mockup) {
        this.myEditorListeners.forEach(listener -> listener.editorUpdated(mockup));
    }

    public void addListener(@NotNull MockupEditorListener listener) {
        if (!this.myEditorListeners.contains(listener)) {
            this.myEditorListeners.add(listener);
        }
    }

    public void removeListener(@NotNull MockupEditorListener listener) {
        this.myEditorListeners.remove(listener);
    }

    @NotNull
    private MouseAdapter createAddMockupMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MockupEditor.this.myModel != null && MockupEditor.this.mySurface != null) {
                    ImmutableList<NlComponent> selection = MockupEditor.this.myModel.getSelectionModel().getSelection();
                    if (selection.isEmpty()) {
                        MockupEditor.this.myModel.getSelectionModel().setSelection((List<NlComponent>)MockupEditor.this.myModel.getComponents());
                    }
                    if (!selection.isEmpty()) {
                        MockupEditAction action = new MockupEditAction(MockupEditor.this.mySurface);
                        AnActionEvent event = new AnActionEvent(null, DataContext.EMPTY_CONTEXT, "", action.getTemplatePresentation().clone(), ActionManager.getInstance(), 0);
                        action.update(event);
                        action.actionPerformed(event);
                    }
                }
            }
        };
    }

    @NotNull
    public MockupViewPanel getMockupViewPanel() {
        return this.myMockupViewPanel;
    }

    private void resetTools() {
        for (Tool activeTool : this.myActiveTools) {
            activeTool.disable(this);
        }
        this.myActiveTools.clear();
        if (this.myMockup != null) {
            this.myExtractWidgetTool.enable(this);
        }
        this.myMockupViewPanel.getSelectionLayer().clearSelection();
        this.mySelectionEditors.setVisible(false);
    }

    public void disableTool(@NotNull Tool tool) {
        tool.disable(this);
        this.myActiveTools.remove(tool);
        if (this.myActiveTools.isEmpty()) {
            this.myActiveTools.add(this.myExtractWidgetTool);
            this.myExtractWidgetTool.enable(this);
        }
        this.myBottomPanel.removeAll();
        this.validate();
    }

    public void enableTool(@NotNull Tool tool) {
        this.myActiveTools.remove(this.myExtractWidgetTool);
        this.myExtractWidgetTool.disable(this);
        tool.enable(this);
        this.myActiveTools.add(tool);
    }

    @Nullable
    public Mockup getMockup() {
        return this.myMockup;
    }

    private void setModel(@Nullable NlModel model) {
        if (model == this.myModel) {
            return;
        }
        if (this.myModel != null) {
            this.myModel.removeListener(this.myModelListener);
        }
        this.myModel = model;
        if (this.myModel != null) {
            this.myModel.addListener(this.myModelListener);
        }
        List<NlComponent> selection = this.myModel != null ? this.myModel.getSelectionModel().getSelection() : Collections.emptyList();
        this.selectionUpdated(this.myModel, selection);
    }

    public void showError(String message) {
        if (this.myTopBar != null) {
            this.myTopBar.showError(message);
        }
    }

    public void setSelectionText(Rectangle selection) {
        this.mySelectionEditors.setSelection(selection);
    }

    public void addBottomControls(JComponent component2) {
        this.myBottomPanel.add(component2);
        this.validate();
    }

    public void dispose() {
    }

    public void setToolContext(@Nullable DesignSurface newDesignSurface) {
        SceneView sceneView;
        assert (newDesignSurface == null || newDesignSurface instanceof NlDesignSurface);
        if (this.mySurface != null) {
            this.mySurface.removeListener(this.myDesignSurfaceListener);
            this.mySurface = null;
            this.myExtractWidgetTool.setDesignSurface(null);
        }
        SceneView sceneView2 = sceneView = newDesignSurface != null ? newDesignSurface.getCurrentSceneView() : null;
        if (sceneView != null) {
            this.mySurface = (NlDesignSurface)newDesignSurface;
            this.mySurface.addListener(this.myDesignSurfaceListener);
            this.setModel(sceneView.getModel());
            this.myExtractWidgetTool.setDesignSurface(this.mySurface);
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    private static class MyModelListener
    implements ModelListener {
        private final MockupEditor myMockupEditor;

        public MyModelListener(MockupEditor mockupEditor) {
            this.myMockupEditor = mockupEditor;
        }

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model) {
            this.processModelChange(model);
        }

        @Override
        public void modelRendered(@NotNull NlModel model) {
            this.processModelChange(model);
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        }

        private void processModelChange(@NotNull NlModel model) {
            UIUtil.invokeLaterIfNeeded(() -> this.myMockupEditor.selectionUpdated(model, model.getSelectionModel().getSelection()));
        }
    }

    public static interface MockupEditorListener {
        public void editorUpdated(@Nullable Mockup var1);
    }

    private static class MyTopBar
    extends JPanel {
        public static final int ERROR_MESSAGE_DISPLAY_DURATION = 2000;
        private JLabel myErrorLabel;
        private Timer myErrorTimer;

        MyTopBar(@NotNull CropTool cropTool, @NotNull SelectionEditors selectionEditors) {
            super(new BorderLayout());
            this.add((Component)MyTopBar.createTitleBar(cropTool), "North");
            this.add((Component)this.createActionBar(selectionEditors), "South");
            this.myErrorTimer = new Timer(2000, e -> this.showError(""));
            this.myErrorTimer.setRepeats(false);
            this.setPreferredSize(new Dimension(100, 70));
            this.setMinimumSize(this.getPreferredSize());
        }

        @NotNull
        private JPanel createActionBar(SelectionEditors selectionEditors) {
            JPanel actionBar = new JPanel(new FlowLayout(2));
            actionBar.add(selectionEditors);
            this.myErrorLabel = new JLabel();
            this.myErrorLabel.setForeground((Color)JBColor.RED);
            actionBar.add((Component)this.myErrorLabel, "West");
            actionBar.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)10, (int)0, (int)5));
            return actionBar;
        }

        @NotNull
        private static JPanel createTitleBar(CropTool cropTool) {
            JPanel titleBar = new JPanel(new BorderLayout());
            titleBar.add((Component)new JBLabel(MockupEditor.TITLE), "West");
            titleBar.add((Component)cropTool, "East");
            titleBar.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)5, (int)0, (int)10));
            return titleBar;
        }

        private void showError(String message) {
            UIUtil.invokeLaterIfNeeded(() -> this.myErrorLabel.setText(message));
            if (!message.isEmpty()) {
                this.myErrorTimer.restart();
            } else {
                this.myErrorTimer.stop();
            }
        }
    }

    private static class MyDesignSurfaceListener
    implements DesignSurfaceListener {
        MockupEditor myEditor;

        public MyDesignSurfaceListener(@NotNull MockupEditor editor) {
            this.myEditor = editor;
        }

        @Override
        public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> newSelection) {
            this.myEditor.selectionUpdated(this.myEditor.myModel, newSelection);
        }

        @Override
        public void sceneChanged(@NotNull DesignSurface surface, @Nullable SceneView sceneView) {
        }

        @Override
        public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
            this.myEditor.setModel(model);
        }

        @Override
        public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component2) {
            return false;
        }
    }

    public static interface Tool {
        public void enable(@NotNull MockupEditor var1);

        public void disable(@NotNull MockupEditor var1);
    }
}

