/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.SimpleViewCreator;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.Disposable;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Rectangle;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class IncludeTagCreator
extends SimpleViewCreator {
    private String myNewLayoutResource;

    public IncludeTagCreator(@NotNull Mockup mockup, @NotNull NlModel model, @NotNull ScreenView screenView, @NotNull Rectangle selection) {
        super(mockup, model, screenView, selection);
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        this.myNewLayoutResource = this.createNewIncludedLayout();
        super.addAttributes(transaction);
        if (this.myNewLayoutResource != null) {
            IncludeTagCreator.addIncludeAttribute(transaction, this.myNewLayoutResource);
        }
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        return "include";
    }

    @Override
    public NlComponent addToModel() {
        NlComponent component2 = this.getMockup().getComponent();
        if (NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.v7.widget.RecyclerView")) {
            this.addListItemAttribute(component2);
            return component2;
        }
        return super.addToModel();
    }

    private void addListItemAttribute(NlComponent component2) {
        String newLayoutResource = this.createNewIncludedLayout();
        NlWriteCommandAction.run(component2, "Add listitem attribute", () -> component2.setAttribute("http://schemas.android.com/tools", "listitem", "@layout/" + newLayoutResource));
    }

    private static void addIncludeAttribute(@NotNull AttributesTransaction transaction, @NotNull String resourceName) {
        transaction.setAttribute(null, "layout", "@layout/" + resourceName);
    }

    private String createNewIncludedLayout() {
        ResourceFolderType folderType;
        AndroidFacet facet = this.getMockup().getComponent().getModel().getFacet();
        XmlFile newFile = CreateResourceFileAction.createFileResource(facet, folderType = AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.get(ResourceType.LAYOUT), null, null, null, true, null, null, null, false);
        if (newFile == null) {
            return null;
        }
        XmlTag rootTag = newFile.getRootTag();
        if (rootTag == null) {
            return null;
        }
        NlModel nlModel = NlModel.create(this.getScreenView().getSurface(), (Disposable)newFile.getProject(), facet, newFile);
        ModelListener listener = new ModelListener(){

            @Override
            public void modelRendered(@NotNull NlModel model) {
                model.removeListener(this);
                if (model.getComponents().isEmpty()) {
                    return;
                }
                NlComponent component2 = (NlComponent)model.getComponents().get(0);
                AttributesTransaction transaction = component2.startAttributeTransaction();
                IncludeTagCreator.this.addShowInAttribute(transaction);
                IncludeTagCreator.this.addSizeAttributes(transaction, IncludeTagCreator.this.getAndroidBounds());
                IncludeTagCreator.this.addMockupAttributes(transaction, IncludeTagCreator.this.getSelectionBounds());
                NlWriteCommandAction.run(component2, "", transaction::commit);
            }

            @Override
            public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
            }
        };
        nlModel.addListener(listener);
        return IncludeTagCreator.getResourceName(newFile);
    }

    @NotNull
    private static String getResourceName(@NotNull XmlFile newFile) {
        return AndroidCommonUtils.getResourceName((String)ResourceType.LAYOUT.getName(), (String)newFile.getName());
    }

    private void addShowInAttribute(@NotNull AttributesTransaction transaction) {
        String showInName = IncludeTagCreator.getResourceName(this.getModel().getFile());
        transaction.setAttribute("http://schemas.android.com/tools", "showIn", "@layout/" + showInName);
    }
}

