/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.AutoCompleteViewCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.ExtractIconCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.FloatingActionButtonCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.ImageViewCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.IncludeTagCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.RecyclerViewCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.SimpleViewCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.TextViewCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public final class WidgetCreatorFactory {
    @NotNull
    public static WidgetCreator create(@NotNull String tagName, @NotNull Mockup mockup, @NotNull NlModel model, @NotNull ScreenView screenView, @NotNull Rectangle selection) {
        SimpleViewCreator creator;
        switch (tagName) {
            case "include": {
                creator = new IncludeTagCreator(mockup, model, screenView, selection);
                break;
            }
            case "ImageView": {
                creator = new ImageViewCreator(mockup, model, screenView, selection);
                break;
            }
            case "android.support.design.widget.FloatingActionButton": {
                creator = new FloatingActionButtonCreator(mockup, model, screenView, selection);
                break;
            }
            case "TextView": {
                creator = new TextViewCreator(mockup, model, screenView, selection);
                break;
            }
            case "drawable": {
                creator = new ExtractIconCreator(mockup, model, screenView, selection);
                break;
            }
            case "android.support.v7.widget.RecyclerView": {
                creator = new RecyclerViewCreator(mockup, model, screenView, selection);
                break;
            }
            default: {
                creator = new AutoCompleteViewCreator(mockup, model, screenView, selection);
            }
        }
        return creator;
    }
}

