/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.tools;

import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ColorExtractor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.DBSCANColorExtractor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ExtractedColor;
import com.android.tools.idea.uibuilder.mockup.editor.tools.ColorPanel;
import com.android.tools.idea.uibuilder.mockup.editor.tools.MockupTool;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ColorExtractorTool
implements MockupTool,
ColorPanel.ColorHoveredListener {
    private final Mockup myMockup;
    private JButton myExtractButton;
    private JButton myExportButton;
    private JProgressBar myProgressBar;
    private JPanel myOutput;
    private JPanel myTools;
    private Collection<ExtractedColor> myExtractedColors;
    private boolean myIsExtractingColor;
    private final JPanel myColors;
    private final MainPanel myMainPanel;
    private Map<Integer, BufferedImage> myImageCache;
    private BufferedImage myImage;
    private BufferedImage mySelectedColorImage;

    public ColorExtractorTool(Mockup mockup) {
        this.myMockup = mockup;
        this.$$$setupUI$$$();
        this.myImageCache = new HashMap<Integer, BufferedImage>();
        this.myMainPanel = new MainPanel();
        this.myMockup.addMockupListener((mockup1, changedFlags) -> {
            this.myImage = mockup1.getImage();
        });
        this.myColors = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 5, true, false));
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myColors, 20, 31);
        this.myOutput.add((Component)scrollPane);
        this.initColorsComponents();
        this.myImage = this.myMockup.getImage();
    }

    private void initColorsComponents() {
        this.myExtractButton.addActionListener(e -> {
            if (this.myExtractedColors != null) {
                this.myColors.removeAll();
            }
            if (!this.myIsExtractingColor) {
                DBSCANColorExtractor colorExtractor = new DBSCANColorExtractor(this.myMockup);
                this.myIsExtractingColor = true;
                ((ColorExtractor)colorExtractor).run(new ColorExtractor.ColorExtractorCallback(){

                    @Override
                    public void result(Collection<ExtractedColor> rgbColors) {
                        ColorExtractorTool.this.myProgressBar.setValue(100);
                        ColorExtractorTool.this.myExportButton.setEnabled(true);
                        ColorExtractorTool.this.myIsExtractingColor = false;
                        ColorExtractorTool.this.myExtractedColors = rgbColors;
                        for (ExtractedColor color : rgbColors) {
                            ColorPanel colorPanel = new ColorPanel(color);
                            colorPanel.addHoveredListener(ColorExtractorTool.this);
                            JPanel component2 = colorPanel.getComponent();
                            component2.setMaximumSize(component2.getPreferredSize());
                            ColorExtractorTool.this.myColors.add((Component)component2, 0);
                        }
                        ColorExtractorTool.this.myColors.revalidate();
                    }

                    @Override
                    public void progress(int progress) {
                        ColorExtractorTool.this.myProgressBar.setValue(progress);
                    }
                });
            }
        });
    }

    @Override
    public JComponent getToolPanel() {
        return this.myTools;
    }

    @Override
    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    @Override
    public String getTitle() {
        return "Color Extractor";
    }

    @Override
    public void entered(ExtractedColor color) {
        if (this.myExtractedColors != null) {
            this.mySelectedColorImage = this.mask(this.myImage, color);
            this.myMainPanel.repaint();
        }
    }

    @Override
    public void exited() {
        this.mySelectedColorImage = null;
        this.myMainPanel.repaint();
    }

    private BufferedImage mask(BufferedImage image, ExtractedColor hoveredColor) {
        if (this.myImageCache.containsKey(hoveredColor.getColor())) {
            return this.myImageCache.get(hoveredColor.getColor());
        }
        BufferedImage copy = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        int width = image.getWidth();
        int height = image.getHeight();
        int[] imagePixels = image.getRGB(0, 0, width, height, null, 0, width);
        for (int i = 0; i < imagePixels.length; ++i) {
            int color = imagePixels[i];
            if (hoveredColor.getNeighborColor().contains(color)) continue;
            imagePixels[i] = ColorExtractorTool.average(hoveredColor.getColor(), color) & 0xFFFFFF | 0x64000000;
        }
        copy.setRGB(0, 0, width, height, imagePixels, 0, width);
        this.myImageCache.put(hoveredColor.getColor(), copy);
        return copy;
    }

    public static int average(int a, int b) {
        float outA = (float)(b >> 24 & 0xFF) / 255.0f;
        float outR = (float)(b >> 16 & 0xFF) / 255.0f;
        float outG = (float)(b >> 8 & 0xFF) / 255.0f;
        float outB = (float)(b & 0xFF) / 255.0f;
        float colorA = (float)(a >> 24 & 0xFF) / 255.0f;
        float colorR = (float)(a >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(a >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(a & 0xFF) / 255.0f;
        outA += colorA;
        outR += colorR;
        outG += colorG;
        outB += colorB;
        outA /= 2.0f;
        outR /= 2.0f;
        outG /= 2.0f;
        outB /= 2.0f;
        outR = (float)Math.pow(outR, 0.45454545454545453) * 255.0f;
        outG = (float)Math.pow(outG, 0.45454545454545453) * 255.0f;
        outB = (float)Math.pow(outB, 0.45454545454545453) * 255.0f;
        return (int)(outA *= 255.0f) << 24 | (int)outR << 16 | (int)outG << 8 | (int)outB;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JButton jButton;
        JProgressBar jProgressBar;
        JButton jButton2;
        JPanel jPanel2;
        this.myTools = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalTextPosition(4);
        jLabel.setText("Colors:");
        jLabel.setHorizontalAlignment(4);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myExtractButton = jButton2 = new JButton();
        jButton2.setText("Extract");
        jPanel2.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setStringPainted(false);
        jProgressBar.setIndeterminate(false);
        jPanel2.add((Component)jProgressBar, new GridConstraints(1, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myExportButton = jButton = new JButton();
        jButton.setText("Export");
        ((Component)jButton).setEnabled(false);
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myOutput = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTools;
    }

    class MainPanel
    extends JPanel {
        public static final int CHESS_BOARD_SQUARE = 10;
        private AffineTransform myTransform = new AffineTransform();

        MainPanel() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2D = (Graphics2D)g.create();
            float scale = (float)this.getHeight() / (float)ColorExtractorTool.this.myImage.getHeight();
            this.myTransform.setToIdentity();
            this.myTransform.scale(scale, scale);
            this.myTransform.translate((double)this.getWidth() / 2.0 - (double)((float)ColorExtractorTool.this.myImage.getWidth() * scale) / 2.0, 0.0);
            g2D.setTransform(this.myTransform);
            g2D.fillRect(0, 0, ColorExtractorTool.this.myImage.getWidth(), ColorExtractorTool.this.myImage.getHeight());
            g2D.drawImage((Image)(ColorExtractorTool.this.mySelectedColorImage != null ? ColorExtractorTool.this.mySelectedColorImage : ColorExtractorTool.this.myImage), 0, 0, null);
            g2D.dispose();
        }

        private void drawChessboard(Graphics2D g2D) {
            for (int x = 0; x < ColorExtractorTool.this.myImage.getWidth(); x += 10) {
                for (int y = 0; y < ColorExtractorTool.this.myImage.getHeight(); y += 10) {
                    int xModulo = x % 20;
                    int yModulo = y % 20;
                    if (xModulo == 0 && yModulo == 0 || xModulo != 0 && yModulo != 0) {
                        g2D.setColor((Color)JBColor.BLACK);
                    } else {
                        g2D.setColor((Color)Gray._50);
                    }
                    g2D.fillRect(x, y, 10, 10);
                }
            }
        }
    }
}

