/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DnDTransferItem {
    private final boolean myFromPalette;
    private final long myModelId;
    private final ImmutableList<DnDTransferComponent> myComponents;

    public DnDTransferItem(@NotNull DnDTransferComponent component2) {
        this(true, 0L, (ImmutableList<DnDTransferComponent>)ImmutableList.of((Object)component2));
    }

    public DnDTransferItem(long modelId, @NotNull ImmutableList<DnDTransferComponent> components) {
        this(false, modelId, components);
    }

    private DnDTransferItem(boolean fromPalette, long modelId, @NotNull ImmutableList<DnDTransferComponent> components) {
        this.myFromPalette = fromPalette;
        this.myModelId = modelId;
        this.myComponents = components;
    }

    @Nullable
    public static DnDTransferItem getTransferItem(@NotNull Transferable transferable, boolean allowPlaceholder) {
        DnDTransferItem item = null;
        try {
            String xml;
            if (transferable.isDataFlavorSupported(ItemTransferable.DESIGNER_FLAVOR)) {
                item = (DnDTransferItem)transferable.getTransferData(ItemTransferable.DESIGNER_FLAVOR);
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && !StringUtil.isEmpty((String)(xml = (String)transferable.getTransferData(DataFlavor.stringFlavor)))) {
                item = new DnDTransferItem(new DnDTransferComponent("", xml, 200, 100));
            }
        }
        catch (InvalidDnDOperationException ex) {
            if (!allowPlaceholder) {
                return null;
            }
            String defaultXml = "<placeholder xmlns:android=\"http://schemas.android.com/apk/res/android\"/>";
            item = new DnDTransferItem(new DnDTransferComponent("", defaultXml, 200, 100));
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Logger.getInstance(DnDTransferItem.class).warn((Throwable)ex);
        }
        return item;
    }

    public boolean isFromPalette() {
        return this.myFromPalette;
    }

    public long getModelId() {
        return this.myModelId;
    }

    public ImmutableList<DnDTransferComponent> getComponents() {
        return this.myComponents;
    }
}

