/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.common.model.NlComponent;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NlComponentUtil {
    @NotNull
    public static Multimap<NlComponent, NlComponent> groupSiblings(@NotNull Collection<? extends NlComponent> components) {
        if (components.isEmpty()) {
            return ImmutableMultimap.of();
        }
        if (components.size() == 1) {
            ArrayListMultimap siblingLists = ArrayListMultimap.create((int)1, (int)1);
            NlComponent component2 = components.iterator().next();
            siblingLists.put((Object)component2.getParent(), (Object)component2);
            return siblingLists;
        }
        HashMultimap siblingLists = HashMultimap.create();
        for (NlComponent nlComponent : components) {
            NlComponent parent = nlComponent.getParent();
            siblingLists.put((Object)parent, (Object)nlComponent);
        }
        return siblingLists;
    }

    public static boolean isDescendant(@NotNull NlComponent potentialDescendant, @NotNull List<NlComponent> potentialAncestors) {
        for (NlComponent component2 : potentialAncestors) {
            for (NlComponent same = potentialDescendant; same != null; same = same.getParent()) {
                if (same != component2) continue;
                return true;
            }
        }
        return false;
    }
}

