/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DependencyManager {
    private final Project myProject;
    private final Set<String> myMissingLibraries;
    private Module myModule;
    private Palette myPalette;

    public DependencyManager(@NotNull Project project, @NotNull JComponent paletteUI, @NotNull Disposable parentDisposable) {
        this.myProject = project;
        this.myMissingLibraries = new HashSet<String>();
        this.registerDependencyUpdates(paletteUI, parentDisposable);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public void setPalette(@NotNull Palette palette, @NotNull Module module) {
        this.myPalette = palette;
        this.myModule = module;
        this.checkForNewMissingDependencies();
    }

    public boolean needsLibraryLoad(@NotNull Palette.Item item) {
        return this.myMissingLibraries.contains(item.getGradleCoordinateId());
    }

    @NotNull
    public Icon createItemIcon(@NotNull Palette.Item item, @NotNull Component componentContext) {
        return this.createItemIcon(item, item.getIcon(), AndroidIcons.Views.DownloadOverlay, componentContext);
    }

    @NotNull
    public Icon createLargeItemIcon(@NotNull Palette.Item item, @NotNull Component componentContext) {
        return this.createItemIcon(item, item.getLargeIcon(), AndroidIcons.Views.DownloadOverlayLarge, componentContext);
    }

    @NotNull
    private Icon createItemIcon(@NotNull Palette.Item item, @NotNull Icon icon, @NotNull Icon downloadIcon, @NotNull Component componentContext) {
        if (!this.needsLibraryLoad(item)) {
            return icon;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int offset = JBUI.scale((int)1);
        Polygon triangle = new Polygon();
        triangle.addPoint(width / 3, height);
        triangle.addPoint(width, height);
        triangle.addPoint(width, height / 3);
        BufferedImage image = UIUtil.createImage((int)(width + offset), (int)(height + offset), (int)2);
        Area clip = new Area(new Rectangle(0, 0, width, height));
        clip.subtract(new Area(triangle));
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setClip(clip);
        icon.paintIcon(componentContext, g2, 0, 0);
        g2.setClip(null);
        downloadIcon.paintIcon(componentContext, g2, offset, offset);
        g2.dispose();
        return new JBImageIcon((Image)(UIUtil.isRetina() ? ImageUtils.convertToRetinaIgnoringFailures((BufferedImage)image) : image));
    }

    private boolean checkForNewMissingDependencies() {
        List<GradleCoordinate> coordinates;
        GradleDependencyManager manager;
        Set<Object> missing = Collections.emptySet();
        if (this.myModule != null && !this.myModule.isDisposed() && this.myMissingLibraries.equals(missing = DependencyManager.fromGradleCoordinatesToIds((manager = GradleDependencyManager.getInstance(this.myProject)).findMissingDependencies(this.myModule, coordinates = DependencyManager.toGradleCoordinatesFromIds(this.myPalette.getGradleCoordinateIds()))))) {
            return false;
        }
        this.myMissingLibraries.clear();
        this.myMissingLibraries.addAll(missing);
        return true;
    }

    private void registerDependencyUpdates(final @NotNull JComponent paletteUI, @NotNull Disposable parentDisposable) {
        GradleSyncState.subscribe(this.myProject, new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (DependencyManager.this.checkForNewMissingDependencies()) {
                    paletteUI.repaint();
                }
            }
        }, parentDisposable);
    }

    @NotNull
    private static Set<String> fromGradleCoordinatesToIds(@NotNull Collection<GradleCoordinate> coordinates) {
        return coordinates.stream().map(GradleCoordinate::getId).filter(dependency -> dependency != null).collect(Collectors.toSet());
    }

    @NotNull
    private static List<GradleCoordinate> toGradleCoordinatesFromIds(@NotNull Collection<String> dependencies2) {
        return dependencies2.stream().map(dependency -> GradleCoordinate.parseCoordinateString((String)(dependency + ":+"))).filter(coordinate -> coordinate != null).collect(Collectors.toList());
    }
}

