/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.FileResourceRepository;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ActionMenuViewHandler;
import com.android.tools.idea.uibuilder.handlers.CustomViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.CustomViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceCategoryHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceHandler;
import com.android.tools.idea.uibuilder.menu.MenuHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.google.common.base.Charsets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import icons.AndroidIcons;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.xml.bind.JAXBException;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPaletteModel
implements Disposable {
    static final String THIRD_PARTY_GROUP = "3rd Party";
    static final String PROJECT_GROUP = "Project";
    private static final Function<Project, Query<PsiClass>> VIEW_CLASSES_QUERY = project -> {
        PsiClass viewClass = JavaPsiFacade.getInstance((Project)project).findClass("android.view.View", GlobalSearchScope.allScope((Project)project));
        if (viewClass == null) {
            return EmptyQuery.getEmptyQuery();
        }
        return ClassInheritorsSearch.search((PsiClass)viewClass, (SearchScope)ProjectScope.getProjectScope((Project)project), (boolean)true);
    };
    private final Map<NlLayoutType, Palette> myTypeToPalette = new EnumMap<NlLayoutType, Palette>(NlLayoutType.class);
    private final Module myModule;
    private UpdateListener myListener;

    public void dispose() {
        this.myListener = null;
    }

    public static NlPaletteModel get(@NotNull AndroidFacet facet) {
        return (NlPaletteModel)facet.getModule().getComponent(NlPaletteModel.class);
    }

    private NlPaletteModel(@NotNull Module module) {
        this.myModule = module;
        Disposer.register((Disposable)module, (Disposable)this);
    }

    @NotNull
    Palette getPalette(@NotNull NlLayoutType type) {
        assert (type.isSupportedByDesigner());
        Palette palette = this.myTypeToPalette.get((Object)type);
        if (palette == null) {
            this.loadPalette(type);
            return this.myTypeToPalette.get((Object)type);
        }
        return palette;
    }

    public void setUpdateListener(@NotNull UpdateListener updateListener) {
        this.myListener = updateListener;
    }

    private void loadPalette(@NotNull NlLayoutType type) {
        try {
            Palette palette;
            String metadata = type.getPaletteFileName();
            URL url = NlPaletteModel.class.getResource(metadata);
            URLConnection connection = url.openConnection();
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream(), Charsets.UTF_8);){
                palette = this.loadPalette(reader, type);
            }
            this.loadAdditionalComponents(type, palette, VIEW_CLASSES_QUERY);
            AndroidProjectBuildNotifications.subscribe(this.myModule.getProject(), this, context -> this.loadAdditionalComponents(type, palette, VIEW_CLASSES_QUERY));
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    void loadAdditionalComponents(@NotNull NlLayoutType type, @NotNull Palette palette, @NotNull Function<Project, Query<PsiClass>> viewClasses) {
        Project project = this.myModule.getProject();
        DumbService dumbService = DumbService.getInstance((Project)project);
        if (dumbService.isDumb()) {
            dumbService.runWhenSmart(() -> this.loadAdditionalComponents(type, palette, viewClasses));
        } else {
            palette.getItems().stream().filter(Palette.Group.class::isInstance).map(Palette.Group.class::cast).filter(g -> PROJECT_GROUP.equals(g.getName()) || THIRD_PARTY_GROUP.equals(g.getName())).map(Palette.Group::getItems).forEach(List::clear);
            this.loadThirdPartyLibraryComponents(type, palette);
            this.loadProjectComponents(type, palette, viewClasses);
        }
        UpdateListener listener = this.myListener;
        if (listener != null) {
            ApplicationManager.getApplication().invokeLater(listener::update);
        }
    }

    @NotNull
    Palette loadPalette(@NotNull Reader reader, @NotNull NlLayoutType type) throws JAXBException {
        Palette palette = Palette.parse(reader, ViewHandlerManager.get(this.myModule.getProject()));
        this.myTypeToPalette.put(type, palette);
        return palette;
    }

    private void loadThirdPartyLibraryComponents(@NotNull NlLayoutType type, @NotNull Palette palette) {
        AppResourceRepository appResourceRepository = AppResourceRepository.getOrCreateInstance(this.myModule);
        if (appResourceRepository == null) {
            return;
        }
        for (FileResourceRepository fileResourceRepository : appResourceRepository.getLibraries()) {
        }
    }

    private void loadProjectComponents(@NotNull NlLayoutType type, @NotNull Palette palette, @NotNull Function<Project, Query<PsiClass>> viewClasses) {
        Project project = this.myModule.getProject();
        viewClasses.apply(project).forEach(psiClass -> {
            String description = psiClass.getName();
            String className = psiClass.getQualifiedName();
            if (description == null || className == null) {
                return false;
            }
            this.addAdditionalComponent(type, PROJECT_GROUP, palette, AndroidIcons.Android, AndroidIcons.Android24, className, null, null, "", null, Collections.emptyList(), Collections.emptyList());
            return true;
        });
    }

    boolean addAdditionalComponent(@NotNull NlLayoutType type, @NotNull String groupName, @NotNull Palette palette, @Nullable Icon icon16, @Nullable Icon icon24, @NotNull String tagName, @Nullable @Language(value="XML") String xml, @Nullable @Language(value="XML") String previewXml, @NotNull String libraryCoordinate, @Nullable String preferredProperty, @NotNull List<String> properties, @NotNull List<String> layoutProperties) {
        if (tagName.indexOf(46) < 0 || !NlComponentHelper.INSTANCE.viewClassToTag(tagName).equals(tagName) || tagName.equals("android.support.constraint.ConstraintLayout")) {
            return false;
        }
        ViewHandlerManager manager = ViewHandlerManager.get(this.myModule.getProject());
        ViewHandler handler = manager.getHandlerOrDefault(tagName);
        if (type != NlLayoutType.LAYOUT || handler instanceof PreferenceHandler || handler instanceof PreferenceCategoryHandler || handler instanceof MenuHandler || handler instanceof ActionMenuViewHandler) {
            return false;
        }
        handler = handler instanceof ViewGroupHandler ? new CustomViewGroupHandler((ViewGroupHandler)handler, icon16, icon24, tagName, xml, previewXml, libraryCoordinate, preferredProperty, properties, layoutProperties) : new CustomViewHandler(handler, icon16, icon24, tagName, xml, previewXml, libraryCoordinate, preferredProperty, properties);
        List<Palette.BaseItem> groups = palette.getItems();
        Palette.Group group = groups.stream().filter(Palette.Group.class::isInstance).map(Palette.Group.class::cast).filter(g -> groupName.equals(g.getName())).findFirst().orElse(null);
        if (group == null) {
            group = new Palette.Group(groupName);
            groups.add(group);
        }
        group.getItems().add(new Palette.Item(tagName, handler));
        manager.registerHandler(tagName, handler);
        return true;
    }

    private static Logger getLogger() {
        return Logger.getLogger(NlPaletteModel.class.getSimpleName());
    }

    public static interface UpdateListener {
        public void update();
    }
}

