/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.adtui.workbench.StartFilteringListener;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.IconPreviewFactory;
import com.android.tools.idea.uibuilder.palette.NlPaletteModel;
import com.android.tools.idea.uibuilder.palette.NlPaletteTreeGrid;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette.PaletteMode;
import com.android.tools.idea.uibuilder.palette.TogglePaletteModeAction;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPalettePanel
extends JPanel
implements Disposable,
DataProvider,
ToolContent<DesignSurface> {
    static final String PALETTE_MODE = "palette.mode";
    private final CopyProvider myCopyProvider;
    private final NlPaletteTreeGrid myPalettePanel;
    private final DependencyManager myDependencyManager;
    private final CopyPasteManager myCopyPasteManager;
    private NlLayoutType myLayoutType;
    private Runnable myCloseAutoHideCallback;

    public NlPalettePanel(@NotNull Project project, @Nullable NlDesignSurface designSurface) {
        this(project, designSurface, CopyPasteManager.getInstance());
    }

    NlPalettePanel(@NotNull Project project, @Nullable NlDesignSurface designSurface, @NotNull CopyPasteManager copyPasteManager) {
        this.myCopyPasteManager = copyPasteManager;
        IconPreviewFactory iconPreviewFactory = new IconPreviewFactory();
        Disposer.register((Disposable)this, (Disposable)iconPreviewFactory);
        this.myDependencyManager = new DependencyManager(project, this, this);
        this.myPalettePanel = new NlPaletteTreeGrid(project, NlPalettePanel.getInitialMode(), this.myDependencyManager, this::closeAutoHideToolWindow, designSurface, iconPreviewFactory);
        this.myCopyProvider = new CopyProviderImpl();
        this.myLayoutType = NlLayoutType.UNKNOWN;
        Disposer.register((Disposable)this, (Disposable)this.myPalettePanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myPalettePanel, "Center");
        this.setToolContext(designSurface);
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    @NotNull
    public JComponent getFocusedComponent() {
        return this.myPalettePanel;
    }

    @Override
    public void requestFocus() {
        this.myPalettePanel.requestFocus();
    }

    @NotNull
    public NlPaletteTreeGrid getTreeGrid() {
        return this.myPalettePanel;
    }

    @NotNull
    public List<AnAction> getGearActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>(3);
        actions.add((AnAction)new TogglePaletteModeAction(this, PaletteMode.ICON_AND_NAME));
        actions.add((AnAction)new TogglePaletteModeAction(this, PaletteMode.LARGE_ICONS));
        actions.add((AnAction)new TogglePaletteModeAction(this, PaletteMode.SMALL_ICONS));
        return actions;
    }

    public void setCloseAutoHideWindow(@NotNull Runnable runnable) {
        this.myCloseAutoHideCallback = runnable;
    }

    public boolean supportsFiltering() {
        return true;
    }

    public void setFilter(@NotNull String filter) {
        this.myPalettePanel.setFilter(filter);
    }

    public void setStartFiltering(@NotNull StartFilteringListener listener) {
        this.myPalettePanel.setStartFiltering(listener);
    }

    public void setToolContext(@Nullable DesignSurface designSurface) {
        assert (designSurface == null || designSurface instanceof NlDesignSurface);
        Module module = NlPalettePanel.getModule(designSurface);
        if (designSurface != null && module != null && this.myLayoutType != designSurface.getLayoutType()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null);
            this.myLayoutType = designSurface.getLayoutType();
            NlPaletteModel model = NlPaletteModel.get(facet);
            model.setUpdateListener(() -> this.reloadPalette(model, module, designSurface));
            this.reloadPalette(model, module, designSurface);
        }
    }

    private void reloadPalette(NlPaletteModel model, Module module, DesignSurface designSurface) {
        Palette palette = model.getPalette(this.myLayoutType);
        this.myPalettePanel.populateUiModel(palette, (NlDesignSurface)designSurface);
        this.myDependencyManager.setPalette(palette, module);
        this.repaint();
    }

    private void closeAutoHideToolWindow() {
        if (this.myCloseAutoHideCallback != null) {
            this.myCloseAutoHideCallback.run();
        }
    }

    @Nullable
    private static Module getModule(@Nullable DesignSurface designSurface) {
        Configuration configuration = designSurface != null && designSurface.getLayoutType().isSupportedByDesigner() ? designSurface.getConfiguration() : null;
        return configuration != null ? configuration.getModule() : null;
    }

    @NotNull
    public PaletteMode getMode() {
        return this.myPalettePanel.getMode();
    }

    public void setMode(@NotNull PaletteMode mode) {
        this.myPalettePanel.setMode(mode);
        PropertiesComponent.getInstance().setValue(PALETTE_MODE, mode.toString(), PaletteMode.ICON_AND_NAME.toString());
    }

    private static PaletteMode getInitialMode() {
        try {
            return PaletteMode.valueOf(PropertiesComponent.getInstance().getValue(PALETTE_MODE, PaletteMode.ICON_AND_NAME.toString()));
        }
        catch (IllegalArgumentException unused) {
            return PaletteMode.ICON_AND_NAME;
        }
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return PlatformDataKeys.COPY_PROVIDER.is(dataId) ? this.myCopyProvider : null;
    }

    private class CopyProviderImpl
    implements CopyProvider {
        private CopyProviderImpl() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            Palette.Item item = NlPalettePanel.this.myPalettePanel.getSelectedItem();
            if (item != null && !NlPalettePanel.this.myDependencyManager.needsLibraryLoad(item)) {
                DnDTransferComponent component2 = new DnDTransferComponent(item.getTagName(), item.getXml(), 0, 0);
                NlPalettePanel.this.myCopyPasteManager.setContents((Transferable)new ItemTransferable(new DnDTransferItem(component2)));
            }
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            Palette.Item item = NlPalettePanel.this.myPalettePanel.getSelectedItem();
            return item != null && !NlPalettePanel.this.myDependencyManager.needsLibraryLoad(item);
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            return true;
        }
    }
}

