/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.splitter.ComponentsSplitter;
import com.android.tools.adtui.splitter.SplitterUtil;
import com.android.tools.adtui.treegrid.TreeGrid;
import com.android.tools.adtui.workbench.StartFilteringListener;
import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.actions.ComponentHelpAction;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.IconPreviewFactory;
import com.android.tools.idea.uibuilder.palette.ItemTransferHandler;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette.PaletteMode;
import com.android.tools.idea.uibuilder.palette.SelectionListener;
import com.android.tools.idea.uibuilder.palette.SingleListTreeProvider;
import com.android.tools.idea.uibuilder.palette.TreeCategoryProvider;
import com.android.tools.idea.uibuilder.palette.TreeProvider;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPaletteTreeGrid
extends JPanel
implements Disposable {
    static final String PALETTE_CATEGORY_WIDTH = "palette.category.width";
    static final int DEFAULT_CATEGORY_WIDTH = 100;
    private static final int VERTICAL_SCROLLING_UNIT_INCREMENT = 20;
    private static final int VERTICAL_SCROLLING_BLOCK_INCREMENT = 40;
    private final Project myProject;
    private final DependencyManager myDependencyManager;
    private final Runnable myCloseAutoHideCallback;
    private final JList<Palette.Group> myCategoryList;
    private final TreeGrid<Palette.Item> myTree;
    private final MyFilter myFilter;
    private final IconPreviewFactory myIconPreviewFactory;
    private final ComponentsSplitter mySplitter;
    private PaletteMode myMode;
    private SelectionListener myListener;
    private NlDesignSurface mySurface;
    private Palette myPalette;
    private StartFilteringListener myStartFilteringCallback;

    public NlPaletteTreeGrid(@NotNull Project project, @NotNull PaletteMode initialMode, @NotNull DependencyManager dependencyManager, @NotNull Runnable closeAutoHideCallback, @Nullable NlDesignSurface designSurface, @NotNull IconPreviewFactory iconFactory) {
        this.myProject = project;
        this.myDependencyManager = dependencyManager;
        this.myCloseAutoHideCallback = closeAutoHideCallback;
        this.mySurface = designSurface;
        this.myMode = initialMode;
        this.myIconPreviewFactory = iconFactory;
        this.myTree = NlPaletteTreeGrid.createItemTreeGrid(project);
        this.myTree.addListSelectionListener(event -> this.fireSelectionChanged((Palette.Item)this.myTree.getSelectedElement()));
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(@NotNull KeyEvent event) {
                NlPaletteTreeGrid.this.handleKeyEvent(event);
            }
        });
        this.myCategoryList = new JBList();
        this.myCategoryList.setBackground(UIUtil.getPanelBackground());
        this.myCategoryList.setForeground(UIManager.getColor("Panel.foreground"));
        this.myCategoryList.addListSelectionListener(this::categorySelectionChanged);
        this.myCategoryList.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.myCategoryList.setCellRenderer((ListCellRenderer<Palette.Group>)((Object)new MyCategoryCellRenderer()));
        this.myFilter = new MyFilter();
        JScrollPane categoryPane = ScrollPaneFactory.createScrollPane(this.myCategoryList, (int)20, (int)31);
        categoryPane.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane paletteScrollPane = ScrollPaneFactory.createScrollPane(this.myTree, (int)20, (int)31);
        paletteScrollPane.setFocusable(false);
        paletteScrollPane.setBorder(BorderFactory.createEmptyBorder());
        paletteScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        paletteScrollPane.getVerticalScrollBar().setBlockIncrement(40);
        this.mySplitter = new ComponentsSplitter(false, true);
        this.mySplitter.setFirstComponent((JComponent)categoryPane);
        this.mySplitter.setInnerComponent((JComponent)paletteScrollPane);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstSize(JBUI.scale((int)NlPaletteTreeGrid.getInitialCategoryWidth()));
        this.mySplitter.setFocusCycleRoot(false);
        this.myCategoryList.addComponentListener(this.createCategoryWidthUpdater());
        SplitterUtil.setMinimumWidth((JComponent)categoryPane, (int)JBUI.scale((int)20));
        SplitterUtil.setMinimumWidth((JComponent)paletteScrollPane, (int)JBUI.scale((int)20));
        Disposer.register((Disposable)this, (Disposable)this.mySplitter);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mySplitter, "Center");
        this.setFocusTraversalPolicyProvider(true);
    }

    private static TreeGrid<Palette.Item> createItemTreeGrid(@NotNull Project project) {
        TreeGrid grid = new TreeGrid();
        grid.setName("itemTreeGrid");
        ComponentHelpAction help = new ComponentHelpAction(project, () -> {
            Palette.Item item = (Palette.Item)grid.getSelectedElement();
            return item != null ? item.getTagName() : null;
        });
        help.registerCustomShortcutSet(112, 1, (JComponent)grid);
        return grid;
    }

    @Override
    public void requestFocus() {
        NlUsageTrackerManager.getInstance(this.mySurface).logAction(LayoutEditorEvent.LayoutEditorEventType.SHOW_PALETTE);
        this.myTree.requestFocus();
    }

    @NotNull
    public PaletteMode getMode() {
        return this.myMode;
    }

    public void setMode(@NotNull PaletteMode mode) {
        this.myMode = mode;
        int fixedCellWidth = -1;
        int fixedCellHeight = -1;
        int border = JBUI.scale((int)mode.getBorder());
        int orientation = 2;
        switch (mode) {
            case ICON_AND_NAME: {
                orientation = 0;
                break;
            }
            case LARGE_ICONS: {
                fixedCellWidth = fixedCellHeight = border + JBUI.scale((int)24) + border;
                break;
            }
            case SMALL_ICONS: {
                fixedCellWidth = fixedCellHeight = border + JBUI.scale((int)16) + border;
            }
        }
        this.myTree.setFixedCellWidth(fixedCellWidth);
        this.myTree.setFixedCellHeight(fixedCellHeight);
        this.myTree.setLayoutOrientation(orientation);
        this.myTree.setCellRenderer((ListCellRenderer)((Object)new MyCellRenderer(this.myDependencyManager, mode)));
    }

    public void setStartFiltering(@NotNull StartFilteringListener listener) {
        this.myStartFilteringCallback = listener;
    }

    public void populateUiModel(@NotNull Palette palette, @NotNull NlDesignSurface designSurface) {
        this.mySurface = designSurface;
        this.myPalette = palette;
        this.myCategoryList.setModel(new TreeCategoryProvider(palette));
        if (this.myCategoryList.getSelectedValue() == null) {
            this.myCategoryList.setSelectedValue(TreeCategoryProvider.ALL, true);
        }
        this.updateTreeModel();
    }

    private void updateTreeModel() {
        AbstractTreeStructure provider = this.myCategoryList.getModel().getSize() > 1 && this.myFilter.getPattern().isEmpty() ? new TreeProvider(this.myProject, this.myPalette) : new SingleListTreeProvider(this.myProject, this.myPalette);
        this.myTree.setModel(provider);
        this.myTree.setVisibleSection((Object)this.myCategoryList.getSelectedValue());
        this.myTree.setTransferHandler((TransferHandler)new MyItemTransferHandler(this.mySurface, this.myDependencyManager, this::getSelectedItem, this.myIconPreviewFactory));
        this.setMode(this.myMode);
    }

    public void setFilter(@NotNull String pattern) {
        String oldPattern = this.myFilter.getPattern();
        this.myFilter.setPattern(pattern);
        if (pattern.isEmpty()) {
            if (!oldPattern.isEmpty()) {
                this.updateTreeModel();
                this.myTree.setVisibleSection((Object)this.myCategoryList.getSelectedValue());
            }
            this.myTree.setFilter(null);
        } else {
            if (oldPattern.isEmpty()) {
                this.updateTreeModel();
                this.myTree.setVisibleSection((Object)TreeCategoryProvider.ALL.getName());
            }
            this.myTree.setFilter((Condition)this.myFilter);
            this.myTree.selectIfUnique();
        }
    }

    @NotNull
    public String getFilter() {
        return this.myFilter.getPattern();
    }

    private void categorySelectionChanged(@Nullable ListSelectionEvent event) {
        if (this.myFilter.getPattern().isEmpty()) {
            this.myTree.setVisibleSection((Object)this.myCategoryList.getSelectedValue());
            Palette.Item selected = (Palette.Item)this.myTree.getSelectedVisibleElement();
            if (selected == null) {
                this.myTree.getFocusRecipient();
            }
        }
    }

    public void setSelectionListener(@NotNull SelectionListener listener) {
        this.myListener = listener;
    }

    public void fireSelectionChanged(@Nullable Palette.Item item) {
        if (this.myListener != null) {
            this.myListener.selectionChanged(item);
        }
    }

    public void handleKeyEvent(@NotNull KeyEvent event) {
        if (this.myStartFilteringCallback != null) {
            this.myStartFilteringCallback.startFiltering(event.getKeyChar());
        }
    }

    @Nullable
    public Palette.Item getSelectedItem() {
        return (Palette.Item)this.myTree.getSelectedElement();
    }

    @NotNull
    private ComponentListener createCategoryWidthUpdater() {
        return new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                PropertiesComponent.getInstance().setValue(NlPaletteTreeGrid.PALETTE_CATEGORY_WIDTH, String.valueOf(AdtUiUtils.unscale((int)NlPaletteTreeGrid.this.mySplitter.getFirstSize())));
            }
        };
    }

    private static int getInitialCategoryWidth() {
        try {
            return Integer.parseInt(PropertiesComponent.getInstance().getValue(PALETTE_CATEGORY_WIDTH, String.valueOf(100)));
        }
        catch (NumberFormatException unused) {
            return 100;
        }
    }

    @NotNull
    public JList<Palette.Group> getCategoryList() {
        return this.myCategoryList;
    }

    @NotNull
    public TreeGrid<Palette.Item> getComponentTree() {
        return this.myTree;
    }

    @NotNull
    public ComponentsSplitter getSplitter() {
        return this.mySplitter;
    }

    public void dispose() {
    }

    private static class MyFilter
    implements Condition<Palette.Item> {
        private final SpeedSearchComparator myComparator = new SpeedSearchComparator(false);
        private String myPattern = "";

        public void setPattern(@NotNull String filter) {
            this.myPattern = filter;
        }

        @NotNull
        public String getPattern() {
            return this.myPattern;
        }

        public boolean value(@NotNull Palette.Item item) {
            return this.myComparator.matchingFragments(this.myPattern, item.getTitle()) != null;
        }
    }

    private static class MyCellRenderer
    extends ColoredListCellRenderer<Palette.Item> {
        private final DependencyManager myDependencyManager;
        private final PaletteMode myMode;

        private MyCellRenderer(@NotNull DependencyManager dependencyManager, @NotNull PaletteMode mode) {
            this.myDependencyManager = dependencyManager;
            this.myMode = mode;
            int padding = mode.getBorder();
            this.setIpad((Insets)new JBInsets(padding, Math.max(4, padding), padding, padding));
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        protected void customizeCellRenderer(@NotNull JList list, @NotNull Palette.Item item, int index, boolean selected, boolean hasFocus) {
            if (selected) {
                this.setBackground(UIUtil.getTreeSelectionBackground((boolean)hasFocus));
                this.mySelectionForeground = UIUtil.getTreeForeground((boolean)true, (boolean)hasFocus);
            }
            switch (this.myMode) {
                case ICON_AND_NAME: {
                    this.setIcon(this.myDependencyManager.createItemIcon(item, list));
                    this.append(item.getTitle());
                    break;
                }
                case LARGE_ICONS: {
                    this.setIcon(this.myDependencyManager.createLargeItemIcon(item, list));
                    this.setToolTipText(item.getTitle());
                    break;
                }
                case SMALL_ICONS: {
                    this.setIcon(this.myDependencyManager.createItemIcon(item, list));
                    this.setToolTipText(item.getTitle());
                }
            }
        }
    }

    private static class MyCategoryCellRenderer
    extends ColoredListCellRenderer<Palette.Group> {
        private MyCategoryCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list, @NotNull Palette.Group group, int index, boolean selected, boolean hasFocus) {
            if (selected) {
                this.setBackground(UIUtil.getTreeSelectionBackground((boolean)hasFocus));
                this.mySelectionForeground = UIUtil.getTreeForeground((boolean)true, (boolean)hasFocus);
            }
            this.append(group.getName());
        }
    }

    private class MyItemTransferHandler
    extends ItemTransferHandler {
        public MyItemTransferHandler(@NotNull DesignSurface designSurface, @NotNull DependencyManager dependencyManager, @NotNull Supplier<Palette.Item> itemSupplier, IconPreviewFactory iconPreviewFactory) {
            super(designSurface, dependencyManager, itemSupplier, iconPreviewFactory);
        }

        @Override
        protected Transferable createTransferable(@NotNull JComponent component2) {
            Transferable transferable = super.createTransferable(component2);
            NlPaletteTreeGrid.this.myCloseAutoHideCallback.run();
            return transferable;
        }

        @Override
        protected void exportDone(@NotNull JComponent source, @Nullable Transferable data, int action) {
            DnDTransferComponent component2;
            if (action != 0 && data != null && (component2 = this.getDndComponent(data)) != null) {
                NlUsageTrackerManager.getInstance(NlPaletteTreeGrid.this.mySurface).logDropFromPalette(component2.getTag(), component2.getRepresentation(), NlPaletteTreeGrid.this.myMode, this.getGroupName(), NlPaletteTreeGrid.this.myTree.getFilterMatchCount());
            }
        }

        @NotNull
        private String getGroupName() {
            Palette.Group group = (Palette.Group)NlPaletteTreeGrid.this.myCategoryList.getSelectedValue();
            return group != null ? group.getName() : "";
        }

        @Nullable
        private DnDTransferComponent getDndComponent(@NotNull Transferable data) {
            try {
                ImmutableList<DnDTransferComponent> components;
                DnDTransferItem item = (DnDTransferItem)data.getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                if (item != null && (components = item.getComponents()).size() == 1) {
                    return (DnDTransferComponent)components.get(0);
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Logger.getInstance(NlPaletteTreeGrid.class).warn("Could not un-serialize a transferable", (Throwable)ex);
            }
            return null;
        }
    }
}

