/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.google.common.collect.Table;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddPropertyItem
extends PTableItem {
    private final Table<String, String, NlPropertyItem> myProperties;
    private String myName = "";
    private NlProperty myProperty = EmptyProperty.INSTANCE;

    public AddPropertyItem(@NotNull Table<String, String, NlPropertyItem> properties) {
        this.myProperties = properties;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getValue() {
        return this.myProperty.getValue();
    }

    @NotNull
    public NlProperty getProperty() {
        return this.myProperty;
    }

    @NotNull
    public List<String> getUnspecifiedProperties() {
        ArrayList<String> items = new ArrayList<String>();
        for (String namespace : this.myProperties.rowKeySet()) {
            if (namespace.equals("http://schemas.android.com/tools")) continue;
            for (NlPropertyItem property : this.myProperties.row((Object)namespace).values()) {
                NlProperty designProperty;
                if (property.getValue() == null) {
                    AddPropertyItem.addProperty(items, namespace, property.getName());
                }
                if ((designProperty = (NlProperty)this.myProperties.get((Object)"http://schemas.android.com/tools", (Object)property.getName())) != null && designProperty.getValue() != null) continue;
                AddPropertyItem.addProperty(items, "http://schemas.android.com/tools", property.getName());
            }
        }
        return items;
    }

    private static void addProperty(@NotNull List<String> items, @NotNull String namespace, @NotNull String name) {
        String prefix = "";
        switch (namespace) {
            case "http://schemas.android.com/apk/res/android": {
                prefix = "android:";
                break;
            }
            case "http://schemas.android.com/apk/res-auto": {
                prefix = "app:";
                break;
            }
            case "http://schemas.android.com/tools": {
                prefix = "tools:";
            }
        }
        items.add(prefix + name);
    }

    @NotNull
    public NlProperty findPropertyByQualifiedName(@NotNull String name) {
        NlProperty property;
        String namespace = "";
        String propertyName = name;
        List names = StringUtil.split((String)name, (String)":", (boolean)false);
        if (names.size() > 1) {
            namespace = AddPropertyItem.convertNamespacePrefix((String)names.get(0));
            propertyName = (String)names.get(1);
        }
        if ((property = (NlProperty)this.myProperties.get((Object)namespace, (Object)propertyName)) == null && namespace.equals("http://schemas.android.com/tools")) {
            property = (NlProperty)this.myProperties.get((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyName);
            if (property == null) {
                property = (NlProperty)this.myProperties.get((Object)"http://schemas.android.com/apk/res/android", (Object)propertyName);
            }
            return property != null ? property.getDesignTimeProperty() : EmptyProperty.INSTANCE;
        }
        return property != null && property.getValue() == null ? property : EmptyProperty.INSTANCE;
    }

    private static String convertNamespacePrefix(@NotNull String prefix) {
        switch (prefix) {
            case "android:": {
                return "http://schemas.android.com/apk/res/android";
            }
            case "app:": {
                return "http://schemas.android.com/apk/res-auto";
            }
            case "tools:": {
                return "http://schemas.android.com/tools";
            }
        }
        return "";
    }

    public boolean isEditable(int column) {
        return column == 0 || this.isPropertyNameSelected();
    }

    public int getColumnToEdit() {
        return this.isPropertyNameSelected() ? 1 : 0;
    }

    public void setValue(@Nullable Object value) {
        if (!this.isPropertyNameSelected()) {
            this.myName = value == null ? "" : value.toString().trim();
        } else {
            this.myProperty.setValue(value);
        }
    }

    public void updateProperty() {
        this.myProperty = this.findPropertyByQualifiedName(this.myName);
    }

    public boolean isPropertyNameSelected() {
        return this.myProperty != EmptyProperty.INSTANCE;
    }
}

