/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItemValue;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlPropertyRenderers;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.XmlName;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlFlagPropertyItem
extends NlPropertyItem
implements NlProperty {
    private List<PTableItem> myItems;
    private long myLastRead;
    private String myLastValue;
    private String myLastFormattedValue;
    private Set<String> myLastValues;
    private int myMaskValue;
    private boolean myExpanded;
    private static final Splitter VALUE_SPLITTER = Splitter.on((String)"|").trimResults();

    protected NlFlagPropertyItem(@NotNull XmlName name, @Nullable AttributeDefinition attributeDefinition, @NotNull List<NlComponent> components, @NotNull NlPropertiesManager propertiesManager) {
        super(name, attributeDefinition, components, propertiesManager);
        assert (attributeDefinition != null);
    }

    protected NlFlagPropertyItem(@NotNull NlFlagPropertyItem property, @NotNull String namespace) {
        super(property, namespace);
    }

    public boolean hasChildren() {
        return true;
    }

    @NotNull
    public List<PTableItem> getChildren() {
        if (this.myItems == null) {
            assert (this.myDefinition != null);
            this.myItems = Lists.newArrayListWithCapacity((int)this.myDefinition.getValues().length);
            for (String value : this.myDefinition.getValues()) {
                this.myItems.add(new NlFlagPropertyItemValue(value, this.lookupMaskValue(value), this));
            }
        }
        return this.myItems;
    }

    private int lookupMaskValue(@NotNull String value) {
        assert (this.myDefinition != null);
        Integer mappedValue = this.myDefinition.getValueMapping(value);
        if (mappedValue != null) {
            return mappedValue;
        }
        int index = ArrayUtil.indexOf((Object[])this.myDefinition.getValues(), (Object)value);
        return index < 0 ? 0 : 1 << index;
    }

    @Override
    @NotNull
    public NlFlagPropertyItemValue getChildProperty(@NotNull String itemName) {
        for (PTableItem child : this.getChildren()) {
            if (!child.getName().equals(itemName)) continue;
            return (NlFlagPropertyItemValue)child;
        }
        throw new IllegalArgumentException(itemName);
    }

    @Override
    @NotNull
    public NlFlagPropertyItem getDesignTimeProperty() {
        if ("http://schemas.android.com/tools".equals(this.getNamespace())) {
            return this;
        }
        return new NlFlagPropertyItem(this, "http://schemas.android.com/tools");
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.myExpanded = expanded;
    }

    @Override
    public boolean isEditable(int col) {
        return false;
    }

    @Override
    @Nullable
    public String getValue() {
        this.cacheValues();
        return this.myLastValue;
    }

    @Override
    public void setValue(@Nullable Object value) {
        String strValue;
        String string = strValue = value == null ? null : value.toString();
        if (StringUtil.isEmpty((String)strValue)) {
            strValue = null;
        }
        this.setValueIgnoreDefaultValue(strValue, this::invalidateCachedValues);
    }

    public int getMaskValue() {
        return this.myMaskValue;
    }

    public String getFormattedValue() {
        this.cacheValues();
        return this.myLastFormattedValue;
    }

    @NotNull
    private Set<String> getValues() {
        this.cacheValues();
        return this.myLastValues;
    }

    private void invalidateCachedValues() {
        this.myLastValues = null;
    }

    private void cacheValues() {
        if (this.myLastValues != null && this.myLastRead == this.getModel().getModificationCount()) {
            return;
        }
        HashSet values = Collections.emptySet();
        String rawValue = super.getValue();
        String formattedValue = "[]";
        if (rawValue != null) {
            List valueList = VALUE_SPLITTER.splitToList((CharSequence)StringUtil.notNullize((String)rawValue));
            values = Sets.newHashSet((Iterable)valueList);
            formattedValue = "[" + Joiner.on((String)", ").join((Iterable)valueList) + "]";
        }
        String resolvedValue = this.resolveValue(rawValue);
        int maskValue = 0;
        if (resolvedValue != null) {
            HashSet maskValues = resolvedValue.equals(rawValue) ? values : VALUE_SPLITTER.splitToList((CharSequence)StringUtil.notNullize((String)resolvedValue));
            for (String value : maskValues) {
                maskValue |= this.lookupMaskValue(value);
            }
        }
        this.myLastValues = values;
        this.myLastValue = rawValue;
        this.myLastFormattedValue = formattedValue;
        this.myLastRead = this.getModel().getModificationCount();
        this.myMaskValue = maskValue;
    }

    public boolean isItemSet(@NotNull NlFlagPropertyItemValue item) {
        return this.isItemSet(item.getName());
    }

    public boolean isItemSet(@NotNull String itemName) {
        return this.getValues().contains(itemName);
    }

    public void setItem(@NotNull NlFlagPropertyItemValue changedItem, boolean on) {
        Set<String> removed = on ? Collections.emptySet() : Collections.singleton(changedItem.getName());
        Set<String> added = on ? Collections.singleton(changedItem.getName()) : Collections.emptySet();
        this.updateItems(added, removed);
    }

    public void updateItems(@NotNull Set<String> added, @NotNull Set<String> removed) {
        Set<String> values = this.getValues();
        StringBuilder builder = new StringBuilder();
        this.getChildren().stream().filter(item -> values.contains(item.getName()) && !removed.contains(item.getName()) || added.contains(item.getName())).forEach(item -> {
            if (builder.length() > 0) {
                builder.append("|");
            }
            builder.append(item.getName());
        });
        String newValue = builder.length() == 0 ? null : builder.toString();
        this.setValue(newValue);
    }

    public void mousePressed(@NotNull PTable table, @NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        NlAttributeRenderer renderer = NlPropertyRenderers.getInstance().get(this);
        renderer.mousePressed(event, rectRightColumn);
    }
}

