/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ImageViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.utils.Pair;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlProperties {
    public static final String STARRED_PROP = "ANDROID.STARRED_PROPERTIES";
    private static NlProperties ourInstance = null;
    private final AndroidDomElementDescriptorProvider myDescriptorProvider = new AndroidDomElementDescriptorProvider();

    public static synchronized NlProperties getInstance() {
        if (ourInstance == null) {
            ourInstance = new NlProperties();
        }
        return ourInstance;
    }

    @NotNull
    public Table<String, String, NlPropertyItem> getProperties(@NotNull NlPropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        AndroidFacet facet = NlProperties.getFacet(components);
        if (facet == null) {
            return ImmutableTable.of();
        }
        return this.getProperties(facet, propertiesManager, components);
    }

    Table<String, String, NlPropertyItem> getProperties(@NotNull AndroidFacet facet, @NotNull NlPropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        return (Table)ApplicationManager.getApplication().runReadAction(() -> this.getPropertiesWithReadLock(facet, propertiesManager, components));
    }

    @NotNull
    private Table<String, String, NlPropertyItem> getPropertiesWithReadLock(@NotNull AndroidFacet facet, @NotNull NlPropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(facet);
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        SystemResourceManager systemResourceManager = resourceManagers.getSystemResourceManager();
        if (systemResourceManager == null) {
            Logger.getInstance(NlProperties.class).error("No system resource manager for module: " + facet.getModule().getName());
            return ImmutableTable.of();
        }
        AttributeDefinitions localAttrDefs = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = ((ResourceManager)systemResourceManager).getAttributeDefinitions();
        Table<String, String, NlPropertyItem> combinedProperties = null;
        for (NlComponent component2 : components) {
            XmlTag tag = component2.getTag();
            if (!tag.isValid()) {
                return ImmutableTable.of();
            }
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                return ImmutableTable.of();
            }
            XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
            HashBasedTable properties = HashBasedTable.create((int)3, (int)descriptors.length);
            for (XmlAttributeDescriptor desc : descriptors) {
                XmlName name = NlProperties.getXmlName(desc, tag);
                AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android".equals(name.getNamespaceKey()) ? systemAttrDefs : localAttrDefs;
                AttributeDefinition attrDef = attrDefs == null ? null : attrDefs.getAttrDefByName(name.getLocalName());
                NlPropertyItem property = NlPropertyItem.create(name, attrDef, components, propertiesManager);
                properties.put((Object)StringUtil.notNullize((String)name.getNamespaceKey()), (Object)property.getName(), (Object)property);
            }
            switch (tag.getName()) {
                case "AutoCompleteTextView": {
                    properties.put((Object)"http://schemas.android.com/apk/res/android", (Object)"popupBackground", (Object)NlPropertyItem.create(new XmlName("popupBackground", "http://schemas.android.com/apk/res/android"), systemAttrDefs != null ? systemAttrDefs.getAttrDefByName("popupBackground") : null, components, propertiesManager));
                }
            }
            combinedProperties = NlProperties.combine((Table<String, String, NlPropertyItem>)properties, combinedProperties);
        }
        assert (combinedProperties != null);
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingStart");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingEnd");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"theme");
        NlProperties.setUpDesignProperties(combinedProperties);
        NlProperties.setUpSrcCompat(combinedProperties, facet, components, propertiesManager);
        NlProperties.initStarState(combinedProperties);
        return combinedProperties;
    }

    @Nullable
    private static AndroidFacet getFacet(@NotNull List<NlComponent> components) {
        if (components.isEmpty()) {
            return null;
        }
        return components.get(0).getModel().getFacet();
    }

    private static void initStarState(@NotNull Table<String, String, NlPropertyItem> properties) {
        for (String starredProperty : NlProperties.getStarredProperties()) {
            Pair<String, String> property = NlProperties.split(starredProperty);
            NlPropertyItem item = (NlPropertyItem)properties.get(property.getFirst(), property.getSecond());
            if (item == null) continue;
            item.setInitialStarred();
        }
    }

    public static void saveStarState(@Nullable String propertyNamespace, @NotNull String propertyName, boolean starred, @NotNull NlPropertiesManager propertiesManager) {
        String propertyNameWithPrefix = NlProperties.getPropertyNameWithPrefix(propertyNamespace, propertyName);
        ArrayList<String> favorites = new ArrayList<String>();
        for (String starredProperty : NlProperties.getStarredProperties()) {
            if (starredProperty.equals(propertyNameWithPrefix)) continue;
            favorites.add(starredProperty);
        }
        if (starred) {
            favorites.add(propertyNameWithPrefix);
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(STARRED_PROP, Joiner.on((char)';').join(favorites));
        String added = starred ? propertyNameWithPrefix : "";
        String removed = !starred ? propertyNameWithPrefix : "";
        propertiesManager.logFavoritesChange(added, removed, favorites);
    }

    public static String getStarredPropertiesAsString() {
        String starredProperties = PropertiesComponent.getInstance().getValue(STARRED_PROP);
        if (starredProperties == null) {
            starredProperties = "visibility";
        }
        return starredProperties;
    }

    public static Iterable<String> getStarredProperties() {
        return Splitter.on((char)';').trimResults().omitEmptyStrings().split((CharSequence)NlProperties.getStarredPropertiesAsString());
    }

    @NotNull
    private static String getPropertyNameWithPrefix(@Nullable String namespace, @NotNull String propertyName) {
        if (namespace == null) {
            return propertyName;
        }
        switch (namespace) {
            case "http://schemas.android.com/tools": {
                return "tools:" + propertyName;
            }
            case "http://schemas.android.com/apk/res/android": {
                return propertyName;
            }
        }
        return "app:" + propertyName;
    }

    @NotNull
    private static Pair<String, String> split(@NotNull String propertyNameWithPrefix) {
        if (propertyNameWithPrefix.startsWith("tools:")) {
            return Pair.of((Object)"http://schemas.android.com/tools", (Object)propertyNameWithPrefix.substring("tools:".length()));
        }
        if (propertyNameWithPrefix.startsWith("app:")) {
            return Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyNameWithPrefix.substring("app:".length()));
        }
        return Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)propertyNameWithPrefix);
    }

    @NotNull
    private static XmlName getXmlName(@NotNull XmlAttributeDescriptor descriptor, @NotNull XmlTag context) {
        String namespace = null;
        if (descriptor instanceof NamespaceAwareXmlAttributeDescriptor) {
            namespace = ((NamespaceAwareXmlAttributeDescriptor)descriptor).getNamespace(context);
        }
        return new XmlName(descriptor.getName(), namespace);
    }

    private static Table<String, String, NlPropertyItem> combine(@NotNull Table<String, String, NlPropertyItem> properties, @Nullable Table<String, String, NlPropertyItem> combinedProperties) {
        if (combinedProperties == null) {
            return properties;
        }
        ArrayList namespaces = new ArrayList(combinedProperties.rowKeySet());
        ArrayList propertiesToRemove = new ArrayList();
        for (String namespace : namespaces) {
            propertiesToRemove.clear();
            for (Map.Entry entry : combinedProperties.row((Object)namespace).entrySet()) {
                NlPropertyItem other = (NlPropertyItem)properties.get((Object)namespace, entry.getKey());
                if (((NlPropertyItem)entry.getValue()).sameDefinition(other)) continue;
                propertiesToRemove.add(entry.getKey());
            }
            for (String propertyName : propertiesToRemove) {
                combinedProperties.remove((Object)namespace, (Object)propertyName);
            }
        }
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res/android", (Object)"id");
        return combinedProperties;
    }

    private static void setUpDesignProperties(@NotNull Table<String, String, NlPropertyItem> properties) {
        ArrayList designProperties = new ArrayList(properties.row((Object)"http://schemas.android.com/tools").keySet());
        for (String propertyName : designProperties) {
            NlPropertyItem item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyName);
            if (item == null) {
                item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)propertyName);
            }
            if (item == null) continue;
            NlPropertyItem designItem = item.getDesignTimeProperty();
            properties.put((Object)"http://schemas.android.com/tools", (Object)propertyName, (Object)designItem);
        }
    }

    private static void setUpSrcCompat(@NotNull Table<String, String, NlPropertyItem> properties, @NotNull AndroidFacet facet, @NotNull List<NlComponent> components, @NotNull NlPropertiesManager propertiesManager) {
        NlPropertyItem srcProperty = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)"src");
        if (srcProperty != null && NlProperties.shouldAddSrcCompat(facet, components)) {
            AttributeDefinition srcDefinition = srcProperty.getDefinition();
            assert (srcDefinition != null);
            AttributeDefinition srcCompatDefinition = new AttributeDefinition("srcCompat", "com.android.support:support-v4", null, srcDefinition.getFormats());
            srcCompatDefinition.getParentStyleables().addAll(srcDefinition.getParentStyleables());
            NlPropertyItem srcCompatProperty = NlPropertyItem.create(new XmlName("srcCompat", "http://schemas.android.com/apk/res-auto"), srcCompatDefinition, components, propertiesManager);
            properties.put((Object)"http://schemas.android.com/apk/res-auto", (Object)"srcCompat", (Object)srcCompatProperty);
        }
    }

    private static boolean shouldAddSrcCompat(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components) {
        return !components.isEmpty() && NlProperties.allComponentsNeedSrcCompat(facet, components);
    }

    private static boolean allComponentsNeedSrcCompat(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components) {
        NlModel model = components.get(0).getModel();
        ViewHandlerManager manager = ViewHandlerManager.get(facet);
        HashSet<String> knownTagNames = new HashSet<String>();
        for (NlComponent component2 : components) {
            String tagName = component2.getTagName();
            if (!knownTagNames.add(tagName)) continue;
            ViewHandler handler = manager.getHandler(component2.getTagName());
            if (!(handler instanceof ImageViewHandler)) {
                return false;
            }
            ImageViewHandler imageViewHandler = (ImageViewHandler)handler;
            if (imageViewHandler.shouldUseSrcCompat(model)) continue;
            return false;
        }
        return true;
    }
}

