/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlMarginPropertyAccumulator;
import com.android.tools.idea.uibuilder.property.NlPropertyAccumulator;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesGrouper {
    private static List<String> MOST_IMPORTANT_ATTRIBUTES = ImmutableList.of((Object)"id", (Object)"layout_width", (Object)"layout_height");

    public List<PTableItem> group(@NotNull List<NlPropertyItem> properties, @NotNull List<NlComponent> components) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)properties.size());
        NlPropertyAccumulator themePropertiesAccumulator = new NlPropertyAccumulator("Theme", "", p -> p != null && (p.getParentStylables().contains("Theme") || p.getName().equalsIgnoreCase("theme")));
        NlMarginPropertyAccumulator paddingPropertiesAccumulator = new NlMarginPropertyAccumulator("Padding", "padding", "paddingLeft", "paddingRight", "paddingStart", "paddingEnd", "paddingTop", "paddingBottom");
        NlMarginPropertyAccumulator layoutViewPropertiesAccumulator = new NlMarginPropertyAccumulator("Layout_Margin", "layout_margin", "layout_marginLeft", "layout_marginRight", "layout_marginStart", "layout_marginEnd", "layout_marginTop", "layout_marginBottom");
        NlPropertyAccumulator.PropertyNamePrefixAccumulator constraintPropertiesAccumulator = new NlPropertyAccumulator.PropertyNamePrefixAccumulator("Constraints", "layout_constraint");
        ArrayList accumulators = Lists.newArrayList((Object[])new NlPropertyAccumulator[]{themePropertiesAccumulator, paddingPropertiesAccumulator, layoutViewPropertiesAccumulator, constraintPropertiesAccumulator});
        for (NlPropertyItem p2 : properties) {
            NlPropertyAccumulator accumulator;
            boolean added = false;
            Iterator iterator = accumulators.iterator();
            while (iterator.hasNext() && !(added = (accumulator = (NlPropertyAccumulator)iterator.next()).process(p2))) {
            }
            if (added) continue;
            result.add(p2);
        }
        int insertionPoint = NlPropertiesGrouper.findInsertionPoint(result);
        for (NlPropertyAccumulator accumulator : accumulators) {
            if (!accumulator.hasItems()) continue;
            result.add(insertionPoint, accumulator.getGroupNode());
        }
        return result;
    }

    @Nullable
    public static String getCommonTagName(@NotNull List<NlComponent> components) {
        String commonTagName = null;
        for (NlComponent component2 : components) {
            String tagName = component2.getTagName();
            if (commonTagName == null) {
                commonTagName = tagName;
                continue;
            }
            if (tagName.equals(commonTagName)) continue;
            return null;
        }
        return commonTagName;
    }

    private static int findInsertionPoint(@NotNull List<PTableItem> properties) {
        for (int index = 0; index < MOST_IMPORTANT_ATTRIBUTES.size(); ++index) {
            if (properties.size() >= index + 1 && properties.get(index).getName().equals(MOST_IMPORTANT_ATTRIBUTES.get(index))) continue;
            return index;
        }
        return MOST_IMPORTANT_ATTRIBUTES.size();
    }
}

