/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.res2.ResourceItem;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesPanel;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ToggleXmlPropertyEditor;
import com.android.tools.idea.uibuilder.property.ViewAllPropertiesAction;
import com.android.tools.idea.uibuilder.property.assistant.ComponentAssistant;
import com.android.tools.idea.uibuilder.property.editors.NlPropertyEditors;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesManager
implements ToolContent<DesignSurface>,
DesignSurfaceListener,
ModelListener {
    public static final int UPDATE_DELAY_MSECS = 250;
    private final Project myProject;
    private JBLoadingPanel myLoadingPanel;
    private NlPropertiesPanel myPropertiesPanel;
    private final NlPropertyEditors myEditors;
    private final AndroidFacet myFacet;
    @Nullable
    private DesignSurface mySurface;
    @Nullable
    private SceneView mySceneView;
    private MergingUpdateQueue myUpdateQueue;
    private boolean myFirstLoad = true;
    private boolean myLoading;
    private int myUpdateCount;
    private JBSplitter mySplitter;
    private ComponentAssistant myComponentAssistant;

    public NlPropertiesManager(@NotNull AndroidFacet facet, @Nullable DesignSurface designSurface) {
        this.myProject = facet.getModule().getProject();
        this.myFacet = facet;
        this.myEditors = NlPropertyEditors.getInstance(this.myProject);
        this.mySurface = designSurface;
        this.setToolContextWithoutCheck(designSurface);
    }

    public void activatePropertySheet() {
        this.getPropertiesPanel().activatePropertySheet();
    }

    public void activateInspector() {
        this.getPropertiesPanel().activateInspector();
    }

    public void setToolContext(@Nullable DesignSurface designSurface) {
        if (designSurface == this.mySurface) {
            return;
        }
        this.setToolContextWithoutCheck(designSurface);
    }

    public void setRestoreToolWindow(@NotNull Runnable restoreToolWindowCallback) {
        this.myPropertiesPanel.setRestoreToolWindow(restoreToolWindowCallback);
    }

    @NotNull
    private JBLoadingPanel getLoadingPanel() {
        if (this.myLoadingPanel == null) {
            this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 20);
            this.myLoadingPanel.add((Component)this.getContentPanel());
        }
        return this.myLoadingPanel;
    }

    @NotNull
    private NlPropertiesPanel getPropertiesPanel() {
        if (this.myPropertiesPanel == null) {
            this.myPropertiesPanel = new NlPropertiesPanel(this, (Disposable)this);
        }
        return this.myPropertiesPanel;
    }

    @NotNull
    private ComponentAssistant getComponentAssistant() {
        if (this.myComponentAssistant == null) {
            this.myComponentAssistant = new ComponentAssistant(this.myProject);
        }
        return this.myComponentAssistant;
    }

    @NotNull
    private JBSplitter getContentPanel() {
        if (this.mySplitter == null) {
            this.mySplitter = new JBSplitter(true, 0.8f){
                {
                    this.setDividerWidth(9);
                }

                protected Divider createDivider() {
                    Splitter.DividerImpl divider = new Splitter.DividerImpl((Splitter)this);
                    divider.setBorder(IdeBorderFactory.createBorder((int)10));
                    return divider;
                }
            };
            this.mySplitter.setFirstComponent((JComponent)this.getPropertiesPanel());
        }
        return this.mySplitter;
    }

    private void setToolContextWithoutCheck(@Nullable DesignSurface designSurface) {
        if (this.mySurface != null) {
            this.mySurface.removeListener(this);
        }
        this.mySurface = designSurface;
        if (this.mySurface == null) {
            this.setSceneView(null);
        } else {
            this.mySurface.addListener(this);
            SceneView sceneView = this.mySurface.getCurrentSceneView();
            this.setSceneView(sceneView);
            List<NlComponent> selection = sceneView != null ? sceneView.getSelectionModel().getSelection() : Collections.emptyList();
            this.componentSelectionChanged(this.mySurface, selection);
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this.getLoadingPanel();
    }

    @NotNull
    public JComponent getFocusedComponent() {
        return this.getContentPanel();
    }

    @NotNull
    public List<AnAction> getGearActions() {
        return ImmutableList.of((Object)((Object)new ToggleXmlPropertyEditor(this)));
    }

    @NotNull
    public List<AnAction> getAdditionalActions() {
        return Collections.singletonList(new ViewAllPropertiesAction(this.getPropertiesPanel()));
    }

    public boolean supportsFiltering() {
        return true;
    }

    public void setFilter(@NotNull String filter) {
        this.getPropertiesPanel().setFilter(filter);
    }

    @NotNull
    public KeyListener getFilterKeyListener() {
        return this.getPropertiesPanel().getFilterKeyListener();
    }

    @Nullable
    public DesignSurface getDesignSurface() {
        return this.mySurface;
    }

    private void setSceneView(@Nullable SceneView sceneView) {
        if (sceneView == this.mySceneView) {
            return;
        }
        if (this.mySceneView != null) {
            this.mySceneView.getModel().removeListener(this);
        }
        this.mySceneView = sceneView;
        if (this.mySceneView != null) {
            this.mySceneView.getModel().addListener(this);
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    public NlPropertyEditors getPropertyEditors() {
        return this.myEditors;
    }

    @NotNull
    public InspectorPanel getInspector() {
        return this.getPropertiesPanel().getInspector();
    }

    @NotNull
    private MergingUpdateQueue getUpdateQueue() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUpdateQueue == null) {
            this.myUpdateQueue = new MergingUpdateQueue("android.layout.propertysheet", 250, true, null, (Disposable)this.mySurface, null, Alarm.ThreadToUse.SWING_THREAD);
        }
        return this.myUpdateQueue;
    }

    private void setSelectedComponents(@NotNull List<NlComponent> components, @Nullable Runnable postUpdateRunnable) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Table<String, String, NlPropertyItem> properties = !components.isEmpty() ? NlProperties.getInstance().getProperties(this, components) : ImmutableTable.of();
            UIUtil.invokeLaterIfNeeded(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.getPropertiesPanel().setItems(components, properties, this);
                if (postUpdateRunnable != null) {
                    this.myLoading = false;
                    postUpdateRunnable.run();
                }
            });
        });
    }

    @NotNull
    public PropertiesMap getDefaultProperties(@NotNull List<NlComponent> components) {
        if (components.isEmpty()) {
            return PropertiesMap.EMPTY_MAP;
        }
        if (this.mySurface == null) {
            return PropertiesMap.EMPTY_MAP;
        }
        SceneView view = this.mySurface.getCurrentSceneView();
        if (view == null) {
            return PropertiesMap.EMPTY_MAP;
        }
        Map<Object, PropertiesMap> map = view.getSceneManager().getDefaultProperties();
        ArrayList<PropertiesMap> propertiesMaps = new ArrayList<PropertiesMap>(components.size());
        for (NlComponent component2 : components) {
            PropertiesMap propertiesMap = map.get(component2.getSnapshot());
            if (propertiesMap == null) {
                return PropertiesMap.EMPTY_MAP;
            }
            propertiesMaps.add(propertiesMap);
        }
        PropertiesMap first = (PropertiesMap)propertiesMaps.get(0);
        if (propertiesMaps.size() == 1) {
            return first;
        }
        PropertiesMap commonProperties = new PropertiesMap();
        for (Map.Entry property : first.entrySet()) {
            boolean include = true;
            for (int index = 1; index < propertiesMaps.size(); ++index) {
                PropertiesMap other = (PropertiesMap)propertiesMaps.get(index);
                if (((PropertiesMap.Property)property.getValue()).equals(other.get(property.getKey()))) continue;
                include = false;
                break;
            }
            if (!include) continue;
            commonProperties.put(property.getKey(), property.getValue());
        }
        return commonProperties;
    }

    public void setValue(@NotNull NlProperty property, @Nullable String value) {
        property.setValue(value);
    }

    public void updateSelection() {
        if (this.mySurface == null || this.mySceneView == null) {
            return;
        }
        ImmutableList<NlComponent> selection = this.mySceneView.getModel().getSelectionModel().getSelection();
        this.componentSelectionChanged(this.mySurface, (List<NlComponent>)selection);
        ++this.myUpdateCount;
    }

    int getUpdateCount() {
        return this.myUpdateCount;
    }

    public void propertyChanged(@NotNull NlProperty property, @Nullable String oldValue, @Nullable String newValue) {
        if (property.getComponents().size() == 1 && "merge".equals(property.getComponents().get(0).getTagName()) && "http://schemas.android.com/tools".equals(property.getNamespace()) && "parentTag".equals(property.getName())) {
            this.updateSelection();
            return;
        }
        if (PropertiesComponent.getInstance().getBoolean("NlXmlPropertyEditor") && (NlPropertyItem.isReference(oldValue) || NlPropertyItem.isReference(newValue))) {
            this.updateSelection();
        }
    }

    public void starStateChanged() {
        this.updateSelection();
    }

    public void resourceChanged(@NotNull ResourceItem item, @Nullable String oldValue, @Nullable String newValue) {
        if (PropertiesComponent.getInstance().getBoolean("NlXmlPropertyEditor") && (NlPropertyItem.isReference(oldValue) || NlPropertyItem.isReference(newValue))) {
            this.updateSelection();
        }
    }

    public void logPropertyChange(@NotNull NlProperty property) {
        NlUsageTrackerManager.getInstance(this.mySurface).logPropertyChange(property, this.getPropertiesPanel().getPropertiesViewMode(), this.getPropertiesPanel().getFilterMatchCount());
    }

    public void logFavoritesChange(@NotNull String added, @NotNull String removed, @NotNull List<String> favorites) {
        if (this.mySceneView == null) {
            return;
        }
        NlUsageTrackerManager.getInstance(this.mySurface).logFavoritesChange(added, removed, favorites, this.mySceneView.getModel().getFacet());
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, final @NotNull List<NlComponent> newSelection) {
        if (surface != this.mySurface) {
            return;
        }
        if (!newSelection.isEmpty() && this.myFirstLoad) {
            this.myFirstLoad = false;
            this.getLoadingPanel().startLoading();
        }
        ComponentAssistant assistant = this.getComponentAssistant();
        assistant.componentSelectionChanged(surface, (List<? extends NlComponent>)newSelection);
        this.getContentPanel().setSecondComponent((JComponent)(assistant.isVisible() ? assistant : null));
        this.myLoading = true;
        MergingUpdateQueue queue = this.getUpdateQueue();
        queue.queue(new Update("updateProperties"){

            public void run() {
                NlPropertiesManager.this.setSelectedComponents(newSelection, () -> ((JBLoadingPanel)NlPropertiesManager.this.getLoadingPanel()).stopLoading());
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    @Override
    public void sceneChanged(@NotNull DesignSurface surface, @Nullable SceneView sceneView) {
        this.getComponentAssistant().sceneChanged(surface, sceneView);
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
        this.getComponentAssistant().modelChanged(surface, model);
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component2) {
        String propertyName;
        this.getComponentAssistant().activatePreferredEditor(surface, component2);
        ViewHandler handler = NlComponentHelperKt.getViewHandler(component2);
        String string = propertyName = handler != null ? handler.getPreferredProperty() : null;
        if (propertyName == null) {
            return false;
        }
        this.getPropertiesPanel().activatePreferredEditor(propertyName, this.myLoading);
        return true;
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        this.getPropertiesPanel().modelRendered(this);
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        this.getPropertiesPanel().modelRendered(this);
    }

    public void dispose() {
        this.setToolContext(null);
    }
}

