/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableGroupItem;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.adtui.ptable.StarState;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.NlIdPropertyItem;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlPropertyRenderers;
import com.android.util.PropertiesMap;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertyItem
extends PTableItem
implements NlProperty {
    private static final Set<String> ATTRS_WITHOUT_DEFINITIONS = ImmutableSet.of((Object)"style", (Object)"class", (Object)"layout");
    @NotNull
    protected final List<NlComponent> myComponents;
    @NotNull
    protected final NlPropertiesManager myPropertiesManager;
    @Nullable
    protected final AttributeDefinition myDefinition;
    @NotNull
    private final String myName;
    @Nullable
    private final String myNamespace;
    @Nullable
    private PropertiesMap.Property myDefaultValue;
    @NotNull
    private StarState myStarState;

    public static NlPropertyItem create(@NotNull XmlName name, @Nullable AttributeDefinition attributeDefinition, @NotNull List<NlComponent> components, @NotNull NlPropertiesManager propertiesManager) {
        if (attributeDefinition != null && attributeDefinition.getFormats().contains((Object)AttributeFormat.Flag)) {
            return new NlFlagPropertyItem(name, attributeDefinition, components, propertiesManager);
        }
        if (name.getLocalName().equals("id")) {
            return new NlIdPropertyItem(name, attributeDefinition, components, propertiesManager);
        }
        return new NlPropertyItem(name, attributeDefinition, components, propertiesManager);
    }

    protected NlPropertyItem(@NotNull XmlName name, @Nullable AttributeDefinition attributeDefinition, @NotNull List<NlComponent> components, @NotNull NlPropertiesManager propertiesManager) {
        assert (!components.isEmpty());
        if (attributeDefinition == null && !ATTRS_WITHOUT_DEFINITIONS.contains(name.getLocalName()) && !"http://schemas.android.com/tools".equals(name.getNamespaceKey())) {
            throw new IllegalArgumentException("Missing attribute definition for " + name.getLocalName());
        }
        this.myComponents = components;
        this.myPropertiesManager = propertiesManager;
        this.myName = name.getLocalName();
        this.myNamespace = name.getNamespaceKey();
        this.myDefinition = attributeDefinition;
        this.myStarState = StarState.STAR_ABLE;
    }

    protected NlPropertyItem(@NotNull NlPropertyItem property, @NotNull String namespace) {
        assert (!property.myComponents.isEmpty());
        this.myComponents = property.myComponents;
        this.myPropertiesManager = property.myPropertiesManager;
        this.myName = property.myName;
        this.myNamespace = namespace;
        this.myDefinition = property.myDefinition;
        this.myStarState = StarState.STAR_ABLE;
        if (property.getParent() != null) {
            PTableGroupItem group = (PTableGroupItem)property.getParent();
            group.addChild((PTableItem)this, (PTableItem)property);
        }
    }

    public boolean sameDefinition(@Nullable NlPropertyItem other) {
        return other != null && Objects.equal((Object)this.myName, (Object)other.myName) && Objects.equal((Object)this.myNamespace, (Object)other.myNamespace) && this.myDefinition == other.myDefinition;
    }

    @Override
    @NotNull
    public List<NlComponent> getComponents() {
        return this.myComponents;
    }

    @NotNull
    public StarState getStarState() {
        return this.myStarState;
    }

    public void setInitialStarred() {
        this.myStarState = StarState.STARRED;
    }

    public void setStarState(@NotNull StarState starState) {
        this.myStarState = starState;
        NlProperties.saveStarState(this.myNamespace, this.myName, starState == StarState.STARRED, this.myPropertiesManager);
        this.myPropertiesManager.starStateChanged();
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public String getNamespace() {
        return this.myNamespace;
    }

    public void setDefaultValue(@Nullable PropertiesMap.Property defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    @Override
    @Nullable
    public String getValue() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String prev = null;
        for (NlComponent component2 : this.myComponents) {
            String value = component2.getAttribute(this.myNamespace, this.myName);
            if (value == null) {
                return null;
            }
            if (prev == null) {
                prev = value;
                continue;
            }
            if (value.equals(prev)) continue;
            return null;
        }
        return prev;
    }

    @Override
    @Nullable
    public String getResolvedValue() {
        return this.resolveValue(this.getValue());
    }

    @Override
    public boolean isDefaultValue(@Nullable String value) {
        if (value == null) {
            return true;
        }
        if (this.myDefaultValue == null) {
            return false;
        }
        return value.equals(this.myDefaultValue.resource);
    }

    @Override
    @Nullable
    public String resolveValue(@Nullable String value) {
        if (this.myDefaultValue != null && this.isDefaultValue(value)) {
            if (this.myDefaultValue.value == null) {
                this.myDefaultValue = new PropertiesMap.Property(this.myDefaultValue.resource, this.resolveValueUsingResolver(this.myDefaultValue.resource));
            }
            return this.myDefaultValue.value;
        }
        return value != null ? this.resolveValueUsingResolver(value) : null;
    }

    public void mouseMoved(@NotNull PTable table, @NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        NlAttributeRenderer renderer = NlPropertyRenderers.getInstance().get(this);
        renderer.mouseMoved(table, event, rectRightColumn);
    }

    public void delete() {
        PTableGroupItem group = (PTableGroupItem)this.getParent();
        if (group != null) {
            group.deleteChild((PTableItem)this);
        }
    }

    public static boolean isReference(@Nullable String value) {
        return value != null && (value.startsWith("?") || value.startsWith("@") && !NlPropertyItem.isId(value));
    }

    @NotNull
    private String resolveValueUsingResolver(@NotNull String value) {
        ResourceResolver resolver;
        if (NlPropertyItem.isReference(value) && (resolver = this.getResolver()) != null) {
            ResourceValue resource = resolver.findResValue(value, false);
            if (resource == null) {
                resource = resolver.findResValue(value, true);
            }
            if (resource != null) {
                ResourceValue resolved;
                if (resource.getValue() != null) {
                    String string = value = resource.getResourceType() == ResourceType.FONT ? resource.getName() : resource.getValue();
                    if (resource.isFramework()) {
                        value = NlPropertyItem.addAndroidPrefix(value);
                    }
                }
                if ((resolved = resolver.resolveResValue(resource)) != null && resolved.getValue() != null) {
                    String string = value = resolved.getResourceType() == ResourceType.FONT ? resolved.getName() : resolved.getValue();
                    if (resource.isFramework()) {
                        value = NlPropertyItem.addAndroidPrefix(value);
                    }
                }
            }
        }
        return value;
    }

    @NotNull
    private static String addAndroidPrefix(@NotNull String value) {
        if (value.startsWith("@") && !value.startsWith("@android:")) {
            return "@android:" + value.substring(1);
        }
        return value;
    }

    private static boolean isId(@NotNull String value) {
        return value.startsWith("@id/") || value.startsWith("@+id/") || value.startsWith("@android:id/") || value.startsWith("@android:+id/");
    }

    @Override
    @NotNull
    public NlProperty getChildProperty(@NotNull String itemName) {
        throw new UnsupportedOperationException(itemName);
    }

    @Override
    @NotNull
    public NlPropertyItem getDesignTimeProperty() {
        if ("http://schemas.android.com/tools".equals(this.myNamespace)) {
            return this;
        }
        return new NlPropertyItem(this, "http://schemas.android.com/tools");
    }

    @Override
    @NotNull
    public NlModel getModel() {
        return this.myComponents.get(0).getModel();
    }

    @Override
    @Nullable
    public XmlTag getTag() {
        return this.myComponents.size() == 1 ? this.myComponents.get(0).getTag() : null;
    }

    @Override
    @Nullable
    public String getTagName() {
        String tagName = null;
        for (NlComponent component2 : this.myComponents) {
            if (tagName == null) {
                tagName = component2.getTagName();
                continue;
            }
            if (tagName.equals(component2.getTagName())) continue;
            return null;
        }
        return tagName;
    }

    @Override
    @Nullable
    public ResourceResolver getResolver() {
        Configuration configuration = this.getModel().getConfiguration();
        return configuration.getResourceResolver();
    }

    @Override
    public void setValue(@Nullable Object value) {
        String strValue;
        String string = strValue = value == null ? null : value.toString();
        if (StringUtil.isEmpty((String)strValue) || this.isDefaultValue(strValue)) {
            strValue = null;
        }
        this.setValueIgnoreDefaultValue(strValue, null);
    }

    protected void setValueIgnoreDefaultValue(@Nullable String attrValue, @Nullable Runnable valueUpdated) {
        assert (ApplicationManager.getApplication().isDispatchThread());
        if (this.getModel().getProject().isDisposed()) {
            return;
        }
        String oldValue = this.getValue();
        String componentName = this.myComponents.size() == 1 ? this.myComponents.get(0).getTagName() : "Multiple";
        NlWriteCommandAction.run(this.myComponents, "Set " + componentName + '.' + this.myName + " to " + attrValue, () -> {
            this.myComponents.forEach(component2 -> component2.setAttribute(this.myNamespace, this.myName, attrValue));
            this.myPropertiesManager.propertyChanged(this, oldValue, attrValue);
            if (valueUpdated == null) {
                return;
            }
            valueUpdated.run();
        });
        this.myPropertiesManager.logPropertyChange(this);
    }

    @NotNull
    public List<String> getParentStylables() {
        return this.myDefinition == null ? Collections.emptyList() : this.myDefinition.getParentStyleables();
    }

    @Override
    @Nullable
    public AttributeDefinition getDefinition() {
        return this.myDefinition;
    }

    public boolean isEditable(int column) {
        return column == 1;
    }

    public String toString() {
        return NlPropertyItem.namespaceToPrefix(this.myNamespace) + this.myName;
    }

    @Override
    @NotNull
    public String getTooltipText() {
        String value;
        StringBuilder sb = new StringBuilder(100);
        sb.append(NlPropertyItem.namespaceToPrefix(this.myNamespace));
        sb.append(this.myName);
        if (this.myDefinition != null && (value = this.myDefinition.getDocValue(null)) != null) {
            sb.append(": ");
            sb.append(value);
        }
        return sb.toString();
    }

    @NotNull
    static String namespaceToPrefix(@Nullable String namespace) {
        if (namespace == null) {
            return "";
        }
        if (namespace.equalsIgnoreCase("http://schemas.android.com/apk/res/android")) {
            return "@android:";
        }
        if (namespace.equalsIgnoreCase("http://schemas.android.com/apk/res-auto")) {
            return "@app:";
        }
        return "";
    }
}

