/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlResourceItem
extends PTableItem {
    private AndroidFacet myFacet;
    private NlPropertiesManager myPropertiesManager;
    private ResourceValue myValue;
    private ResourceItem myItem;

    public NlResourceItem(@NotNull AndroidFacet facet, @NotNull ResourceValue value, @Nullable ResourceItem item, @NotNull NlPropertiesManager propertiesManager) {
        this.myFacet = facet;
        this.myPropertiesManager = propertiesManager;
        this.myValue = value;
        this.myItem = item;
    }

    public int hashCode() {
        return this.myValue.getName().hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof NlResourceItem)) {
            return false;
        }
        NlResourceItem other = (NlResourceItem)((Object)object);
        return this.myValue.getName().equals(other.myValue.getName());
    }

    public int compareTo(@NotNull NlResourceItem anotherItem) {
        return this.myValue.getName().compareTo(anotherItem.myValue.getName());
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    public ResourceItem getResourceItem() {
        return this.myItem;
    }

    @NotNull
    public String getName() {
        return this.myValue.getName();
    }

    @Nullable
    public String getValue() {
        return NlResourceItem.convert(this.myValue);
    }

    public boolean isEditable(int column) {
        return column == 1 && this.myItem != null && FolderTypeRelationship.getRelatedFolders((ResourceType)this.myItem.getType()).contains(ResourceFolderType.VALUES);
    }

    public void setValue(@Nullable Object value) {
        if (this.myItem == null) {
            throw new IllegalAccessError();
        }
        Project project = this.myFacet.getModule().getProject();
        String oldValue = this.myValue.getValue();
        String strValue = value == null || StringUtil.isEmpty((String)value.toString()) ? "" : value.toString();
        TransactionGuard.submitTransaction((Disposable)project, () -> StringsWriteUtils.setItemText(project, this.myItem, strValue));
        this.myValue.setValue(strValue);
        this.myPropertiesManager.resourceChanged(this.myItem, oldValue, strValue);
    }

    @Nullable
    private static String convert(@NotNull ResourceValue resource) {
        String value = resource.getValue();
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        if (resource.isFramework()) {
            if (value.startsWith("@") && !value.startsWith("@android:")) {
                return "@android:" + value.substring(1);
            }
            if (value.startsWith("?") && !value.startsWith("?android:")) {
                return "?android:" + value.substring(1);
            }
        }
        return value;
    }
}

