/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableCellEditorProvider;
import com.android.tools.adtui.ptable.PTableCellRendererProvider;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.uibuilder.property.AddPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.NlResourceHeader;
import com.android.tools.idea.uibuilder.property.NlResourceItem;
import com.android.tools.idea.uibuilder.property.editors.NlXmlEditors;
import com.android.tools.idea.uibuilder.property.renderer.NlXmlRenderers;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlXmlPropertyBuilder {
    private static final Pattern INTELLIJ_LIBRARY_NAME_PATTERN = Pattern.compile("(.+)-\\d+\\.\\d+\\.\\d+(-.+)");
    private final NlPropertiesManager myPropertiesManager;
    private final PTable myTable;
    private final List<NlComponent> myComponents;
    private final Table<String, String, NlPropertyItem> myProperties;
    private final Multimap<String, NlResourceItem> mySliceMap;

    NlXmlPropertyBuilder(@NotNull NlPropertiesManager propertiesManager, @NotNull PTable table, @NotNull List<NlComponent> components, Table<String, String, NlPropertyItem> properties) {
        this.myPropertiesManager = propertiesManager;
        this.myTable = table;
        this.myComponents = components;
        this.myProperties = properties;
        this.mySliceMap = TreeMultimap.create(String::compareTo, NlResourceItem::compareTo);
    }

    public boolean build() {
        this.myTable.setVisible(!this.myComponents.isEmpty());
        if (this.myComponents.isEmpty()) {
            return false;
        }
        NlComponent component2 = this.myComponents.get(0);
        ArrayList<PTableItem> items = new ArrayList<PTableItem>();
        items.add(new NlResourceHeader(NlXmlPropertyBuilder.generateFileHeader(component2.getModel().getFile().getVirtualFile().getPath())));
        for (AttributeSnapshot attribute : component2.getAttributes()) {
            NlPropertyItem item = (NlPropertyItem)this.myProperties.get((Object)attribute.namespace, (Object)attribute.name);
            if (item == null) continue;
            this.resolveValue(item);
            items.add(item);
        }
        items.add(new AddPropertyItem(this.myProperties));
        for (String header : this.mySliceMap.keySet()) {
            items.add(new NlResourceHeader(header));
            items.addAll(this.mySliceMap.get((Object)header));
        }
        int selectedRow = this.myTable.getSelectedRow();
        PTableItem selectedItem = this.myTable.getSelectedItem();
        int editingRow = this.myTable.getEditingRow();
        PTableItem editingItem = editingRow >= 0 ? this.myTable.getItemAt(editingRow) : null;
        this.myTable.getModel().setItems(items);
        this.myTable.setRendererProvider((PTableCellRendererProvider)NlXmlRenderers.getInstance());
        this.myTable.setEditorProvider((PTableCellEditorProvider)NlXmlEditors.getInstance(this.myPropertiesManager.getProject()));
        if (this.myTable.getRowCount() > 0 && !this.restoreEditing(editingRow, editingItem)) {
            this.myTable.restoreSelection(selectedRow, selectedItem);
        }
        return true;
    }

    private void resolveValue(@NotNull NlPropertyItem property) {
        AndroidFacet facet = property.getModel().getFacet();
        ProjectResourceRepository resourceRepository = ProjectResourceRepository.getOrCreateInstance(facet);
        ResourceResolver resolver = property.getResolver();
        if (resolver == null) {
            return;
        }
        String value = property.getValue();
        while (!StringUtil.isEmpty((String)value) && NlPropertyItem.isReference(value)) {
            ResourceValue resource = resolver.findResValue(value, false);
            if (resource == null) {
                resource = resolver.findResValue(value, true);
            }
            if (resource == null) {
                return;
            }
            ResourceItem item = NlXmlPropertyBuilder.findUserDefinedResourceItem(resourceRepository, resource);
            NlResourceItem row = new NlResourceItem(facet, resource, item, this.myPropertiesManager);
            value = row.getValue();
            if (StringUtil.isEmpty((String)row.getValue())) {
                return;
            }
            this.mySliceMap.put((Object)NlXmlPropertyBuilder.generateHeader(resource, item), (Object)row);
        }
    }

    private boolean restoreEditing(int editingRow, PTableItem editingItem) {
        if (editingRow < 0) {
            return false;
        }
        PTableItem currentItem = this.myTable.getItemAt(editingRow);
        if (currentItem == null || !editingItem.getClass().equals(currentItem.getClass())) {
            this.myTable.editingCanceled(null);
            return false;
        }
        this.myTable.restoreSelection(editingRow, editingItem);
        return true;
    }

    @Nullable
    private static ResourceItem findUserDefinedResourceItem(@NotNull ProjectResourceRepository resourceRepository, @NotNull ResourceValue resource) {
        if (resource.isFramework() || resource.getLibraryName() != null || resource.getResourceType() == null) {
            return null;
        }
        List items = resourceRepository.getResourceItem(resource.getResourceType(), resource.getName());
        if (items == null) {
            return null;
        }
        for (ResourceItem item : items) {
            if (item.getResourceValue(false) != resource) continue;
            return item;
        }
        return null;
    }

    @NotNull
    private static String generateHeader(@NotNull ResourceValue resource, @Nullable ResourceItem item) {
        String type;
        ResourceType resourceType = resource.getResourceType();
        String string = type = resourceType != null ? "<" + resource.getResourceType().getName() + ">" : "<style>";
        if (resource.isFramework()) {
            return "android " + type;
        }
        if (!StringUtil.isEmpty((String)resource.getLibraryName())) {
            return NlXmlPropertyBuilder.formatLibraryName(resource.getLibraryName()) + " " + type;
        }
        if (item != null && item.getSource() != null) {
            return NlXmlPropertyBuilder.generateFileHeader(((ResourceFile)item.getSource()).getFile().getPath());
        }
        return type;
    }

    private static String generateFileHeader(@NotNull String path) {
        String fileName = PathUtil.getFileName((String)path);
        String parentPath = PathUtil.getFileName((String)PathUtil.getParentPath((String)path));
        return parentPath + "/" + fileName;
    }

    @NotNull
    private static String formatLibraryName(@NotNull String libraryName) {
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)libraryName);
        if (coordinate != null) {
            String artifact = coordinate.getArtifactId();
            return !StringUtil.isEmpty((String)artifact) ? artifact : libraryName;
        }
        Matcher matcher = INTELLIJ_LIBRARY_NAME_PATTERN.matcher(libraryName);
        if (matcher.find()) {
            String artifact = matcher.group(1);
            return !StringUtil.isEmpty((String)artifact) ? artifact : libraryName;
        }
        return libraryName;
    }
}

