/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import java.awt.Color;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NlBaseComponentEditor
implements NlComponentEditor,
BrowsePanel.Context {
    protected static final JBColor DEFAULT_VALUE_TEXT_COLOR = new JBColor((Color)Gray._128, (Color)Gray._128);
    protected static final JBColor CHANGED_VALUE_TEXT_COLOR = JBColor.BLUE;
    protected static final int HORIZONTAL_COMPONENT_GAP = SystemInfo.isMac ? 0 : 2;
    protected static final int HORIZONTAL_SPACING = 4;
    protected static final int VERTICAL_SPACING = 2;
    protected static final int HORIZONTAL_PADDING = 7;
    protected static final int VERTICAL_PADDING = 2;
    protected static final int VERTICAL_PADDING_FOR_SMALL_FONT = 3;
    private final NlEditingListener myListener;
    private JLabel myLabel;

    public NlBaseComponentEditor(@NotNull NlEditingListener listener) {
        this.myListener = listener;
    }

    @Override
    @Nullable
    public JLabel getLabel() {
        return this.myLabel;
    }

    @Override
    public void setLabel(@NotNull JLabel label) {
        this.myLabel = label;
        label.setVisible(this.getComponent().isVisible());
    }

    @Override
    public void setVisible(boolean visible) {
        this.getComponent().setVisible(visible);
        if (this.myLabel != null) {
            this.myLabel.setVisible(visible);
        }
    }

    @Override
    public void refresh() {
        this.setProperty(this.getProperty());
    }

    @Override
    @Nullable
    public Object getValue() {
        return null;
    }

    @Override
    public void activate() {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getComponent().setEnabled(enabled);
    }

    @Override
    public void requestFocus() {
        this.getComponent().requestFocus();
    }

    @Override
    public void cancelEditing() {
        this.myListener.cancelEditing(this);
    }

    @Override
    public void stopEditing(@Nullable Object newValue) {
        this.myListener.stopEditing(this, newValue);
        this.refresh();
    }

    public NlEditingListener getEditingListener() {
        return this.myListener;
    }

    protected void showBrowseDialog() {
        String newValue = BrowsePanel.showBrowseDialog(this.getProperty());
        if (newValue != null) {
            this.stopEditing(newValue);
        } else {
            this.cancelEditing();
        }
    }
}

