/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlBaseComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.renderer.NlBooleanRenderer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlBooleanEditor
extends NlBaseComponentEditor
implements NlComponentEditor {
    private final JPanel myPanel;
    private final ThreeStateCheckBox myCheckbox = new ThreeStateCheckBox();
    private final BrowsePanel myBrowsePanel;
    private NlProperty myProperty;
    private Object myValue;

    public static NlTableCellEditor createForTable() {
        NlTableCellEditor cellEditor = new NlTableCellEditor();
        BrowsePanel browsePanel = new BrowsePanel(cellEditor, true);
        cellEditor.init(new NlBooleanEditor(cellEditor, browsePanel), browsePanel);
        return cellEditor;
    }

    public static NlBooleanEditor createForInspector(@NotNull NlEditingListener listener) {
        return new NlBooleanEditor(listener, null);
    }

    private NlBooleanEditor(@NotNull NlEditingListener listener, @Nullable BrowsePanel browsePanel) {
        super(listener);
        this.myCheckbox.addActionListener(this::checkboxChanged);
        this.myPanel = new JPanel(new BorderLayout(JBUI.scale((int)HORIZONTAL_COMPONENT_GAP), 0));
        this.myPanel.add((Component)this.myCheckbox, "Before");
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0, (int)4, (int)0));
        this.myBrowsePanel = browsePanel;
        if (browsePanel != null) {
            this.myPanel.add((Component)browsePanel, "After");
        }
        this.myProperty = EmptyProperty.INSTANCE;
    }

    @Override
    @NotNull
    public NlProperty getProperty() {
        return this.myProperty;
    }

    @Override
    public void setProperty(@NotNull NlProperty property) {
        this.myProperty = property;
        String propValue = this.myProperty.getValue();
        this.myValue = propValue;
        ThreeStateCheckBox.State state = NlBooleanRenderer.getState(propValue);
        this.myCheckbox.setState(state == null ? ThreeStateCheckBox.State.NOT_SELECTED : state);
        if (this.myBrowsePanel != null) {
            this.myBrowsePanel.setProperty(property);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.myValue;
    }

    private void checkboxChanged(ActionEvent event) {
        this.myValue = NlBooleanRenderer.getBoolean(this.myCheckbox.getState());
        this.stopEditing(this.myValue);
    }
}

