/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlBaseComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupportFactory;
import com.android.tools.idea.uibuilder.property.editors.support.Quantity;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlEnumEditor
extends NlBaseComponentEditor
implements NlComponentEditor {
    private static final int SMALL_WIDTH = 65;
    private final JPanel myPanel = new JPanel(new BorderLayout(JBUI.scale((int)HORIZONTAL_COMPONENT_GAP), 0));
    private final CustomComboBox myCombo;
    private final JTextField myEditor;
    private final BrowsePanel myBrowsePanel;
    private EnumSupport myEnumSupport;
    private NlProperty myProperty;
    private String myApiVersion;
    private int myAddedValueIndex = -1;
    private boolean myPopupValueChanged;
    private boolean myDisplayRealValue;

    public static NlTableCellEditor createForTable() {
        NlTableCellEditor cellEditor = new NlTableCellEditor();
        BrowsePanel browsePanel = new BrowsePanel(cellEditor, true);
        cellEditor.init(new NlEnumEditor(cellEditor, new CustomComboBox(), browsePanel, false), browsePanel);
        return cellEditor;
    }

    public static NlEnumEditor createForInspector(@NotNull NlEditingListener listener) {
        return new NlEnumEditor(listener, new CustomComboBox(), null, true);
    }

    public static NlEnumEditor createForInspectorWithBrowseButton(@NotNull NlEditingListener listener) {
        BrowsePanel.ContextDelegate delegate = new BrowsePanel.ContextDelegate();
        NlEnumEditor editor = new NlEnumEditor(listener, new CustomComboBox(), new BrowsePanel(delegate, false), true);
        delegate.setEditor(editor);
        return editor;
    }

    public static NlEnumEditor createForTest(@NotNull NlEditingListener listener, CustomComboBox comboBox) {
        return new NlEnumEditor(listener, comboBox, null, false);
    }

    private NlEnumEditor(@NotNull NlEditingListener listener, @NotNull CustomComboBox comboBox, @Nullable BrowsePanel browsePanel, boolean includeBorder) {
        super(listener);
        this.myPanel.setFocusable(false);
        this.myBrowsePanel = browsePanel;
        this.myCombo = comboBox;
        this.myCombo.setEditable(true);
        this.myCombo.addPopupMenuListener(new PopupMenuHandler());
        this.myCombo.addActionListener(this::comboValuePicked);
        if (includeBorder) {
            this.myCombo.setBorderPanel(this.myPanel);
        }
        this.myPanel.add((Component)((Object)this.myCombo), "Center");
        if (browsePanel != null) {
            this.myPanel.add((Component)browsePanel, "After");
        }
        this.myEditor = (JTextField)this.myCombo.getEditor().getEditorComponent();
        this.myEditor.registerKeyboardAction(event -> this.enter(), KeyStroke.getKeyStroke(10, 0), 0);
        this.myEditor.registerKeyboardAction(event -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 0);
        this.myEditor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                NlEnumEditor.this.myDisplayRealValue = true;
                ValueWithDisplayString value = NlEnumEditor.this.myCombo.getSelectedItem();
                value.setUseValueForToString(NlEnumEditor.this.myDisplayRealValue);
                NlEnumEditor.this.myEditor.setText(value.toString());
                NlEnumEditor.this.myEditor.selectAll();
                NlEnumEditor.this.myEditor.setForeground((Color)NlBaseComponentEditor.CHANGED_VALUE_TEXT_COLOR);
            }

            @Override
            public void focusLost(FocusEvent event) {
                NlEnumEditor.this.myDisplayRealValue = false;
                ValueWithDisplayString value = NlEnumEditor.this.createFromEditorValue(NlEnumEditor.this.myEditor.getText());
                if (!Objects.equals(value.getValue(), NlEnumEditor.this.myProperty.getValue())) {
                    NlEnumEditor.this.stopEditing(value.getValue());
                }
                value.setUseValueForToString(NlEnumEditor.this.myDisplayRealValue);
                NlEnumEditor.this.myEditor.setText(value.toString());
                NlEnumEditor.this.myEditor.setForeground((Color)(value.getValue() != null ? NlBaseComponentEditor.CHANGED_VALUE_TEXT_COLOR : NlBaseComponentEditor.DEFAULT_VALUE_TEXT_COLOR));
                NlEnumEditor.this.myEditor.select(0, 0);
            }
        });
        this.myCombo.setRenderer((ListCellRenderer)((Object)new EnumRenderer()));
        this.myProperty = EmptyProperty.INSTANCE;
    }

    @Override
    public void setEnabled(boolean en) {
        this.myCombo.setEnabled(en);
    }

    @Override
    public void setProperty(@NotNull NlProperty property) {
        if (property != this.myProperty || !NlEnumEditor.getApiVersion(property).equals(this.myApiVersion)) {
            this.setModel(property);
        }
        if (this.myBrowsePanel != null) {
            this.myBrowsePanel.setProperty(property);
        }
        this.selectItem(this.createFromEditorValue(property.getValue()));
    }

    @Override
    public void requestFocus() {
        this.myCombo.requestFocus();
    }

    private void setModel(@NotNull NlProperty property) {
        assert (EnumSupportFactory.supportsProperty(property)) : this.getClass().getName() + property;
        this.myProperty = property;
        this.myEnumSupport = EnumSupportFactory.create(property);
        this.myApiVersion = NlEnumEditor.getApiVersion(property);
        List<ValueWithDisplayString> values = this.myEnumSupport.getAllValues();
        ValueWithDisplayString[] valueArray = values.toArray(new ValueWithDisplayString[0]);
        DefaultComboBoxModel<ValueWithDisplayString> newModel = new DefaultComboBoxModel<ValueWithDisplayString>(valueArray){

            @Override
            public void setSelectedItem(Object object) {
                if (object instanceof String) {
                    object = NlEnumEditor.this.createFromEditorValue((String)object);
                }
                if (object instanceof ValueWithDisplayString) {
                    ValueWithDisplayString value = (ValueWithDisplayString)object;
                    ValueWithDisplayString.ValueSelector selector = value.getValueSelector();
                    if (selector != null) {
                        value = selector.selectValue(NlEnumEditor.this.myProperty.getValue());
                        if (value == null) {
                            return;
                        }
                        String selectedValue = value.getValue();
                        ApplicationManager.getApplication().invokeLater(() -> NlEnumEditor.this.stopEditing(selectedValue));
                    }
                    value.setUseValueForToString(NlEnumEditor.this.myDisplayRealValue);
                    object = value;
                }
                super.setSelectedItem(object);
            }
        };
        ValueWithDisplayString defaultValue = this.createFromEditorValue(null);
        newModel.insertElementAt(defaultValue, 0);
        this.myCombo.setModel(newModel);
        this.myAddedValueIndex = -1;
    }

    private void updateModel() {
        ValueWithDisplayString selected = this.myCombo.getSelectedItem();
        ValueWithDisplayString added = this.myAddedValueIndex >= 0 ? (ValueWithDisplayString)this.myCombo.getModel().getElementAt(this.myAddedValueIndex) : null;
        this.setModel(this.myProperty);
        if (added != null) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.myCombo.getModel();
            this.myAddedValueIndex = this.findBestInsertionPoint(added);
            model.insertElementAt(added, this.myAddedValueIndex);
        }
        this.myCombo.setSelectedItem(selected);
    }

    @Override
    @NotNull
    public NlProperty getProperty() {
        return this.myProperty;
    }

    @NotNull
    private static String getApiVersion(@NotNull NlProperty property) {
        IAndroidTarget target = property != EmptyProperty.INSTANCE ? property.getModel().getConfiguration().getTarget() : null;
        return target == null ? "26U" : target.getVersion().getApiString();
    }

    private void selectItem(@NotNull ValueWithDisplayString value) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.myCombo.getModel();
        int index = model.getIndexOf(value);
        if (index == -1) {
            if (this.myAddedValueIndex >= 0) {
                model.removeElementAt(this.myAddedValueIndex);
            }
            this.myAddedValueIndex = this.findBestInsertionPoint(value);
            model.insertElementAt(value, this.myAddedValueIndex);
        }
        value.setUseValueForToString(this.myDisplayRealValue);
        if (!value.equals(model.getSelectedItem())) {
            model.setSelectedItem(value);
        }
        this.myEditor.setText(value.toString());
        this.myEditor.setForeground((Color)(value.getValue() != null ? CHANGED_VALUE_TEXT_COLOR : DEFAULT_VALUE_TEXT_COLOR));
    }

    private int findBestInsertionPoint(@NotNull ValueWithDisplayString newValue) {
        AttributeDefinition definition = this.myProperty.getDefinition();
        boolean isDimension = definition != null && definition.getFormats().contains((Object)AttributeFormat.Dimension);
        int startIndex = 1;
        if (!isDimension) {
            return startIndex;
        }
        String newTextValue = newValue.getDisplayString();
        if (StringUtil.isEmpty((String)newTextValue)) {
            return startIndex;
        }
        Quantity newQuantity = Quantity.parse(newTextValue);
        if (newQuantity == null) {
            return startIndex;
        }
        ComboBoxModel<ValueWithDisplayString> model = this.myCombo.getModel();
        int size = model.getSize();
        for (int index = startIndex; index < size; ++index) {
            Quantity quantity;
            String textValue = ((ValueWithDisplayString)model.getElementAt(index)).getValue();
            if (textValue == null || newQuantity.compareTo(quantity = Quantity.parse(textValue)) > 0) continue;
            return index;
        }
        return model.getSize();
    }

    @Override
    @Nullable
    public Object getValue() {
        ValueWithDisplayString value = this.myCombo.getSelectedItem();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    public Component getKeySource() {
        return this.myEditor;
    }

    private void enter() {
        if (!this.myCombo.isPopupVisible()) {
            ValueWithDisplayString value = this.createFromEditorValue(this.myEditor.getText());
            this.selectItem(value);
            this.stopEditing(value.getValue());
            this.myCombo.getEditor().selectAll();
        }
        this.myCombo.hidePopup();
    }

    private void cancel() {
        String text = this.myProperty.getValue();
        this.myCombo.getEditor().setItem(text);
        ValueWithDisplayString value = this.createFromEditorValue(this.myProperty.getValue());
        this.selectItem(value);
        this.myPopupValueChanged = false;
        this.cancelEditing();
        this.myCombo.getEditor().selectAll();
        this.myCombo.hidePopup();
    }

    @NotNull
    private ValueWithDisplayString createFromEditorValue(@Nullable String editorValue) {
        assert (this.myEnumSupport != null) : "EnumSupport should have been setup by setModel";
        return this.myEnumSupport.createValue(StringUtil.notNullize((String)editorValue));
    }

    private void comboValuePicked(@NotNull ActionEvent event) {
        if ("comboBoxChanged".equals(event.getActionCommand())) {
            this.myPopupValueChanged = true;
        }
    }

    private class PopupMenuHandler
    implements PopupMenuListener {
        private PopupMenuHandler() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
            NlEnumEditor.this.myPopupValueChanged = false;
            NlEnumEditor.this.updateModel();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
            if (NlEnumEditor.this.myPopupValueChanged) {
                NlEnumEditor.this.myPopupValueChanged = false;
                ValueWithDisplayString value = (ValueWithDisplayString)NlEnumEditor.this.myCombo.getModel().getSelectedItem();
                value.setUseValueForToString(NlEnumEditor.this.myDisplayRealValue);
                NlEnumEditor.this.stopEditing(value.getValue());
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent event) {
            NlEnumEditor.this.myPopupValueChanged = false;
        }
    }

    private class EnumRenderer
    extends ColoredListCellRenderer<ValueWithDisplayString> {
        private EnumRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends ValueWithDisplayString> list, ValueWithDisplayString value, int index, boolean selected, boolean hasFocus) {
            if (value == ValueWithDisplayString.SEPARATOR) {
                return new JSeparator();
            }
            return super.getListCellRendererComponent(list, (Object)value, index, selected, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList list, ValueWithDisplayString value, int index, boolean selected, boolean hasFocus) {
            if (value != null) {
                boolean skipDefault = NlEnumEditor.this.myEnumSupport.customizeCellRenderer(this, value, selected);
                if (skipDefault) {
                    return;
                }
                String displayString = value.getDisplayString();
                String actualValue = value.getValue();
                String hint = value.getHint();
                boolean isDefaultValue = NlEnumEditor.this.myProperty.isDefaultValue(actualValue);
                if (!selected && !isDefaultValue && Objects.equals(actualValue, NlEnumEditor.this.getValue())) {
                    this.myForeground = NlBaseComponentEditor.CHANGED_VALUE_TEXT_COLOR;
                } else if (index == 0 || isDefaultValue) {
                    this.myForeground = NlBaseComponentEditor.DEFAULT_VALUE_TEXT_COLOR;
                }
                if (!StringUtil.isEmpty((String)displayString)) {
                    this.append(displayString);
                    if (!StringUtil.isEmpty((String)hint)) {
                        this.myForeground = NlBaseComponentEditor.DEFAULT_VALUE_TEXT_COLOR;
                        this.append(" [");
                        this.append(hint);
                        this.append("]");
                    }
                } else if (actualValue != null) {
                    this.append(actualValue);
                }
            }
        }
    }

    private static class CustomDarculaComboBoxUI
    extends DarculaComboBoxUI {
        public CustomDarculaComboBoxUI(@NotNull JComboBox comboBox) {
            super(comboBox);
        }

        protected Insets getInsets() {
            return JBUI.insets((int)2, (int)7, (int)2, (int)4).asUIResource();
        }

        @NotNull
        protected Color getArrowButtonFillColor(@NotNull Color defaultColor) {
            return JBColor.LIGHT_GRAY;
        }
    }

    public static class CustomComboBox
    extends ComboBox {
        private JPanel myBorderPanel;
        private boolean myUseDarculaUI;

        public CustomComboBox() {
            super(65);
            this.setBorders();
        }

        public void setBorderPanel(@NotNull JPanel borderPanel) {
            this.myBorderPanel = borderPanel;
            this.setBorders();
        }

        public ComboBoxModel<ValueWithDisplayString> getModel() {
            return super.getModel();
        }

        public ValueWithDisplayString getSelectedItem() {
            return (ValueWithDisplayString)super.getSelectedItem();
        }

        private void setBorders() {
            int horizontalSpacing = 4 + (this.myUseDarculaUI ? 0 : 1);
            if (this.myBorderPanel != null) {
                this.myBorderPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)horizontalSpacing, (int)2, (int)0));
            }
            this.setBorder((Border)(this.myUseDarculaUI && this.myBorderPanel != null ? null : JBUI.Borders.empty((int)1, (int)4, (int)1, (int)4)));
        }

        public void setUI(ComboBoxUI ui) {
            boolean bl = this.myUseDarculaUI = !(ui instanceof WindowsComboBoxUI) && !ApplicationManager.getApplication().isUnitTestMode();
            if (this.myUseDarculaUI) {
                ui = new CustomDarculaComboBoxUI((JComboBox)((Object)this));
            }
            super.setUI(ui);
            this.setBorders();
        }
    }
}

