/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlBaseComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlFlagEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlFlagsEditor
extends NlBaseComponentEditor
implements NlComponentEditor {
    private final JPanel myPanel;
    private final JTextField myValue;
    private NlFlagPropertyItem myProperty;

    public static NlFlagsEditor create() {
        return new NlFlagsEditor();
    }

    private NlFlagsEditor() {
        super(NlEditingListener.DEFAULT_LISTENER);
        AnAction action = this.createDisplayFlagEditorAction();
        ActionButton button = new ActionButton(action, action.getTemplatePresentation().clone(), "unknown", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
        this.myValue = new CustomTextField();
        this.myValue.setEditable(false);
        this.myValue.setFocusable(true);
        this.myPanel = new JPanel(new BorderLayout(JBUI.scale((int)HORIZONTAL_COMPONENT_GAP), 0));
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)4, (int)2, (int)0));
        this.myPanel.add((Component)this.myValue, "Center");
        this.myPanel.add((Component)button, "After");
        this.myValue.addActionListener(event -> this.displayFlagEditor());
        this.myValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                NlFlagsEditor.this.displayFlagEditor();
            }
        });
        this.myValue.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NlFlagsEditor.this.displayFlagEditor();
            }
        });
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    @NotNull
    public NlProperty getProperty() {
        return this.myProperty != null ? this.myProperty : EmptyProperty.INSTANCE;
    }

    @Override
    public void setProperty(@NotNull NlProperty property) {
        assert (property instanceof NlFlagPropertyItem);
        this.myProperty = (NlFlagPropertyItem)property;
        this.myValue.setText(property.getValue());
    }

    private AnAction createDisplayFlagEditorAction() {
        return new AnAction(){

            public void update(AnActionEvent event) {
                Presentation presentation = event.getPresentation();
                if (NlFlagsEditor.this.myProperty != null) {
                    presentation.setIcon(AllIcons.General.Ellipsis);
                    presentation.setText("Click to edit");
                    presentation.setVisible(true);
                    presentation.setEnabled(true);
                } else {
                    presentation.setIcon(null);
                    presentation.setText(null);
                    presentation.setVisible(false);
                    presentation.setEnabled(false);
                }
            }

            public void actionPerformed(AnActionEvent event) {
                NlFlagsEditor.this.displayFlagEditor();
            }
        };
    }

    private void displayFlagEditor() {
        FlagsDialog dialog = new FlagsDialog(this.myProperty);
        dialog.setResizable(false);
        dialog.setInitialLocationCallback(() -> {
            Point location = new Point(0, 0);
            SwingUtilities.convertPointToScreen(location, this.myPanel);
            return location;
        });
        dialog.show();
    }

    private static class CustomTextFieldUI
    extends DarculaTextFieldUI {
        public CustomTextFieldUI(JTextField textField) {
            super(textField);
        }

        protected void paintDarculaBackground(Graphics2D graphics2D, JTextComponent component2, Border border) {
            graphics2D.setColor(component2.getBackground());
            super.paintDarculaBackground(graphics2D, component2, border);
        }
    }

    private static class CustomTextField
    extends JTextField {
        public CustomTextField() {
            this.setBorder((Border)new DarculaTextBorder());
        }

        @Override
        public void setUI(TextUI ui) {
            super.setUI((TextUI)((Object)new CustomTextFieldUI(this)));
        }
    }

    private static class FlagsDialog
    extends DialogWrapper {
        private final NlFlagPropertyItem myProperty;

        protected FlagsDialog(@NotNull NlFlagPropertyItem property) {
            super(property.getModel().getProject(), false, DialogWrapper.IdeModalityType.MODELESS);
            this.myProperty = property;
            this.setTitle(property.getName());
            this.init();
            this.getWindow().addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    this.close(0);
                }
            });
        }

        @NotNull
        protected Action[] createActions() {
            return new Action[]{this.getOKAction()};
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 3));
            AttributeDefinition definition = this.myProperty.getDefinition();
            assert (definition != null);
            for (String item : definition.getValues()) {
                NlFlagEditor editor = NlFlagEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
                editor.setProperty(this.myProperty.getChildProperty(item));
                panel.add(editor.getComponent());
            }
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel, (int)20, (int)31);
            scrollPane.setBorder(null);
            scrollPane.getVerticalScrollBar().setUnitIncrement(25);
            scrollPane.getVerticalScrollBar().setBlockIncrement(25);
            return scrollPane;
        }
    }
}

