/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.adtui.ptable.PTableCellEditor;
import com.android.tools.adtui.ptable.PTableCellEditorProvider;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlEnumEditor;
import com.android.tools.idea.uibuilder.property.editors.NlFlagEditor;
import com.android.tools.idea.uibuilder.property.editors.NlFlagsEditor;
import com.android.tools.idea.uibuilder.property.editors.NlNoEditor;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupportFactory;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;

public class NlPropertyEditors
implements PTableCellEditorProvider,
ProjectComponent,
LafManagerListener {
    private Project myProject;
    private NlTableCellEditor myBooleanEditor;
    private NlTableCellEditor myFlagEditor;
    private NlTableCellEditor myComboEditor;
    private NlTableCellEditor myDefaultEditor;

    @NotNull
    public static NlPropertyEditors getInstance(@NotNull Project project) {
        return (NlPropertyEditors)project.getComponent(NlPropertyEditors.class);
    }

    private NlPropertyEditors(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public PTableCellEditor getCellEditor(@NotNull PTableItem item, int column) {
        if (!(item instanceof NlProperty)) {
            return NlNoEditor.getInstance();
        }
        switch (NlPropertyEditors.getEditorType((NlProperty)item)) {
            case BOOLEAN: {
                return this.getBooleanEditor();
            }
            case FLAG: {
                return this.getMyFlagEditor();
            }
            case COMBO: 
            case COMBO_WITH_BROWSE: {
                return this.getMyComboEditor();
            }
        }
        return this.getDefaultEditor();
    }

    @NotNull
    public NlComponentEditor create(@NotNull NlProperty property) {
        switch (NlPropertyEditors.getEditorType(property)) {
            case BOOLEAN: {
                return NlBooleanEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            }
            case FLAG: {
                return NlFlagsEditor.create();
            }
            case COMBO: {
                return NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            }
            case COMBO_WITH_BROWSE: {
                return NlEnumEditor.createForInspectorWithBrowseButton(NlEditingListener.DEFAULT_LISTENER);
            }
        }
        return NlReferenceEditor.createForInspectorWithBrowseButton(property.getModel().getProject(), NlEditingListener.DEFAULT_LISTENER);
    }

    private void resetCachedEditors() {
        this.myBooleanEditor = null;
        this.myFlagEditor = null;
        this.myComboEditor = null;
        this.myDefaultEditor = null;
    }

    @NotNull
    private static EditorType getEditorType(@NotNull NlProperty property) {
        AttributeDefinition definition = property.getDefinition();
        Set<Object> formats = definition != null ? definition.getFormats() : Collections.emptySet();
        Boolean isBoolean = null;
        for (AttributeFormat attributeFormat : formats) {
            switch (attributeFormat) {
                case Boolean: {
                    if (isBoolean != null) break;
                    isBoolean = Boolean.TRUE;
                    break;
                }
                case String: 
                case Color: 
                case Dimension: 
                case Integer: 
                case Float: 
                case Fraction: {
                    if (isBoolean != null) break;
                    isBoolean = Boolean.FALSE;
                    break;
                }
                case Enum: {
                    return EditorType.COMBO;
                }
                case Flag: {
                    return EditorType.FLAG;
                }
            }
        }
        if (isBoolean == Boolean.TRUE) {
            return EditorType.BOOLEAN;
        }
        if (EnumSupportFactory.supportsProperty(property)) {
            if (property.getName().equals("style")) {
                return EditorType.COMBO_WITH_BROWSE;
            }
            return EditorType.COMBO;
        }
        return EditorType.DEFAULT;
    }

    private PTableCellEditor getBooleanEditor() {
        if (this.myBooleanEditor == null) {
            this.myBooleanEditor = NlBooleanEditor.createForTable();
        }
        return this.myBooleanEditor;
    }

    public PTableCellEditor getMyFlagEditor() {
        if (this.myFlagEditor == null) {
            this.myFlagEditor = NlFlagEditor.createForTable();
        }
        return this.myFlagEditor;
    }

    private PTableCellEditor getMyComboEditor() {
        if (this.myComboEditor == null) {
            this.myComboEditor = NlEnumEditor.createForTable();
        }
        return this.myComboEditor;
    }

    private PTableCellEditor getDefaultEditor() {
        if (this.myDefaultEditor == null) {
            this.myDefaultEditor = NlReferenceEditor.createForTable(this.myProject);
        }
        return this.myDefaultEditor;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
        LafManager.getInstance().addLafManagerListener((LafManagerListener)this);
    }

    public void disposeComponent() {
        LafManager.getInstance().removeLafManagerListener((LafManagerListener)this);
    }

    public void lookAndFeelChanged(LafManager source) {
        this.resetCachedEditors();
    }

    @NotNull
    public String getComponentName() {
        return NlPropertyEditors.class.getSimpleName();
    }

    public static enum EditorType {
        DEFAULT,
        BOOLEAN,
        FLAG,
        COMBO,
        COMBO_WITH_BROWSE;

    }
}

