/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.resources.ResourceType;
import com.android.tools.adtui.ptable.PTableCellEditor;
import com.android.tools.idea.uibuilder.property.NlResourceItem;
import com.android.tools.idea.uibuilder.property.editors.support.Quantity;
import com.android.tools.idea.uibuilder.property.editors.support.TextEditorWithAutoCompletion;
import com.android.tools.idea.uibuilder.property.renderer.NlXmlValueRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class NlResourceValueEditor
extends PTableCellEditor {
    private final TextEditorWithAutoCompletion myTextEditorWithAutoCompletion;
    private NlResourceItem myItem;
    private boolean myCompletionsUpdated;

    public static NlResourceValueEditor createForSliceTable(@NotNull Project project) {
        return new NlResourceValueEditor(project);
    }

    private NlResourceValueEditor(@NotNull Project project) {
        this.myTextEditorWithAutoCompletion = TextEditorWithAutoCompletion.create(project, (Insets)JBUI.insets((int)4, (int)7, (int)4, (int)7));
        this.myTextEditorWithAutoCompletion.registerKeyboardAction(event -> this.enter(), KeyStroke.getKeyStroke(10, 0), 1);
        this.myTextEditorWithAutoCompletion.registerKeyboardAction(event -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.myTextEditorWithAutoCompletion.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myTextEditorWithAutoCompletion.setFontStyle(1);
        this.myTextEditorWithAutoCompletion.setTextColor((Color)NlXmlValueRenderer.VALUE_COLOR);
        this.myTextEditorWithAutoCompletion.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                if (!NlResourceValueEditor.this.myCompletionsUpdated) {
                    NlResourceValueEditor.this.editorFocusGained();
                }
                NlResourceValueEditor.this.myTextEditorWithAutoCompletion.selectAll();
            }

            @Override
            public void focusLost(@NotNull FocusEvent event) {
                NlResourceValueEditor.this.enter();
                NlResourceValueEditor.this.myTextEditorWithAutoCompletion.removeSelection();
            }
        });
    }

    @NotNull
    private EnumSet<ResourceType> getResourceTypes() {
        return this.myItem != null ? EnumSet.of(this.myItem.getResourceItem().getType()) : EnumSet.noneOf(ResourceType.class);
    }

    private void cancel() {
        this.myTextEditorWithAutoCompletion.setText(this.myItem != null ? this.myItem.getValue() : null);
        this.myTextEditorWithAutoCompletion.selectAll();
        this.cancelCellEditing();
    }

    private void enter() {
        if (this.myTextEditorWithAutoCompletion.editorHasFocus()) {
            this.myTextEditorWithAutoCompletion.selectAll();
        }
        this.saveValue(this.getCellEditorValue());
        this.stopCellEditing();
    }

    private void saveValue(@NotNull String value) {
        this.myItem.setValue(value);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.myItem = (NlResourceItem)((Object)value);
        this.myTextEditorWithAutoCompletion.setText(this.myItem != null ? this.myItem.getValue() : null);
        return this.myTextEditorWithAutoCompletion;
    }

    public String getCellEditorValue() {
        if (this.myItem == null) {
            return null;
        }
        String text = this.myTextEditorWithAutoCompletion.getDocument().getText();
        return Quantity.addUnit(this.myItem.getResourceItem().getType(), text);
    }

    private void editorFocusGained() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            NlResourceItem item = this.myItem;
            List<String> completions = TextEditorWithAutoCompletion.loadCompletions(item.getFacet(), this.getResourceTypes(), null);
            if (item == this.myItem) {
                this.myTextEditorWithAutoCompletion.updateCompletions(completions);
                this.myCompletionsUpdated = true;
            }
        });
    }
}

