/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableCellEditor;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.adtui.ptable.PTableModel;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.PropertyDesignState;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTableCellEditor
extends PTableCellEditor
implements NlEditingListener,
BrowsePanel.Context {
    protected NlComponentEditor myEditor;
    protected BrowsePanel myBrowsePanel;
    protected JTable myTable;
    protected int myRow;

    public void init(@NotNull NlComponentEditor editor, @Nullable BrowsePanel browsePanel) {
        this.myEditor = editor;
        this.myBrowsePanel = browsePanel;
    }

    public Component getTableCellEditorComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, int row, int column) {
        assert (value instanceof NlProperty);
        this.myEditor.setProperty((NlProperty)value);
        this.startCellEditing(table, row);
        if (this.myBrowsePanel != null) {
            this.myBrowsePanel.setDesignState(NlTableCellEditor.getDesignState(table, row));
        }
        return this.myEditor.getComponent();
    }

    protected void startCellEditing(@NotNull JTable table, int row) {
        this.myTable = table;
        this.myRow = row;
    }

    @Nullable
    JTable getTable() {
        return this.myTable;
    }

    int getRow() {
        return this.myRow;
    }

    protected final NlComponentEditor getEditor() {
        return this.myEditor;
    }

    public boolean stopCellEditing() {
        if (this.myTable != null) {
            this.myTable.requestFocus();
            if (!super.stopCellEditing()) {
                return false;
            }
            this.myTable = null;
            this.myRow = -1;
            this.myEditor.setProperty(EmptyProperty.INSTANCE);
        }
        return true;
    }

    public boolean isBooleanEditor() {
        return this.myEditor instanceof NlBooleanEditor;
    }

    public void activate() {
        this.myEditor.activate();
    }

    public Object getCellEditorValue() {
        return this.myEditor.getValue();
    }

    @Override
    public void stopEditing(@NotNull NlComponentEditor editor, @Nullable Object value) {
        this.stopCellEditing();
    }

    @Override
    public void cancelEditing(@NotNull NlComponentEditor editor) {
        this.cancelCellEditing();
    }

    @Override
    @Nullable
    public NlProperty getProperty() {
        return NlTableCellEditor.getPropertyAt(this.myTable, this.myRow);
    }

    @Override
    public void cancelEditing() {
        this.cancelCellEditing();
    }

    @Override
    public void addDesignProperty() {
        this.cancelEditing();
        NlTableCellEditor.addDesignProperty(this.myTable, this.myRow);
    }

    @Override
    public void removeDesignProperty() {
        this.cancelEditing();
        NlTableCellEditor.removeDesignProperty(this.myTable, this.myRow);
    }

    public static PropertyDesignState getDesignState(@NotNull JTable table, int row) {
        NlPropertyItem property = NlTableCellEditor.getPropertyAt(table, row);
        if (property == null) {
            return PropertyDesignState.NOT_APPLICABLE;
        }
        if ("http://schemas.android.com/tools".equals(property.getNamespace())) {
            NlProperty runtimeProperty = NlTableCellEditor.getRuntimeProperty(table, row);
            return runtimeProperty != null ? PropertyDesignState.IS_REMOVABLE_DESIGN_PROPERTY : PropertyDesignState.NOT_APPLICABLE;
        }
        NlProperty designProperty = NlTableCellEditor.getDesignProperty(table, row);
        return designProperty != null ? PropertyDesignState.HAS_DESIGN_PROPERTY : PropertyDesignState.MISSING_DESIGN_PROPERTY;
    }

    @Nullable
    public static NlPropertyItem getPropertyAt(@NotNull JTable table, int row) {
        if (!(table instanceof PTable) || row < 0 || row >= table.getRowCount()) {
            return null;
        }
        Object value = table.getValueAt(row, 1);
        if (value instanceof NlPropertyItem) {
            return (NlPropertyItem)value;
        }
        return null;
    }

    @Nullable
    public static NlProperty getRuntimeProperty(@NotNull JTable table, int row) {
        NlPropertyItem currentProperty = NlTableCellEditor.getPropertyAt(table, row);
        NlPropertyItem previousProperty = NlTableCellEditor.getPropertyAt(table, NlTableCellEditor.getPreviousPropertyRow(currentProperty, table, row));
        if (currentProperty != null && previousProperty != null && previousProperty.getName().equals(currentProperty.getName()) && "http://schemas.android.com/tools".equals(currentProperty.getNamespace()) && !"http://schemas.android.com/tools".equals(previousProperty.getNamespace())) {
            return previousProperty;
        }
        return null;
    }

    @Nullable
    public static NlProperty getDesignProperty(@NotNull JTable table, int row) {
        NlPropertyItem currentProperty = NlTableCellEditor.getPropertyAt(table, row);
        NlPropertyItem nextProperty = NlTableCellEditor.getPropertyAt(table, NlTableCellEditor.getNextPropertyRow(currentProperty, row));
        if (currentProperty != null && nextProperty != null && nextProperty.getName().equals(currentProperty.getName()) && !"http://schemas.android.com/tools".equals(currentProperty.getNamespace()) && "http://schemas.android.com/tools".equals(nextProperty.getNamespace())) {
            return nextProperty;
        }
        return null;
    }

    public static void addDesignProperty(@NotNull JTable table, int row) {
        NlPropertyItem property = NlTableCellEditor.getPropertyAt(table, row);
        assert (property != null && !"http://schemas.android.com/tools".equals(property.getNamespace()));
        assert (NlTableCellEditor.getDesignProperty(table, row) == null);
        PTableModel model = (PTableModel)table.getModel();
        int nextRow = NlTableCellEditor.getNextPropertyRow(property, row);
        model.insertRow(nextRow, (PTableItem)property.getDesignTimeProperty());
        if (property.isExpanded()) {
            model.expand(nextRow);
        }
        SwingUtilities.invokeLater(() -> table.editCellAt(row + 1, 1));
    }

    public static void removeDesignProperty(@NotNull JTable table, int row) {
        NlPropertyItem designProperty = NlTableCellEditor.getPropertyAt(table, row);
        assert (designProperty != null && "http://schemas.android.com/tools".equals(designProperty.getNamespace()));
        int previousRow = NlTableCellEditor.getPreviousPropertyRow(designProperty, table, row);
        PTableModel model = (PTableModel)table.getModel();
        designProperty.setValue(null);
        designProperty.delete();
        model.collapse(row);
        model.deleteRow(row);
        SwingUtilities.invokeLater(() -> table.editCellAt(previousRow, 1));
    }

    private static int getNextPropertyRow(@Nullable NlPropertyItem currentProperty, int row) {
        if (currentProperty == null) {
            return -1;
        }
        return row + 1 + (currentProperty.isExpanded() ? currentProperty.getChildren().size() : 0);
    }

    private static int getPreviousPropertyRow(@Nullable NlPropertyItem currentProperty, @NotNull JTable table, int row) {
        if (currentProperty == null || row == 0) {
            return -1;
        }
        PTableItem previous = (PTableItem)table.getValueAt(row - 1, 1);
        if (previous.getParent() != null && currentProperty.getParent() == null) {
            return row - previous.getParent().getChildren().size() - 1;
        }
        return row - 1;
    }
}

