/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.AttributeDefinitionEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.IdAnalyzer;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdEnumSupport
extends AttributeDefinitionEnumSupport {
    private final IdAnalyzer myIdAnalyzer;

    public IdEnumSupport(@NotNull NlProperty property) {
        this(property, new IdAnalyzer(property));
    }

    public IdEnumSupport(@NotNull NlProperty property, @NotNull IdAnalyzer analyzer) {
        super(property);
        this.myIdAnalyzer = analyzer;
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        List<ValueWithDisplayString> values = this.myIdAnalyzer.findIds().stream().map(id -> new ValueWithDisplayString(this.isEnumValue((String)id) ? "@+id/" + id : id, "@+id/" + id)).collect(Collectors.toList());
        this.addAttributeDefinitionValues(values);
        return values;
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value, @Nullable String hint) {
        if (!(value == null || value.startsWith("@+id/") || value.startsWith("@id/") || this.isEnumValue(value))) {
            value = "@+id/" + value;
        }
        String display = resolvedValue;
        display = StringUtil.trimStart((String)display, (String)"@id/");
        if (this.isEnumValue(display = StringUtil.trimStart((String)display, (String)"@+id/"))) {
            display = resolvedValue;
        }
        return new ValueWithDisplayString(display, value, hint);
    }
}

