/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.StyleFilter;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleEnumSupport
extends EnumSupport {
    protected final StyleFilter myStyleFilter;

    public StyleEnumSupport(@NotNull NlProperty property) {
        this(property, new StyleFilter(property.getModel().getProject(), property.getResolver()));
    }

    StyleEnumSupport(@NotNull NlProperty property, @NotNull StyleFilter styleFilter) {
        super(property);
        this.myStyleFilter = styleFilter;
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        String tagName = this.myProperty.getTagName();
        assert (tagName != null);
        return this.convertStylesToDisplayValues(this.myStyleFilter.getWidgetStyles(tagName));
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value, @Nullable String hint) {
        if (!(value == null || value.startsWith("@style/") || value.startsWith("@android:style/") || value.startsWith("?attr/"))) {
            ResourceResolver resolver = this.myProperty.getResolver();
            StyleResourceValue resource = resolver.getStyle(value, true);
            String prefix = resource != null ? "@android:style/" : "@style/";
            value = prefix + value;
        }
        String display = resolvedValue;
        display = StringUtil.trimStart((String)display, (String)"@android:style/");
        display = StringUtil.trimStart((String)display, (String)"@style/");
        return new ValueWithDisplayString(display, value, this.generateHint(display, value));
    }

    @Nullable
    protected String generateHint(@NotNull String display, @Nullable String value) {
        if (value == null) {
            return "default";
        }
        if (value.endsWith(display)) {
            return null;
        }
        return value;
    }

    @NotNull
    protected List<ValueWithDisplayString> convertStylesToDisplayValues(@NotNull List<StyleResourceValue> styles) {
        ArrayList<ValueWithDisplayString> values = new ArrayList<ValueWithDisplayString>();
        StyleResourceValue previousStyle = null;
        for (StyleResourceValue style : styles) {
            if (previousStyle != null && (previousStyle.isFramework() != style.isFramework() || previousStyle.isUserDefined() != style.isUserDefined())) {
                values.add(ValueWithDisplayString.SEPARATOR);
            }
            previousStyle = style;
            String prefix = style.isFramework() ? "@android:style/" : "@style/";
            values.add(this.createFromResolvedValue(style.getName(), prefix + style.getName(), null));
        }
        return values;
    }
}

