/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.resources.ResourceType;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorWithAutoCompletion
extends TextFieldWithAutoCompletion<String> {
    private final TextAttributes myTextAttributes;
    private final Insets myEditorInsets;
    private final CompletionProvider myCompletionProvider;
    private final PropertyChangeListener myPropertyChangeListener;
    private final List<LookupListener> myLookupListeners;

    public static TextEditorWithAutoCompletion create(@NotNull Project project, @NotNull Insets editorInsets) {
        CompletionProvider completionProvider = new CompletionProvider();
        return new TextEditorWithAutoCompletion(project, completionProvider, editorInsets);
    }

    private TextEditorWithAutoCompletion(@NotNull Project project, @NotNull CompletionProvider completionProvider, @NotNull Insets editorInsets) {
        super(project, (TextFieldWithAutoCompletionListProvider)completionProvider, true, null);
        this.myCompletionProvider = completionProvider;
        this.myTextAttributes = new TextAttributes(null, null, null, null, 0);
        this.myEditorInsets = editorInsets;
        this.myPropertyChangeListener = new LookupListenerHandler();
        this.myLookupListeners = new ArrayList<LookupListener>();
    }

    public void addNotify() {
        super.addNotify();
        EditorEx editor = (EditorEx)this.getEditor();
        assert (editor != null);
        editor.getColorsScheme().setAttributes(HighlighterColors.TEXT, this.myTextAttributes);
        editor.setHighlighter((EditorHighlighter)new EmptyEditorHighlighter(this.myTextAttributes));
        editor.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)true);
        editor.setBorder((Border)new DarculaEditorTextFieldBorder(){

            public Insets getBorderInsets(Component component2) {
                return new InsetsUIResource(((TextEditorWithAutoCompletion)TextEditorWithAutoCompletion.this).myEditorInsets.top, ((TextEditorWithAutoCompletion)TextEditorWithAutoCompletion.this).myEditorInsets.left, ((TextEditorWithAutoCompletion)TextEditorWithAutoCompletion.this).myEditorInsets.bottom, ((TextEditorWithAutoCompletion)TextEditorWithAutoCompletion.this).myEditorInsets.right);
            }
        });
        LookupManager.getInstance((Project)this.getProject()).addPropertyChangeListener(this.myPropertyChangeListener);
    }

    public void removeNotify() {
        super.removeNotify();
        LookupManager.getInstance((Project)this.getProject()).removePropertyChangeListener(this.myPropertyChangeListener);
        this.removeAll();
    }

    public void setTextColor(@NotNull Color color) {
        this.myTextAttributes.setForegroundColor(color);
        EditorEx editor = (EditorEx)this.getEditor();
        if (editor != null) {
            editor.getColorsScheme().setAttributes(HighlighterColors.TEXT, this.myTextAttributes);
            editor.setHighlighter((EditorHighlighter)new EmptyEditorHighlighter(this.myTextAttributes));
        }
    }

    public void setFontStyle(int style) {
        this.myTextAttributes.setFontType(style);
        EditorEx editor = (EditorEx)this.getEditor();
        if (editor != null) {
            editor.getColorsScheme().setAttributes(HighlighterColors.TEXT, this.myTextAttributes);
            editor.setHighlighter((EditorHighlighter)new EmptyEditorHighlighter(this.myTextAttributes));
        }
    }

    public void addLookupListener(@NotNull LookupListener listener) {
        this.myLookupListeners.add(listener);
    }

    public static List<String> loadCompletions(@NotNull AndroidFacet facet, @NotNull EnumSet<ResourceType> types, @Nullable NlProperty property) {
        ArrayList<String> items = new ArrayList<String>();
        if (property != null) {
            AttributeDefinition definition = property.getDefinition();
            if (definition != null && definition.getValues().length > 0) {
                items.addAll(Arrays.asList(definition.getValues()));
            }
            if (((AbstractCollection)types).contains(ResourceType.ID)) {
                types = ((EnumSet)types).clone();
                ((AbstractCollection)types).remove(ResourceType.ID);
                Set ids = (Set)ApplicationManager.getApplication().runReadAction(() -> ResourceHelper.findIdsInFile((PsiFile)property.getModel().getFile()));
                for (String id : ids) {
                    items.add("@id/" + id);
                }
            }
        }
        if (!((AbstractCollection)types).isEmpty()) {
            if (((AbstractCollection)types).contains(ResourceType.MIPMAP)) {
                types = ((EnumSet)types).clone();
                ((AbstractCollection)types).remove(ResourceType.MIPMAP);
                ((AbstractCollection)types).add(ResourceType.DRAWABLE);
            }
            items.addAll(ResourceHelper.getCompletionFromTypes(facet, (EnumSet<ResourceType>)types, false));
        }
        return items;
    }

    public void updateCompletions(@NotNull List<String> items) {
        this.myCompletionProvider.setItems(items);
    }

    public boolean editorHasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        Editor editor = this.getEditor();
        return editor != null && editor.getContentComponent().hasFocus();
    }

    private static class CompletionProvider
    extends TextFieldWithAutoCompletionListProvider<String> {
        protected CompletionProvider() {
            super(null);
        }

        @Nullable
        public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
            return new CamelHumpMatcher(prefix);
        }

        @Nullable
        protected Icon getIcon(@NotNull String item) {
            return item.startsWith("@android:") ? AndroidIcons.Android : null;
        }

        @NotNull
        protected String getLookupString(@NotNull String item) {
            return item;
        }

        @Nullable
        protected String getTailText(@NotNull String item) {
            return null;
        }

        @Nullable
        protected String getTypeText(@NotNull String item) {
            return null;
        }

        public int compare(String item1, String item2) {
            return ResourceHelper.compareResourceReferences(item1, item2);
        }
    }

    private class LookupListenerHandler
    implements PropertyChangeListener {
        private LookupListenerHandler() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent event) {
            Lookup lookup;
            Object newValue = event.getNewValue();
            if (newValue instanceof Lookup && (lookup = (Lookup)newValue).getTopLevelEditor() == TextEditorWithAutoCompletion.this.getEditor()) {
                TextEditorWithAutoCompletion.this.myLookupListeners.forEach(arg_0 -> ((Lookup)lookup).addLookupListener(arg_0));
            }
        }
    }
}

