/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueWithDisplayString {
    public static final ValueWithDisplayString SEPARATOR = new ValueWithDisplayString("-", "-");
    public static final ValueWithDisplayString UNSET = new ValueWithDisplayString("none", null);
    private final String myDisplayString;
    private final String myValue;
    private final String myHint;
    private final ValueSelector mySelector;
    private boolean myUseValueForToString;

    public ValueWithDisplayString(@Nullable String displayString, @Nullable String value) {
        this(displayString, value, null);
    }

    public ValueWithDisplayString(@Nullable String displayString, @Nullable String value, @Nullable String hint) {
        this(displayString, value, hint, null);
    }

    public ValueWithDisplayString(@Nullable String displayString, @Nullable String value, @Nullable String hint, @Nullable ValueSelector selector) {
        this.myDisplayString = StringUtil.notNullize((String)displayString);
        this.myValue = value;
        this.myHint = hint;
        this.mySelector = selector;
    }

    @NotNull
    public String toString() {
        return this.myUseValueForToString ? StringUtil.notNullize((String)this.myValue) : this.myDisplayString;
    }

    @NotNull
    public String getDisplayString() {
        return this.myDisplayString;
    }

    @Nullable
    public String getValue() {
        return this.myValue;
    }

    @Nullable
    public String getHint() {
        return this.myHint;
    }

    @Nullable
    public ValueSelector getValueSelector() {
        return this.mySelector;
    }

    public void setUseValueForToString(boolean useValueForToString) {
        this.myUseValueForToString = useValueForToString;
    }

    public int hashCode() {
        return Objects.hash(this.myValue, this.myDisplayString, this.myHint);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ValueWithDisplayString)) {
            return false;
        }
        ValueWithDisplayString value = (ValueWithDisplayString)other;
        return Objects.equals(this.myValue, value.myValue) && Objects.equals(this.myDisplayString, value.myDisplayString) && Objects.equals(this.myHint, value.myHint);
    }

    public static interface ValueSelector {
        @Nullable
        public ValueWithDisplayString selectValue(@Nullable String var1);
    }
}

