/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesInspectorProvider
implements InspectorProvider {
    private final List<String> myStarredPropertyNames = new ArrayList<String>();
    private FavoritesInspectorComponent myInspectorComponent;
    private String myLastStarredPropertyListValue;

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        this.loadStarredPropertiesIfNeeded();
        for (String propertyName : this.myStarredPropertyNames) {
            if (!properties.containsKey(FavoritesInspectorProvider.removePropertyPrefix(propertyName))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (this.myInspectorComponent == null) {
            this.myInspectorComponent = new FavoritesInspectorComponent(this.myStarredPropertyNames);
        }
        this.myInspectorComponent.updateProperties(components, properties, propertiesManager);
        return this.myInspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myLastStarredPropertyListValue = null;
        this.myStarredPropertyNames.clear();
        this.myInspectorComponent = null;
    }

    private void loadStarredPropertiesIfNeeded() {
        if (!Objects.equals(this.myLastStarredPropertyListValue, NlProperties.getStarredPropertiesAsString())) {
            this.loadStarredProperties();
        }
    }

    private void loadStarredProperties() {
        this.myLastStarredPropertyListValue = NlProperties.getStarredPropertiesAsString();
        this.myStarredPropertyNames.clear();
        for (String propertyName : NlProperties.getStarredProperties()) {
            if (!propertyName.startsWith("tools:")) {
                propertyName = FavoritesInspectorProvider.removePropertyPrefix(propertyName);
            }
            this.myStarredPropertyNames.add(propertyName);
        }
        Collections.sort(this.myStarredPropertyNames);
    }

    @NotNull
    private static String removePropertyPrefix(@NotNull String propertyName) {
        return propertyName.substring(propertyName.indexOf(58) + 1);
    }

    private static class FavoritesInspectorComponent
    implements InspectorComponent {
        private final List<String> myStarredPropertyNames;
        private final Map<String, NlComponentEditor> myEditorMap;

        private FavoritesInspectorComponent(@NotNull List<String> starredPropertyNames) {
            this.myStarredPropertyNames = starredPropertyNames;
            this.myEditorMap = new HashMap<String, NlComponentEditor>(starredPropertyNames.size());
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            for (String propertyName : this.myStarredPropertyNames) {
                NlProperty property = FavoritesInspectorComponent.findProperty(propertyName, properties);
                NlComponentEditor editor = this.myEditorMap.get(propertyName);
                if (property == null) {
                    if (editor == null) continue;
                    this.myEditorMap.remove(propertyName);
                    continue;
                }
                if (editor == null) {
                    editor = propertiesManager.getPropertyEditors().create(property);
                    this.myEditorMap.put(propertyName, editor);
                }
                editor.setProperty(property);
            }
        }

        @Nullable
        private static NlProperty findProperty(@NotNull String propertyName, @NotNull Map<String, NlProperty> properties) {
            boolean designPropertyRequired = propertyName.startsWith("tools:");
            NlProperty property = properties.get(propertyName = FavoritesInspectorProvider.removePropertyPrefix(propertyName));
            if (property == null) {
                return null;
            }
            if (designPropertyRequired) {
                property = property.getDesignTimeProperty();
            }
            return property;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myStarredPropertyNames.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            inspector.addTitle("Favorite Attributes");
            for (String propertyName : this.myStarredPropertyNames) {
                NlComponentEditor editor = this.myEditorMap.get(propertyName);
                if (editor == null) continue;
                NlProperty property = editor.getProperty();
                JLabel label = inspector.addComponent(property.getName(), property.getTooltipText(), editor.getComponent());
                if ("http://schemas.android.com/tools".equals(property.getNamespace())) {
                    label.setIcon(AndroidIcons.NeleIcons.DesignProperty);
                }
                editor.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            for (String propertyName : this.myStarredPropertyNames) {
                NlComponentEditor editor = this.myEditorMap.get(propertyName);
                if (editor == null) continue;
                editor.refresh();
            }
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            ArrayList<NlComponentEditor> editors = new ArrayList<NlComponentEditor>(this.myStarredPropertyNames.size());
            for (String propertyName : this.myStarredPropertyNames) {
                NlComponentEditor editor = this.myEditorMap.get(propertyName);
                if (editor == null) continue;
                editors.add(editor);
            }
            return editors;
        }
    }
}

