/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlDesignProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProviders;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.html.HtmlEscapers;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectorPanel
extends JPanel
implements KeyEventDispatcher {
    private static final int HORIZONTAL_SPACING = 6;
    private static final int COLUMN_COUNT = 2;
    private final JComponent myAllPropertiesLink;
    private final NlPropertiesManager myPropertiesManager;
    private final NlDesignProperties myDesignProperties;
    private final Font myBoldLabelFont = UIUtil.getLabelFont().deriveFont(1);
    private final GridInspectorPanel myInspector;
    private final SpeedSearchComparator myComparator;
    private final Map<Component, ExpandableGroup> mySource2GroupMap = new IdentityHashMap<Component, ExpandableGroup>(4);
    private final Map<JLabel, ExpandableGroup> myLabel2GroupMap = new IdentityHashMap<JLabel, ExpandableGroup>(4);
    private final Multimap<JLabel, Component> myLabel2ComponentMap = HashMultimap.create();
    private final JLabel myDefaultLabel = new JLabel();
    private final InspectorExpandableItemsHandler myExpandableItemsHandler;
    private final Disposable myParentDisposable;
    private InspectorProviders myInspectorProviders;
    private List<InspectorComponent> myInspectors = Collections.emptyList();
    private ExpandableGroup myGroup;
    private GridConstraints myConstraints = new GridConstraints();
    private int myRow;
    private boolean myActivateEditorAfterLoad;
    private String myPropertyNameForActivation;
    private String myFilter;

    public InspectorPanel(@NotNull NlPropertiesManager propertiesManager, @NotNull Disposable parentDisposable, @NotNull JComponent allPropertiesLink) {
        super(new BorderLayout());
        this.myAllPropertiesLink = allPropertiesLink;
        this.myAllPropertiesLink.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        this.myPropertiesManager = propertiesManager;
        this.myParentDisposable = parentDisposable;
        this.myDesignProperties = new NlDesignProperties();
        this.myInspector = new GridInspectorPanel();
        this.myInspector.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.myComparator = new SpeedSearchComparator(false);
        this.myExpandableItemsHandler = new InspectorExpandableItemsHandler(this);
        this.myFilter = "";
        this.add((Component)this.myInspector, "Center");
    }

    @Override
    public void requestFocus() {
        List<NlComponentEditor> editors;
        if (!this.myInspectors.isEmpty() && !(editors = this.myInspectors.get(0).getEditors()).isEmpty()) {
            editors.get(0).requestFocus();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.myExpandableItemsHandler.install(this.myParentDisposable);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.myExpandableItemsHandler.remove();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Component source;
        ExpandableGroup group;
        if (event.getKeyCode() == 9 && event.getModifiers() == 0 && event.getID() == 401 && event.getSource() instanceof Component && (group = this.mySource2GroupMap.get(source = (Component)event.getSource())) != null && !group.isExpanded()) {
            group.setExpanded(true, true);
            ApplicationManager.getApplication().invokeLater(source::transferFocus);
            return true;
        }
        return false;
    }

    public void setFilter(@NotNull String filter) {
        this.myFilter = filter;
        ApplicationManager.getApplication().invokeLater(this::updateAfterFilterChange);
    }

    @NotNull
    public String getFilter() {
        return this.myFilter;
    }

    public void enterInFilter(@NotNull KeyEvent event) {
        if (this.myFilter.isEmpty()) {
            return;
        }
        Set visibleLabels = this.myLabel2ComponentMap.keySet().stream().filter(Component::isVisible).collect(Collectors.toSet());
        if (visibleLabels.size() != 1) {
            return;
        }
        Collection components = this.myLabel2ComponentMap.get(visibleLabels.iterator().next());
        if (components.size() != 1) {
            return;
        }
        Component editor = (Component)components.iterator().next();
        editor.transferFocus();
        event.consume();
    }

    private void updateAfterFilterChange() {
        if (this.myFilter.isEmpty()) {
            this.restoreGroups();
        } else {
            this.applyFilter();
        }
        this.myInspector.invalidate();
        this.myInspector.repaint();
    }

    private void applyFilter() {
        for (JLabel label : this.myLabel2ComponentMap.keySet()) {
            boolean display = this.isMatch(label);
            label.setVisible(display);
            this.myLabel2ComponentMap.get((Object)label).forEach(component2 -> component2.setVisible(display));
            ExpandableGroup group = this.myLabel2GroupMap.get(label);
            if (group == null) continue;
            label.setIcon(null);
        }
    }

    private void restoreGroups() {
        HashSet<Component> toShow = new HashSet<Component>(Arrays.asList(this.myInspector.getComponents()));
        for (ExpandableGroup group : this.myLabel2GroupMap.values()) {
            toShow.removeAll(group.myComponents);
            group.setExpanded(group.isExpanded(), false);
        }
        toShow.forEach(component2 -> component2.setVisible(true));
        this.myInspectors.forEach(InspectorComponent::updateVisibility);
    }

    private boolean isMatch(@NotNull JLabel label) {
        if (this.myFilter.isEmpty()) {
            return true;
        }
        String text = StringUtil.removeHtmlTags((String)label.getText());
        if (StringUtil.isEmpty((String)text) || label.getFont() == this.myBoldLabelFont) {
            return false;
        }
        return this.myComparator.matchingFragments(this.myFilter, text) != null;
    }

    @NotNull
    private static GridLayoutManager createLayoutManager(int rows) {
        JBInsets margin = new JBInsets(0, 0, 0, 0);
        return new GridLayoutManager(rows, 2, (Insets)margin, 0, 0);
    }

    public void setComponent(@NotNull List<NlComponent> components, @NotNull Table<String, String, ? extends NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        this.myInspector.setLayout(null);
        this.myInspector.removeAll();
        this.mySource2GroupMap.clear();
        this.myLabel2GroupMap.clear();
        this.myLabel2ComponentMap.clear();
        this.myRow = 0;
        if (!components.isEmpty()) {
            HashMap propertiesByName = Maps.newHashMapWithExpectedSize((int)properties.size());
            for (NlProperty nlProperty : properties.row((Object)"http://schemas.android.com/apk/res/android").values()) {
                propertiesByName.put(nlProperty.getName(), nlProperty);
            }
            for (NlProperty nlProperty : properties.row((Object)"http://schemas.android.com/apk/res-auto").values()) {
                propertiesByName.put(nlProperty.getName(), nlProperty);
            }
            for (NlProperty nlProperty : properties.row((Object)"").values()) {
                propertiesByName.put(nlProperty.getName(), nlProperty);
            }
            for (NlProperty nlProperty : this.myDesignProperties.getKnownProperties(components, propertiesManager)) {
                propertiesByName.putIfAbsent(nlProperty.getName(), nlProperty);
            }
            if (this.myInspectorProviders != null) {
                Disposer.dispose((Disposable)this.myInspectorProviders);
            }
            this.myInspectorProviders = this.myPropertiesManager.getDesignSurface().getInspectorProviders(this.myPropertiesManager, this.myParentDisposable);
            this.myInspectors = this.myInspectorProviders.createInspectorComponents(components, propertiesByName, propertiesManager);
            int rows = 0;
            for (InspectorComponent inspector : this.myInspectors) {
                rows += inspector.getMaxNumberOfRows();
            }
            rows += this.myInspectors.size();
            this.myInspector.setLayout((LayoutManager)InspectorPanel.createLayoutManager(rows += 2));
            for (InspectorComponent inspector : this.myInspectors) {
                this.addSeparator();
                inspector.attachToInspector(this);
            }
            this.endGroup();
            this.addSeparator();
            this.myInspector.add((Component)new Spacer(), new GridConstraints(this.myRow++, 0, 1, 2, 0, 1, 2, 6, null, null, null, 0, false));
            this.addLineComponent(this.myAllPropertiesLink, this.myRow++);
        }
        this.myInspector.updateGridConstraints();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myFilter.isEmpty()) {
                this.applyFilter();
            }
            if (this.myActivateEditorAfterLoad) {
                this.activatePreferredEditor(this.myPropertyNameForActivation);
            }
            this.repaint();
        });
    }

    public void refresh() {
        ApplicationManager.getApplication().invokeLater(() -> this.myInspectors.forEach(InspectorComponent::refresh));
    }

    public void activatePreferredEditor(@NotNull String propertyName, boolean activateAfterLoading) {
        if (activateAfterLoading) {
            this.myActivateEditorAfterLoad = true;
            this.myPropertyNameForActivation = propertyName;
        } else {
            this.activatePreferredEditor(propertyName);
        }
    }

    private void activatePreferredEditor(@NotNull String propertyName) {
        this.myActivateEditorAfterLoad = false;
        this.myPropertyNameForActivation = null;
        boolean designPropertyRequired = propertyName.startsWith("tools:");
        propertyName = StringUtil.trimStart((String)propertyName, (String)"tools:");
        for (InspectorComponent component2 : this.myInspectors) {
            for (NlComponentEditor editor : component2.getEditors()) {
                NlProperty property = editor.getProperty();
                if (!propertyName.equals(property.getName()) || designPropertyRequired && !"http://schemas.android.com/tools".equals(property.getNamespace())) continue;
                editor.requestFocus();
                return;
            }
        }
    }

    public JLabel addTitle(@NotNull String title) {
        JLabel label = InspectorPanel.createLabel(title, null, null);
        label.setFont(this.myBoldLabelFont);
        this.addLineComponent(label, this.myRow++);
        this.myLabel2ComponentMap.put((Object)this.myDefaultLabel, (Object)label);
        return label;
    }

    public void addSeparator() {
        this.endGroup();
        if (this.myRow > 0) {
            JSeparator component2 = new JSeparator();
            this.addLineComponent(component2, this.myRow++);
            this.myLabel2ComponentMap.put((Object)this.myDefaultLabel, (Object)component2);
        }
    }

    public JLabel addExpandableComponent(@NotNull String labelText, @Nullable String tooltip, @NotNull Component component2, @NotNull Component keySource) {
        JLabel label = InspectorPanel.createLabel(labelText, tooltip, component2);
        this.addLabelComponent(label, this.myRow);
        this.addValueComponent(component2, this.myRow++);
        this.startGroup(label, keySource);
        this.myLabel2GroupMap.put(label, this.myGroup);
        this.myLabel2ComponentMap.put((Object)label, (Object)component2);
        return label;
    }

    public JLabel addComponent(@NotNull String labelText, @Nullable String tooltip, @NotNull Component component2) {
        JLabel label = InspectorPanel.createLabel(labelText, tooltip, component2);
        this.addLabelComponent(label, this.myRow);
        this.addValueComponent(component2, this.myRow++);
        this.myLabel2ComponentMap.put((Object)label, (Object)component2);
        return label;
    }

    public void addPanel(@NotNull JComponent panel) {
        this.addLineComponent(panel, this.myRow++);
        this.myLabel2ComponentMap.put((Object)this.myDefaultLabel, (Object)panel);
    }

    private static JLabel createLabel(@NotNull String labelText, @Nullable String tooltip, @Nullable Component component2) {
        JBLabel label = new JBLabel("<html>" + HtmlEscapers.htmlEscaper().escape(labelText) + "</html>");
        label.setLabelFor(component2);
        label.setToolTipText(tooltip);
        label.setSize(label.getPreferredSize());
        return label;
    }

    private void addLineComponent(@NotNull Component component2, int row) {
        this.addComponent(component2, row, 0, 2, 8, 1);
    }

    private void addLabelComponent(@NotNull Component component2, int row) {
        this.addComponent(component2, row, 0, 1, 8, 1);
    }

    private void addValueComponent(@NotNull Component component2, int row) {
        this.addComponent(component2, row, 1, 1, 4, 1);
    }

    private void addComponent(@NotNull Component component2, int row, int column, int columnSpan, int anchor, int fill2) {
        this.addToGridPanel(this.myInspector, component2, row, column, columnSpan, anchor, fill2);
        if (this.myGroup != null) {
            this.myGroup.addComponent(component2);
        }
    }

    private void addToGridPanel(@NotNull JPanel panel, @NotNull Component component2, int row, int column, int columnSpan, int anchor, int fill2) {
        this.myConstraints.setRow(row);
        this.myConstraints.setColumn(column);
        this.myConstraints.setColSpan(columnSpan);
        this.myConstraints.setAnchor(anchor);
        this.myConstraints.setFill(fill2);
        panel.add(component2, this.myConstraints);
    }

    private void startGroup(@NotNull JLabel label, @NotNull Component keySource) {
        assert (this.myGroup == null);
        this.myGroup = new ExpandableGroup(label);
        this.mySource2GroupMap.put(keySource, this.myGroup);
    }

    private void endGroup() {
        this.myGroup = null;
    }

    private static class InspectorExpandableItemsHandler
    extends AbstractExpandableItemsHandler<JLabel, JPanel> {
        private final MousePreprocessor myMousePreprocessor = new MousePreprocessor();
        private final JLabel myRenderer = new JLabel();

        protected InspectorExpandableItemsHandler(@NotNull InspectorPanel component2) {
            super((JComponent)component2.myInspector);
        }

        private void install(@NotNull Disposable parent) {
            IdeGlassPane glassPane = IdeGlassPaneUtil.find((Component)this.myComponent);
            glassPane.addMouseMotionPreprocessor((MouseMotionListener)this.myMousePreprocessor, parent);
        }

        private void remove() {
            IdeGlassPane glassPane = IdeGlassPaneUtil.find((Component)this.myComponent);
            glassPane.removeMouseMotionPreprocessor((MouseMotionListener)this.myMousePreprocessor);
        }

        @Nullable
        protected Pair<Component, Rectangle> getCellRendererAndBounds(@NotNull JLabel key) {
            this.myRenderer.setText(key.getText());
            this.myRenderer.setFont(key.getFont());
            this.myRenderer.setForeground(key.getForeground());
            this.myRenderer.setBackground(key.getBackground());
            Rectangle bounds = new Rectangle(key.getLocation(), key.getPreferredSize());
            return Pair.create((Object)this.myRenderer, (Object)bounds);
        }

        @NotNull
        protected Rectangle getVisibleRect(@NotNull JLabel key) {
            return SwingUtilities.convertRectangle(key, key.getVisibleRect(), this.myComponent);
        }

        @Nullable
        protected JLabel getCellKeyForPoint(@NotNull Point point) {
            return null;
        }

        private class MousePreprocessor
        extends MouseMotionAdapter {
            private MousePreprocessor() {
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent event) {
                Component component2;
                Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), InspectorExpandableItemsHandler.this.myComponent);
                if (((JPanel)InspectorExpandableItemsHandler.this.myComponent).contains(point) && (component2 = ((JPanel)InspectorExpandableItemsHandler.this.myComponent).getComponentAt(point.x, point.y)) instanceof JLabel) {
                    InspectorExpandableItemsHandler.this.handleSelectionChange((JLabel)component2, true);
                }
            }
        }
    }

    private static class GridInspectorPanel
    extends JPanel {
        private int myWidth;

        private GridInspectorPanel() {
        }

        @Override
        public void setLayout(LayoutManager layoutManager) {
            this.myWidth = -1;
            super.setLayout(layoutManager);
        }

        @Override
        public void invalidate() {
            this.myWidth = -1;
            super.invalidate();
        }

        @Override
        public void doLayout() {
            this.updateGridConstraints();
            super.doLayout();
        }

        private void updateGridConstraints() {
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof GridLayoutManager) {
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
                if (this.getWidth() != this.myWidth) {
                    this.myWidth = this.getWidth();
                    for (Component component2 : this.getComponents()) {
                        GridConstraints constraints = gridLayoutManager.getConstraintsForComponent(component2);
                        if (constraints == null) continue;
                        this.updateMinimumSize(constraints);
                    }
                }
            }
        }

        private void updateMinimumSize(@NotNull GridConstraints constraints) {
            if (constraints.getColSpan() == 1) {
                if (constraints.getColumn() == 0) {
                    constraints.myMinimumSize.setSize((double)(this.myWidth - 12) * 0.4, -1.0);
                } else if (constraints.getColumn() == 1) {
                    constraints.myMinimumSize.setSize((double)(this.myWidth - 12) * 0.6, -1.0);
                }
            }
        }
    }

    private static class ExpandableGroup {
        private static final String KEY_PREFIX = "inspector.open.";
        private static final Icon EXPANDED_ICON = (Icon)UIManager.get("Tree.expandedIcon");
        private static final Icon COLLAPSED_ICON = (Icon)UIManager.get("Tree.collapsedIcon");
        private final JLabel myLabel;
        private final List<Component> myComponents;
        private boolean myExpanded;

        public ExpandableGroup(final @NotNull JLabel label) {
            this.myLabel = label;
            this.myComponents = new ArrayList<Component>(4);
            this.myExpanded = PropertiesComponent.getInstance().getBoolean(KEY_PREFIX + StringUtil.removeHtmlTags((String)label.getText()));
            label.setIcon(this.myExpanded ? EXPANDED_ICON : COLLAPSED_ICON);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (label.getIcon() != null) {
                        this.setExpanded(!this.isExpanded(), true);
                    }
                }
            });
        }

        public void addComponent(@NotNull Component component2) {
            this.myComponents.add(component2);
            component2.setVisible(this.myExpanded);
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }

        public void setExpanded(boolean expanded, boolean updateProperties) {
            this.myExpanded = expanded;
            this.myLabel.setIcon(expanded ? EXPANDED_ICON : COLLAPSED_ICON);
            this.myComponents.forEach(component2 -> component2.setVisible(expanded));
            if (updateProperties) {
                PropertiesComponent.getInstance().setValue(KEY_PREFIX + StringUtil.removeHtmlTags((String)this.myLabel.getText()), expanded);
            }
        }
    }
}

