/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class InspectorProviders
implements LafManagerListener,
Disposable {
    protected final NlPropertiesManager myPropertiesManager;

    public InspectorProviders(NlPropertiesManager propertiesManager, Disposable parentDisposable) {
        this.myPropertiesManager = propertiesManager;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        LafManager.getInstance().addLafManagerListener((LafManagerListener)this);
    }

    @NotNull
    public List<InspectorComponent> createInspectorComponents(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        List<InspectorProvider> providers = this.getProviders();
        ArrayList<InspectorComponent> inspectors = new ArrayList<InspectorComponent>(providers.size());
        if (components.isEmpty()) {
            return ImmutableList.of((Object)this.getNullProvider().createCustomInspector(components, properties, propertiesManager));
        }
        for (InspectorProvider provider : providers) {
            if (!provider.isApplicable(components, properties, propertiesManager)) continue;
            inspectors.add(provider.createCustomInspector(components, properties, propertiesManager));
        }
        return inspectors;
    }

    public void lookAndFeelChanged(LafManager source) {
        this.getProviders().forEach(InspectorProvider::resetCache);
        this.myPropertiesManager.updateSelection();
    }

    public void dispose() {
        LafManager.getInstance().removeLafManagerListener((LafManagerListener)this);
    }

    protected abstract List<InspectorProvider> getProviders();

    protected abstract InspectorProvider getNullProvider();
}

