/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.model.PreferenceUtils;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanIconEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlEnumEditor;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import icons.StudioIcons;
import java.awt.FlowLayout;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextInspectorProvider
implements InspectorProvider {
    @VisibleForTesting
    static final List<String> TEXT_PROPERTIES = ImmutableList.of((Object)"text", (Object)"contentDescription", (Object)"textAppearance", (Object)"fontFamily", (Object)"typeface", (Object)"textSize", (Object)"lineSpacingExtra", (Object)"textStyle", (Object)"textAllCaps", (Object)"textAlignment", (Object)"textColor");
    private TextInspectorComponent myComponent;

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (!properties.keySet().containsAll(TEXT_PROPERTIES)) {
            return false;
        }
        for (NlComponent component2 : components) {
            if (!PreferenceUtils.VALUES.contains(component2.getTagName())) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public TextInspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (this.myComponent == null) {
            this.myComponent = new TextInspectorComponent(propertiesManager);
        }
        this.myComponent.updateProperties(components, properties, propertiesManager);
        return this.myComponent;
    }

    @Override
    public void resetCache() {
        this.myComponent = null;
    }

    static class TextInspectorComponent
    implements InspectorComponent {
        private final NlReferenceEditor myTextEditor;
        private final NlReferenceEditor myDesignTextEditor;
        private final NlReferenceEditor myDescriptionEditor;
        private final NlEnumEditor myStyleEditor;
        private final NlEnumEditor myFontFamilyEditor;
        private final NlEnumEditor myTypefaceEditor;
        private final NlEnumEditor myFontSizeEditor;
        private final NlEnumEditor mySpacingEditor;
        private final NlBooleanIconEditor myBoldEditor;
        private final NlBooleanIconEditor myItalicsEditor;
        private final NlBooleanIconEditor myAllCapsEditor;
        private final NlBooleanIconEditor myStartEditor;
        private final NlBooleanIconEditor myLeftEditor;
        private final NlBooleanIconEditor myCenterEditor;
        private final NlBooleanIconEditor myRightEditor;
        private final NlBooleanIconEditor myEndEditor;
        private final NlReferenceEditor myColorEditor;
        private final JPanel myTextStylePanel;
        private final JPanel myAlignmentPanel;
        private NlProperty myText;
        private NlProperty myDesignText;
        private NlProperty myDescription;
        private NlProperty myStyle;
        private NlProperty myFontFamily;
        private NlProperty myTypeface;
        private NlProperty myFontSize;
        private NlProperty mySpacing;
        private NlFlagPropertyItem myTextStyle;
        private NlProperty myTextAllCaps;
        private NlProperty myAlignment;
        private NlProperty myColor;

        public TextInspectorComponent(@NotNull NlPropertiesManager propertiesManager) {
            Project project = propertiesManager.getProject();
            this.myTextEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myDesignTextEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myDescriptionEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myStyleEditor = NlEnumEditor.createForInspector(this.createEnumStyleListener());
            this.myFontFamilyEditor = NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            this.myTypefaceEditor = NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            this.myFontSizeEditor = NlEnumEditor.createForInspectorWithBrowseButton(NlEditingListener.DEFAULT_LISTENER);
            this.mySpacingEditor = NlEnumEditor.createForInspectorWithBrowseButton(NlEditingListener.DEFAULT_LISTENER);
            this.myBoldEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_STYLE_BOLD, "Bold");
            this.myItalicsEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_STYLE_ITALIC, "Italics");
            this.myAllCapsEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_STYLE_UPPERCASE, "All Caps");
            this.myStartEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_ALIGN_LAYOUT_LEFT, "Align Start of View", "viewStart");
            this.myLeftEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_ALIGN_LEFT, "Align Start of Text", "textStart");
            this.myCenterEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_ALIGN_CENTER, "Align Center", "center");
            this.myRightEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_ALIGN_RIGHT, "Align End of Text", "textEnd");
            this.myEndEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_ALIGN_LAYOUT_RIGHT, "Align End of View", "viewEnd");
            this.myColorEditor = NlReferenceEditor.createForInspectorWithBrowseButton(propertiesManager.getProject(), NlEditingListener.DEFAULT_LISTENER);
            this.myTextStylePanel = new JPanel(new FlowLayout(3));
            this.myTextStylePanel.setFocusable(false);
            this.myTextStylePanel.add(this.myBoldEditor.getComponent());
            this.myTextStylePanel.add(this.myItalicsEditor.getComponent());
            this.myTextStylePanel.add(this.myAllCapsEditor.getComponent());
            this.myAlignmentPanel = new JPanel(new FlowLayout(3));
            this.myAlignmentPanel.setFocusable(false);
            this.myAlignmentPanel.add(this.myStartEditor.getComponent());
            this.myAlignmentPanel.add(this.myLeftEditor.getComponent());
            this.myAlignmentPanel.add(this.myCenterEditor.getComponent());
            this.myAlignmentPanel.add(this.myRightEditor.getComponent());
            this.myAlignmentPanel.add(this.myEndEditor.getComponent());
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            this.myText = properties.get("text");
            this.myDesignText = this.myText.getDesignTimeProperty();
            this.myDescription = properties.get("contentDescription");
            this.myStyle = properties.get("textAppearance");
            this.myFontFamily = properties.get("fontFamily");
            this.myTypeface = properties.get("typeface");
            this.myFontSize = properties.get("textSize");
            this.mySpacing = properties.get("lineSpacingExtra");
            this.myTextStyle = (NlFlagPropertyItem)properties.get("textStyle");
            this.myTextAllCaps = properties.get("textAllCaps");
            this.myAlignment = properties.get("textAlignment");
            this.myColor = properties.get("textColor");
        }

        @Override
        public int getMaxNumberOfRows() {
            return 12;
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            this.refresh();
            inspector.addTitle("TextView");
            inspector.addComponent("text", this.myText.getTooltipText(), this.myTextEditor.getComponent());
            JLabel designText = inspector.addComponent("text", this.myDesignText.getTooltipText(), this.myDesignTextEditor.getComponent());
            designText.setIcon(AndroidIcons.NeleIcons.DesignProperty);
            inspector.addComponent("contentDescription", this.myDescription.getTooltipText(), this.myDescriptionEditor.getComponent());
            inspector.addExpandableComponent("textAppearance", this.myStyle.getTooltipText(), this.myStyleEditor.getComponent(), this.myStyleEditor.getKeySource());
            inspector.addComponent("fontFamily", this.myFontFamily.getTooltipText(), this.myFontFamilyEditor.getComponent());
            inspector.addComponent("typeface", this.myTypeface.getTooltipText(), this.myTypefaceEditor.getComponent());
            inspector.addComponent("textSize", this.myFontSize.getTooltipText(), this.myFontSizeEditor.getComponent());
            inspector.addComponent("lineSpacingExtra", this.mySpacing.getTooltipText(), this.mySpacingEditor.getComponent());
            inspector.addComponent("textColor", this.myColor.getTooltipText(), this.myColorEditor.getComponent());
            inspector.addComponent("textStyle", this.myTextStyle.getTooltipText(), this.myTextStylePanel);
            inspector.addComponent("textAlignment", this.myAlignment.getTooltipText(), this.myAlignmentPanel);
        }

        @Override
        public void refresh() {
            this.myTextEditor.setProperty(this.myText);
            this.myDesignTextEditor.setProperty(this.myDesignText);
            this.myDescriptionEditor.setProperty(this.myDescription);
            this.myStyleEditor.setProperty(this.myStyle);
            this.myFontFamilyEditor.setProperty(this.myFontFamily);
            this.myTypefaceEditor.setProperty(this.myTypeface);
            this.myFontSizeEditor.setProperty(this.myFontSize);
            this.mySpacingEditor.setProperty(this.mySpacing);
            this.myBoldEditor.setProperty(this.myTextStyle.getChildProperty("bold"));
            this.myItalicsEditor.setProperty(this.myTextStyle.getChildProperty("italic"));
            this.myAllCapsEditor.setProperty(this.myTextAllCaps);
            this.myStartEditor.setProperty(this.myAlignment);
            this.myLeftEditor.setProperty(this.myAlignment);
            this.myCenterEditor.setProperty(this.myAlignment);
            this.myRightEditor.setProperty(this.myAlignment);
            this.myEndEditor.setProperty(this.myAlignment);
            this.myColorEditor.setProperty(this.myColor);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            return ImmutableList.of((Object)this.myTextEditor, (Object)this.myDesignTextEditor, (Object)this.myDescriptionEditor, (Object)this.myStyleEditor, (Object)this.myFontFamilyEditor, (Object)this.myTypefaceEditor, (Object)this.myFontSizeEditor, (Object)this.mySpacingEditor, (Object)this.myColorEditor);
        }

        public List<NlBooleanIconEditor> getTextStyleEditors() {
            return ImmutableList.of((Object)this.myBoldEditor, (Object)this.myItalicsEditor, (Object)this.myAllCapsEditor);
        }

        public List<NlBooleanIconEditor> getTextAlignmentEditors() {
            return ImmutableList.of((Object)this.myStartEditor, (Object)this.myLeftEditor, (Object)this.myCenterEditor, (Object)this.myRightEditor, (Object)this.myEndEditor);
        }

        private NlEditingListener createEnumStyleListener() {
            return new NlEditingListener(){

                @Override
                public void stopEditing(@NotNull NlComponentEditor editor, @Nullable Object value) {
                    if (!Objects.equal((Object)value, (Object)myStyle.getValue())) {
                        myStyle.setValue(value);
                        myTypeface.setValue(null);
                        myFontFamily.setValue(null);
                        myFontSize.setValue(null);
                        mySpacing.setValue(null);
                        myTextStyle.setValue(null);
                        myTextAllCaps.setValue(null);
                        myAlignment.setValue(null);
                        myColor.setValue(null);
                        this.refresh();
                    }
                }

                @Override
                public void cancelEditing(@NotNull NlComponentEditor editor) {
                }
            };
        }
    }
}

