/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableCellRenderer;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.intellij.openapi.util.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;

public abstract class NlAttributeRenderer
extends PTableCellRenderer {
    private final JPanel myPanel;
    private final BrowsePanel myBrowsePanel = new BrowsePanel();

    public NlAttributeRenderer() {
        this.myPanel = new JPanel(new BorderLayout(SystemInfo.isMac ? 0 : 2, 0));
        this.myPanel.add((Component)((Object)this), "Center");
        this.myPanel.add((Component)this.myBrowsePanel, "After");
    }

    public JPanel getContentPanel() {
        return this.myPanel;
    }

    public Component getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        if (!(table instanceof PTable)) {
            return this.myPanel;
        }
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        this.myPanel.setForeground(this.getForeground());
        this.myPanel.setBackground(this.getBackground());
        this.myBrowsePanel.setForeground(this.getForeground());
        this.myBrowsePanel.setBackground(this.getBackground());
        boolean hover = ((PTable)table).isHover(row, col);
        this.myBrowsePanel.setVisible(hover);
        this.myBrowsePanel.setDesignState(NlTableCellEditor.getDesignState(table, row));
        if (value instanceof NlProperty) {
            this.myBrowsePanel.setProperty((NlProperty)value);
        }
        return this.myPanel;
    }

    public abstract boolean canRender(@NotNull NlProperty var1, @NotNull Set<AttributeFormat> var2);

    public void mousePressed(@NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        this.myBrowsePanel.mousePressed(event, rectRightColumn);
    }

    public void mouseMoved(@NotNull PTable table, @NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        this.myBrowsePanel.mouseMoved(table, event, rectRightColumn);
    }
}

