/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.io.File;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.AndroidColorAnnotator;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDefaultRenderer
extends NlAttributeRenderer {
    public static final int ICON_SIZE = 14;

    protected void customizeCellRenderer(@NotNull PTable table, @NotNull PTableItem value, boolean selected, boolean hasFocus, int row, int col) {
        if (value instanceof NlProperty) {
            this.customize((NlProperty)value, col, selected);
        }
    }

    void customize(NlProperty property, int column, boolean selected) {
        if (column == 0) {
            this.appendName(property);
        } else {
            this.appendValue(property, selected);
        }
    }

    private void appendValue(@NotNull NlProperty property, boolean selected) {
        String value = property.getValue();
        String text = StringUtil.notNullize((String)value);
        Icon icon = NlDefaultRenderer.getIcon(property, 14);
        if (icon != null) {
            this.setIcon(icon);
        }
        if (!selected && !property.isDefaultValue(value)) {
            this.setForeground((Color)JBColor.BLUE);
        }
        this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.setToolTipText(text);
    }

    @Nullable
    public static Icon getIcon(@NotNull NlProperty property, int iconSize) {
        String text = property.getResolvedValue();
        if (text == null) {
            return null;
        }
        if (NlDefaultRenderer.isColorValue(text)) {
            return NlDefaultRenderer.getColorIcon(text, iconSize);
        }
        Configuration configuration = property.getModel().getConfiguration();
        if (configuration == null) {
            return null;
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        if (resolver == null) {
            return null;
        }
        if (text.startsWith("@color/") || text.startsWith("@android:color/")) {
            return NlDefaultRenderer.getColorIcon(resolver, property, text, iconSize);
        }
        if (text.startsWith("@drawable/") || text.startsWith("@android:drawable/") || text.startsWith("@mipmap/")) {
            return NlDefaultRenderer.getDrawableIcon(resolver, property, text);
        }
        return null;
    }

    @Nullable
    private static Icon getDrawableIcon(@NotNull ResourceResolver resolver, @NotNull NlProperty property, @NotNull String value) {
        ResourceType type = value.startsWith("@mipmap/") ? ResourceType.MIPMAP : ResourceType.DRAWABLE;
        ResourceValue drawable = resolver.resolveResValue(new ResourceValue(ResourceUrl.create((ResourceType)type, (String)property.getName(), (boolean)false), value));
        if (drawable == null) {
            return null;
        }
        File file = AndroidColorAnnotator.pickBestBitmap(ResourceHelper.resolveDrawable((RenderResources)resolver, drawable, property.getModel().getProject()));
        return file == null ? null : GutterIconCache.getInstance().getIcon(file.getPath(), resolver);
    }

    @Nullable
    private static Icon getColorIcon(@NotNull ResourceResolver resolver, @NotNull NlProperty property, @NotNull String value, int iconSize) {
        ResourceValue resourceValue = resolver.resolveResValue(new ResourceValue(ResourceUrl.create((ResourceType)ResourceType.COLOR, (String)property.getName(), (boolean)false), value));
        if (resourceValue == null) {
            return null;
        }
        String resolvedValue = resourceValue.getValue();
        if (NlDefaultRenderer.isColorValue(resolvedValue)) {
            return NlDefaultRenderer.getColorIcon(resolvedValue, iconSize);
        }
        return null;
    }

    private static boolean isColorValue(@Nullable String value) {
        return value != null && value.startsWith("#") && value.matches("#\\p{XDigit}+");
    }

    @Nullable
    private static Icon getColorIcon(@NotNull String hexColor, int iconSize) {
        Color color = ResourceHelper.parseColor(hexColor);
        return color == null ? null : JBUI.scale((JBUI.JBIcon)new ColorIcon(iconSize, color, true));
    }

    private void appendName(@NotNull NlProperty property) {
        this.append(property.getName());
        this.setToolTipText(property.getTooltipText());
    }

    @Override
    public boolean canRender(@NotNull NlProperty p, @NotNull Set<AttributeFormat> formats) {
        return true;
    }

    SimpleColoredComponent getLabel() {
        return this;
    }
}

