/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.tools.adtui.ptable.PNameRenderer;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableCellRenderer;
import com.android.tools.adtui.ptable.PTableCellRendererProvider;
import com.android.tools.adtui.ptable.PTableGroupItem;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItemValue;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlBooleanRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlDefaultRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlFlagItemRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlFlagRenderer;
import com.android.tools.idea.uibuilder.property.renderer.NlTableNameRenderer;
import java.util.Set;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;

public class NlPropertyRenderers
implements PTableCellRendererProvider {
    private static NlPropertyRenderers ourInstance = new NlPropertyRenderers();
    private final NlTableNameRenderer myTableNameRenderer = new NlTableNameRenderer();
    private final NlBooleanRenderer myBooleanRenderer = new NlBooleanRenderer();
    private final NlFlagRenderer myFlagRenderer = new NlFlagRenderer();
    private final NlFlagItemRenderer myFlagItemRenderer = new NlFlagItemRenderer();
    private final NlDefaultRenderer myDefaultRenderer = new NlDefaultRenderer();
    private final TableCellRenderer myGroupRenderer = NlPropertyRenderers.createGroupTableCellRenderer();

    public static NlPropertyRenderers getInstance() {
        if (ourInstance == null) {
            ourInstance = new NlPropertyRenderers();
        }
        return ourInstance;
    }

    private NlPropertyRenderers() {
    }

    @NotNull
    public PNameRenderer getNameCellRenderer(@NotNull PTableItem item) {
        return this.myTableNameRenderer;
    }

    @NotNull
    public TableCellRenderer getValueCellRenderer(@NotNull PTableItem item) {
        if (item instanceof PTableGroupItem) {
            return this.myGroupRenderer;
        }
        if (item instanceof NlProperty) {
            return this.get((NlProperty)item);
        }
        throw new IllegalArgumentException("Unrecognized table item " + item);
    }

    @NotNull
    public NlAttributeRenderer get(@NotNull NlProperty property) {
        if (property instanceof NlFlagPropertyItemValue) {
            return this.myFlagItemRenderer;
        }
        AttributeDefinition definition = property.getDefinition();
        if (definition == null) {
            return this.myDefaultRenderer;
        }
        Set<AttributeFormat> formats = definition.getFormats();
        if (formats.size() == 1 && formats.contains((Object)AttributeFormat.Boolean) && this.myBooleanRenderer.canRender(property, formats)) {
            return this.myBooleanRenderer;
        }
        if (formats.contains((Object)AttributeFormat.Flag) && this.myFlagRenderer.canRender(property, formats)) {
            return this.myFlagRenderer;
        }
        return this.myDefaultRenderer;
    }

    private static TableCellRenderer createGroupTableCellRenderer() {
        return new PTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull PTable table, @NotNull PTableItem value, boolean selected, boolean hasFocus, int row, int column) {
            }
        };
    }
}

