/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.tools.adtui.ptable.PNameRenderer;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableCellRenderer;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.adtui.ptable.StarState;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTableNameRenderer
extends PTableCellRenderer
implements PNameRenderer {
    private static final int BEFORE_STAR_SPACING = 2;
    private static final int STAR_SIZE = 16;
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final JLabel myStarLabel = new JBLabel();

    public NlTableNameRenderer() {
        this.myStarLabel.setPreferredSize(new Dimension(18, 16));
        this.myStarLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.myPanel.add((Component)this.myStarLabel, "West");
        this.myPanel.add((Component)((Object)this), "Center");
    }

    public Component getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.myPanel.setBackground(this.getBackground());
        return this.myPanel;
    }

    @Nullable
    private static Icon getStar(@NotNull StarState state, boolean isSelected, boolean isHovering) {
        switch (state) {
            case STARRED: {
                return isSelected ? StudioIcons.LayoutEditor.Properties.FAVORITES_SELECTED : StudioIcons.LayoutEditor.Properties.FAVORITES;
            }
            case STAR_ABLE: {
                return isHovering ? StudioIcons.LayoutEditor.Properties.FAVORITES_HOVER : null;
            }
        }
        return null;
    }

    protected void customizeCellRenderer(@NotNull PTable table, @NotNull PTableItem item, boolean selected, boolean hasFocus, int row, int col) {
        String label = item.getParent() != null ? item.getParent().getChildLabel(item) : item.getName();
        this.append(label, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.setToolTipText(item.getTooltipText());
        Point hoverPos = table.getHoverPosition();
        boolean hoveringOnStar = table.isHover(row, col) && this.hitTestStarIcon(hoverPos.x, hoverPos.y);
        this.myStarLabel.setIcon(NlTableNameRenderer.getStar(item.getStarState(), selected, hoveringOnStar));
        this.setIcon(item, selected, hasFocus);
        this.setPaintFocusBorder(false);
        this.setFocusBorderAroundIcon(true);
    }

    private void setIcon(PTableItem item, boolean selected, boolean hasFocus) {
        int textGap;
        int indent;
        Icon icon;
        Icon groupIcon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)selected, (boolean)hasFocus);
        int beforeGroupIcon = NlTableNameRenderer.getBeforeIconSpacing(NlTableNameRenderer.getDepth(item), groupIcon.getIconWidth());
        int afterGroupIcon = NlTableNameRenderer.getAfterIconSpacing(groupIcon.getIconWidth());
        if (item.hasChildren()) {
            icon = groupIcon;
            indent = beforeGroupIcon;
            textGap = afterGroupIcon;
        } else {
            icon = null;
            indent = beforeGroupIcon + groupIcon.getIconWidth() + afterGroupIcon;
            textGap = 0;
        }
        if ("http://schemas.android.com/tools".equals(item.getNamespace())) {
            if (icon == null) {
                icon = AndroidIcons.NeleIcons.DesignProperty;
            } else {
                LayeredIcon layered = new LayeredIcon(new Icon[]{icon, AndroidIcons.NeleIcons.DesignProperty});
                layered.setIcon(AndroidIcons.NeleIcons.DesignProperty, 1, afterGroupIcon + icon.getIconWidth(), 0);
                icon = layered;
            }
            textGap = 4;
        }
        super.setIcon(icon);
        this.setIconTextGap(textGap);
        this.setIpad((Insets)JBUI.insetsLeft((int)indent));
    }

    public boolean hitTestStarIcon(int x, int y) {
        return x >= 2 && x < 18;
    }

    public boolean hitTestTreeNodeIcon(@NotNull PTableItem item, int x, int y) {
        Icon icon = UIUtil.getTreeNodeIcon((boolean)item.isExpanded(), (boolean)true, (boolean)true);
        int beforeIcon = 18 + NlTableNameRenderer.getBeforeIconSpacing(NlTableNameRenderer.getDepth(item), icon.getIconWidth());
        return x >= beforeIcon && x <= beforeIcon + icon.getIconWidth();
    }

    private static int getBeforeIconSpacing(int depth, int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return nodeIndent * depth + leftIconOffset;
    }

    private static int getAfterIconSpacing(int iconWidth) {
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - iconWidth / 2);
        return Math.max(0, nodeIndent - leftIconOffset - iconWidth);
    }

    private static int getDepth(@NotNull PTableItem item) {
        int result = 0;
        while (item.getParent() != null) {
            ++result;
            item = item.getParent();
            assert (item != null);
        }
        return result;
    }
}

