/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.tools.adtui.ptable.PNameRenderer;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableCellRenderer;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.AddPropertyItem;
import com.android.tools.idea.uibuilder.property.NlResourceHeader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.BorderFactory;
import org.jetbrains.annotations.NotNull;

public class NlXmlNameRenderer
extends PTableCellRenderer
implements PNameRenderer {
    public static final JBColor NAMESPACE_COLOR = new JBColor(new Color(128, 0, 128), new Color(151, 118, 169));
    public static final JBColor ATTRIBUTE_COLOR = new JBColor(new Color(0, 0, 255), (Color)Gray._192);
    public static final JBColor TAG_COLOR = new JBColor(new Color(0, 0, 128), new Color(180, 180, 0));
    public static final JBColor NEW_VALUE_COLOR = new JBColor((Color)Gray._192, (Color)Gray._128);

    protected void customizeCellRenderer(@NotNull PTable table, @NotNull PTableItem item, boolean selected, boolean hasFocus, int row, int col) {
        JBColor color = ATTRIBUTE_COLOR;
        String name = item.getName();
        if (item instanceof NlResourceHeader) {
            color = TAG_COLOR;
            if (!selected) {
                this.setBackground(JBColor.border());
            }
            this.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createBorder((int)8), BorderFactory.createEmptyBorder(6, 0, 0, 0)));
        } else if (item instanceof AddPropertyItem && name.isEmpty()) {
            name = "+ name";
            color = NEW_VALUE_COLOR;
        }
        if (selected && hasFocus) {
            color = null;
        }
        SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(129, (Color)color, null, null);
        if (!StringUtil.isEmpty((String)item.getNamespace())) {
            color = selected && hasFocus ? null : NAMESPACE_COLOR;
            SimpleTextAttributes attrNamespace = attr.derive(-1, (Color)color, null, null);
            this.append(NlXmlNameRenderer.getNamespaceLabel(item.getNamespace()), attrNamespace, false);
            this.append(":", attr, false);
        }
        this.append(name, attr, true);
    }

    @NotNull
    private static String getNamespaceLabel(@NotNull String namespace) {
        switch (namespace) {
            case "http://schemas.android.com/apk/res/android": {
                return "android";
            }
            case "http://schemas.android.com/tools": {
                return "tools";
            }
            case "http://schemas.android.com/apk/res-auto": {
                return "app";
            }
        }
        return "other";
    }
}

