/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutDecorator;
import com.android.tools.idea.uibuilder.handlers.grid.draw.GridLayoutDecorator;
import com.android.tools.idea.uibuilder.handlers.grid.draw.GridLayoutV7Decorator;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.ButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.CheckBoxDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.ImageViewDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.LinearLayoutDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.NlSceneFrameFactory;
import com.android.tools.idea.uibuilder.scene.decorator.ProgressBarDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.RadioButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.SeekBarDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.SwitchDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.TextViewDecorator;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NlSceneDecoratorFactory
extends SceneDecoratorFactory {
    private static final NlSceneFrameFactory FRAME_FRACTORY = new NlSceneFrameFactory();
    private static Map<String, Constructor<? extends SceneDecorator>> ourConstructorMap = new HashMap<String, Constructor<? extends SceneDecorator>>();

    @Override
    @NotNull
    public SceneDecorator get(@NotNull NlComponent component2) {
        String className;
        String parentTag;
        String tag = component2.getTagName();
        if (tag.equalsIgnoreCase("merge") && (parentTag = component2.getAttribute("http://schemas.android.com/tools", "parentTag")) != null) {
            tag = parentTag;
        }
        if ((className = NlComponentHelperKt.getMostSpecificClass(component2, ourConstructorMap.keySet())) != null) {
            SceneDecorator decorator = this.get(className).orElse(BASIC_DECORATOR);
            decorator.setFrameFactory(FRAME_FRACTORY);
            return decorator;
        }
        SceneDecorator decorator = this.get(tag).orElse(BASIC_DECORATOR);
        decorator.setFrameFactory(FRAME_FRACTORY);
        return decorator;
    }

    @Override
    @NotNull
    protected Map<String, Constructor<? extends SceneDecorator>> getConstructorMap() {
        return ourConstructorMap;
    }

    static {
        try {
            ourConstructorMap.put("android.support.constraint.ConstraintLayout", ConstraintLayoutDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("ProgressBar", ProgressBarDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("Button", ButtonDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("TextView", TextViewDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("ImageView", ImageViewDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("CheckBox", CheckBoxDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("RadioButton", RadioButtonDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("SeekBar", SeekBarDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("Switch", SwitchDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("LinearLayout", LinearLayoutDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("GridLayout", GridLayoutDecorator.class.getConstructor(new Class[0]));
            ourConstructorMap.put("android.support.v7.widget.GridLayout", GridLayoutV7Decorator.class.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

