/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class ProgressBarDecorator
extends SceneDecorator {
    @Override
    public void addContent(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        Rectangle rect = new Rectangle();
        component2.fillDrawRect(time2, rect);
        int l = sceneContext.getSwingX(rect.x);
        int t = sceneContext.getSwingY(rect.y);
        int w = sceneContext.getSwingDimension(rect.width);
        int h = sceneContext.getSwingDimension(rect.height);
        list.add(new DrawProgressBar(l, t, w, h));
    }

    public static class DrawProgressBar
    extends DrawRegion {
        @Override
        public int getLevel() {
            return 20;
        }

        DrawProgressBar(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public DrawProgressBar(String s) {
            String[] sp = s.split(",");
            super.parse(sp, 0);
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            ColorSet colorSet = sceneContext.getColorSet();
            if (colorSet.drawBackground()) {
                g.setColor(colorSet.getComponentBackground());
                g.fillRect(this.x, this.y, this.width, this.height);
                int h = this.height;
                int w = this.width;
                g.setColor(colorSet.getFakeUI());
                g.fillRoundRect(this.x + 2, this.y + h / 2 - h / 8, w / 2, h / 4, h / 4, h / 4);
                g.drawRoundRect(this.x + 2, this.y + h / 2 - h / 8, w - 4, h / 4, h / 4, h / 4);
            }
        }
    }
}

