/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawTextRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class TextViewDecorator
extends SceneDecorator {
    private static final String DEFAULT_DIM = "14sp";

    @Override
    public void addContent(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        Rectangle rect = new Rectangle();
        component2.fillDrawRect(time2, rect);
        int l = sceneContext.getSwingX(rect.x);
        int t = sceneContext.getSwingY(rect.y);
        int w = sceneContext.getSwingDimension(rect.width);
        int h = sceneContext.getSwingDimension(rect.height);
        String text = ConstraintUtilities.getResolvedText(component2.getNlComponent());
        NlComponent nlc = component2.getNlComponent();
        int size = DrawTextRegion.getFont(nlc, DEFAULT_DIM);
        String alignment = nlc.getAttribute("http://schemas.android.com/apk/res/android", "textAlignment");
        boolean rtl = component2.getScene().isInRTL();
        int align = ConstraintUtilities.getAlignment(alignment, rtl);
        String single = nlc.getAttribute("http://schemas.android.com/apk/res/android", "singleLine");
        boolean singleLine = Boolean.parseBoolean(single);
        int baseLineOffset = sceneContext.getSwingDimension(component2.getBaseline());
        int mode = component2.isSelected() ? 2 : 0;
        list.add(new DrawTextRegion(l, t, w, h, mode, baseLineOffset, text, singleLine, false, align, 5, size, (float)sceneContext.getScale()));
    }
}

