/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.scene.draw.DrawHorizontalNotch;
import com.android.tools.idea.uibuilder.scene.draw.DrawVerticalNotch;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Notch {
    SceneComponent myOwner;
    int myNotchValue;
    int myDisplayValue;
    int myGap = 8;
    @Nullable
    Action myAction;
    boolean myDidApply = false;
    @Nullable
    Target myTarget;

    private Notch(@NotNull SceneComponent owner, int value, int displayValue) {
        this(owner, value, displayValue, null);
    }

    private Notch(@NotNull SceneComponent owner, int value, int displayValue, @Nullable Action action) {
        this.myOwner = owner;
        this.myNotchValue = value;
        this.myDisplayValue = displayValue;
        this.myAction = action;
    }

    public void setGap(int gap) {
        this.myGap = gap;
    }

    public void setAction(@Nullable Action action) {
        this.myAction = action;
    }

    public void applyAction(AttributesTransaction attributes) {
        if (this.myDidApply && this.myAction != null) {
            this.myAction.apply(attributes);
        }
    }

    public boolean didApply() {
        return this.myDidApply;
    }

    public int trySnap(int value) {
        this.myDidApply = false;
        if (Math.abs(value - this.myNotchValue) <= this.myGap) {
            this.myDidApply = true;
            return this.myNotchValue;
        }
        return value;
    }

    public void setTarget(@Nullable Target target) {
        this.myTarget = target;
    }

    @Nullable
    public Target getTarget() {
        return this.myTarget;
    }

    public abstract void render(@NotNull DisplayList var1, @NotNull SceneContext var2, @NotNull SceneComponent var3);

    public static class SmallVertical
    extends Notch {
        public SmallVertical(@NotNull SceneComponent owner, int value, int displayValue) {
            this(owner, value, displayValue, null);
        }

        public SmallVertical(@NotNull SceneComponent owner, int value, int displayValue, @Nullable Action action) {
            super(owner, value, displayValue, action);
            this.myGap = 6;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component2) {
            int gap = 16;
            int x1 = Math.min(this.myOwner.getDrawX(), component2.getDrawX()) - gap;
            int x2 = Math.max(this.myOwner.getDrawX() + this.myOwner.getDrawWidth(), component2.getDrawX() + component2.getDrawWidth()) + gap;
            DrawHorizontalNotch.add(list, context, x1, this.myDisplayValue, x2);
        }
    }

    public static class SmallHorizontal
    extends Notch {
        public SmallHorizontal(@NotNull SceneComponent owner, int value, int displayValue) {
            this(owner, value, displayValue, null);
        }

        public SmallHorizontal(@NotNull SceneComponent owner, int value, int displayValue, @Nullable Action action) {
            super(owner, value, displayValue, action);
            this.myGap = 6;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component2) {
            int gap = 16;
            int y1 = Math.min(this.myOwner.getDrawY(), component2.getDrawY()) - gap;
            int y2 = Math.max(this.myOwner.getDrawY() + this.myOwner.getDrawHeight(), component2.getDrawY() + component2.getDrawHeight()) + gap;
            DrawVerticalNotch.add(list, context, this.myDisplayValue, y1, y2);
        }
    }

    public static class Vertical
    extends Notch {
        public Vertical(@NotNull SceneComponent owner, int value, int displayValue) {
            this(owner, value, displayValue, null);
        }

        public Vertical(@NotNull SceneComponent owner, int value, int displayValue, @Nullable Action action) {
            super(owner, value, displayValue, action);
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component2) {
            SceneComponent parent = component2.getParent();
            if (parent != null) {
                DrawHorizontalNotch.add(list, context, parent.getDrawX(), this.myDisplayValue, parent.getDrawX() + parent.getDrawWidth());
            }
        }
    }

    public static class Horizontal
    extends Notch {
        public Horizontal(@NotNull SceneComponent owner, int value, int displayValue) {
            this(owner, value, displayValue, null);
        }

        public Horizontal(@NotNull SceneComponent owner, int value, int displayValue, @Nullable Action action) {
            super(owner, value, displayValue, action);
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component2) {
            SceneComponent parent = component2.getParent();
            if (parent != null) {
                DrawVerticalNotch.add(list, context, this.myDisplayValue, parent.getDrawY(), parent.getDrawY() + parent.getDrawHeight());
            }
        }
    }

    public static interface Snappable {
        @NotNull
        public TargetSnapper getTargetNotchSnapper();
    }

    public static interface Provider {
        public void fill(@NotNull SceneComponent var1, @NotNull SceneComponent var2, @NotNull ArrayList<Notch> var3, @NotNull ArrayList<Notch> var4);
    }

    public static interface Action {
        public void apply(@NotNull AttributesTransaction var1);
    }
}

