/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.scene.draw.DrawResize;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Cursor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResizeBaseTarget
extends BaseTarget {
    protected final Type myType;
    protected final int mySize = 2;
    protected int myStartX1;
    protected int myStartY1;
    protected int myStartX2;
    protected int myStartY2;

    public Type getType() {
        return this.myType;
    }

    public ResizeBaseTarget(@NotNull Type type) {
        this.myType = type;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        float d;
        float ratio = 1.0f / (float)sceneTransform.getScale();
        if (ratio > 2.0f) {
            ratio = 2.0f;
        }
        float size = 2.0f * ratio;
        float minWidth = 4.0f * size;
        float minHeight = 4.0f * size;
        if ((float)(r - l) < minWidth) {
            d = (minWidth - (float)(r - l)) / 2.0f;
            l = (int)((float)l - d);
            r = (int)((float)r + d);
        }
        if ((float)(b - t) < minHeight) {
            d = (minHeight - (float)(b - t)) / 2.0f;
            t = (int)((float)t - d);
            b = (int)((float)b + d);
        }
        int w = r - l;
        int h = b - t;
        int mw = l + w / 2;
        int mh = t + h / 2;
        switch (this.myType) {
            case LEFT: {
                this.myLeft = (float)l - size;
                this.myTop = (float)mh - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)mh + size;
                break;
            }
            case TOP: {
                this.myLeft = (float)mw - size;
                this.myTop = (float)t - size;
                this.myRight = (float)mw + size;
                this.myBottom = (float)t + size;
                break;
            }
            case RIGHT: {
                this.myLeft = (float)r - size;
                this.myTop = (float)mh - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)mh + size;
                break;
            }
            case BOTTOM: {
                this.myLeft = (float)mw - size;
                this.myTop = (float)b - size;
                this.myRight = (float)mw + size;
                this.myBottom = (float)b + size;
                break;
            }
            case LEFT_TOP: {
                this.myLeft = (float)l - size;
                this.myTop = (float)t - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)t + size;
                break;
            }
            case LEFT_BOTTOM: {
                this.myLeft = (float)l - size;
                this.myTop = (float)b - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)b + size;
                break;
            }
            case RIGHT_TOP: {
                this.myLeft = (float)r - size;
                this.myTop = (float)t - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)t + size;
                break;
            }
            case RIGHT_BOTTOM: {
                this.myLeft = (float)r - size;
                this.myTop = (float)b - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)b + size;
            }
        }
        return false;
    }

    @Override
    public Cursor getMouseCursor() {
        switch (this.myType) {
            case LEFT: {
                return Cursor.getPredefinedCursor(10);
            }
            case RIGHT: {
                return Cursor.getPredefinedCursor(11);
            }
            case TOP: {
                return Cursor.getPredefinedCursor(8);
            }
            case BOTTOM: {
                return Cursor.getPredefinedCursor(9);
            }
            case LEFT_TOP: {
                return Cursor.getPredefinedCursor(6);
            }
            case LEFT_BOTTOM: {
                return Cursor.getPredefinedCursor(4);
            }
            case RIGHT_TOP: {
                return Cursor.getPredefinedCursor(7);
            }
            case RIGHT_BOTTOM: {
                return Cursor.getPredefinedCursor(5);
            }
        }
        return Cursor.getPredefinedCursor(0);
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (!this.myComponent.getScene().allowsTarget(this)) {
            return;
        }
        DrawResize.add(list, sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, this.mIsOver ? 1 : 0);
    }

    protected abstract void updateAttributes(@NotNull AttributesTransaction var1, int var2, int var3);

    @Override
    public int getPreferenceLevel() {
        return 60;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myStartX1 = this.myComponent.getDrawX();
        this.myStartY1 = this.myComponent.getDrawY();
        this.myStartX2 = this.myComponent.getDrawX() + this.myComponent.getDrawWidth();
        this.myStartY2 = this.myComponent.getDrawY() + this.myComponent.getDrawHeight();
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable List<Target> closestTargets) {
        NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction attributes = component2.startAttributeTransaction();
        this.updateAttributes(attributes, x, y);
        attributes.apply();
        this.myComponent.getScene().needsLayout(1);
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTargets) {
        NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction attributes = component2.startAttributeTransaction();
        this.updateAttributes(attributes, x, y);
        attributes.apply();
        NlWriteCommandAction.run(component2, "Resize " + StringUtil.getShortName((String)component2.getTagName()), attributes::commit);
        this.myComponent.getScene().needsLayout(1);
    }

    @Override
    public String getToolTipText() {
        return "Resize View";
    }

    public static enum Type {
        LEFT,
        LEFT_TOP,
        LEFT_BOTTOM,
        TOP,
        BOTTOM,
        RIGHT,
        RIGHT_TOP,
        RIGHT_BOTTOM;

    }
}

