/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import java.awt.Point;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetSnapper {
    public static final int PARENT = 1;
    public static final int PARENT_TARGET = 2;
    public static final int CHILD = 4;
    public static final int CHILD_TARGET = 8;
    public static final int ALL = 15;
    private final ArrayList<Notch> myHorizontalNotches = new ArrayList();
    private final ArrayList<Notch> myVerticalNotches = new ArrayList();
    @Nullable
    private Notch myCurrentNotchY;
    @Nullable
    private Notch myCurrentNotchX;
    private int myNotchesSourcesMask = 15;

    public Point applyNotches(SceneComponent component2, AttributesTransaction attributes, int mouseX, int mouseY) {
        return this.applyNotches(component2, attributes, new Point(mouseX, mouseY));
    }

    public Point applyNotches(@NotNull SceneComponent component2, @NotNull AttributesTransaction attributes, @NotNull Point snapLocation) {
        if (this.myCurrentNotchX != null) {
            snapLocation.x = this.myCurrentNotchX.trySnap(snapLocation.x);
            if (component2.allowsAutoConnect()) {
                this.myCurrentNotchX.applyAction(attributes);
            }
            this.myCurrentNotchX = null;
        }
        if (this.myCurrentNotchY != null) {
            snapLocation.y = this.myCurrentNotchY.trySnap(snapLocation.y);
            if (component2.allowsAutoConnect()) {
                this.myCurrentNotchY.applyAction(attributes);
            }
            this.myCurrentNotchY = null;
        }
        return snapLocation;
    }

    public int trySnapX(int x) {
        int count = this.myHorizontalNotches.size();
        for (int i = 0; i < count; ++i) {
            Notch notch = this.myHorizontalNotches.get(i);
            x = notch.trySnap(x);
            if (!notch.didApply()) continue;
            this.myCurrentNotchX = notch;
            return x;
        }
        this.myCurrentNotchX = null;
        return x;
    }

    public int trySnapY(int y) {
        int count = this.myVerticalNotches.size();
        for (int i = 0; i < count; ++i) {
            Notch notch = this.myVerticalNotches.get(i);
            y = notch.trySnap(y);
            if (!notch.didApply()) continue;
            this.myCurrentNotchY = notch;
            return y;
        }
        this.myCurrentNotchY = null;
        return y;
    }

    public void gatherNotches(@NotNull SceneComponent snappable) {
        Notch.Provider notchProvider;
        this.myCurrentNotchX = null;
        this.myCurrentNotchY = null;
        this.myHorizontalNotches.clear();
        this.myVerticalNotches.clear();
        SceneComponent parent = snappable.getParent();
        if (parent == null) {
            return;
        }
        if ((this.myNotchesSourcesMask & 1) > 0 && (notchProvider = parent.getNotchProvider()) != null) {
            notchProvider.fill(parent, snappable, this.myHorizontalNotches, this.myVerticalNotches);
        }
        if ((this.myNotchesSourcesMask & 2) > 0) {
            this.gatherNotchFromTargets(snappable, parent);
        }
        if ((this.myNotchesSourcesMask & 0xC) > 0) {
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                Notch.Provider provider;
                SceneComponent child = parent.getChild(i);
                if (child == snappable) continue;
                if ((this.myNotchesSourcesMask & 4) > 0 && (provider = child.getNotchProvider()) != null) {
                    provider.fill(child, snappable, this.myHorizontalNotches, this.myVerticalNotches);
                }
                if ((this.myNotchesSourcesMask & 8) <= 0) continue;
                this.gatherNotchFromTargets(snappable, child);
            }
        }
    }

    public void setSources(int sourceMask) {
        this.myNotchesSourcesMask = sourceMask;
    }

    private void gatherNotchFromTargets(@NotNull SceneComponent snappable, @NotNull SceneComponent owner) {
        for (Target target : owner.getTargets()) {
            if (!(target instanceof Notch.Provider)) continue;
            ((Notch.Provider)((Object)target)).fill(owner, snappable, this.myHorizontalNotches, this.myVerticalNotches);
        }
    }

    public void renderCurrentNotches(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        if (this.myCurrentNotchX != null) {
            this.myCurrentNotchX.render(list, sceneContext, component2);
        }
        if (this.myCurrentNotchY != null) {
            this.myCurrentNotchY.render(list, sceneContext, component2);
        }
    }

    @Nullable
    public Notch getSnappedNotchX() {
        return this.myCurrentNotchX;
    }

    @Nullable
    public Notch getSnappedNotchY() {
        return this.myCurrentNotchY;
    }
}

