/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.ScoutProbabilities;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ScoutWidget
implements Comparable<ScoutWidget> {
    private static final boolean DEBUG = false;
    private static final float MAXIMUM_STRETCH_GAP = 0.6f;
    private int mX;
    private int mY;
    private int mWidth;
    private int mHeight;
    private int mBaseLine;
    private ScoutWidget mParent;
    boolean mCheckedForChain;
    private DimensionInfo mPreConvertDimension;
    private float mRootDistance;
    private float[] mDistToRootCache = new float[]{-1.0f, -1.0f, -1.0f, -1.0f};
    NlComponent mNlComponent;
    private boolean mKeepExistingConnections = true;
    private Rectangle mRectangle;
    HashMap<String, ScoutWidget> myChildMap = new HashMap();
    private static final String ATT_LL = "layout_constraintLeft_toLeftOf";
    private static final String ATT_LR = "layout_constraintLeft_toRightOf";
    private static final String ATT_RL = "layout_constraintRight_toLeftOf";
    private static final String ATT_RR = "layout_constraintRight_toRightOf";
    private static final String ATT_SS = "layout_constraintStart_toStartOf";
    private static final String ATT_SE = "layout_constraintStart_toEndOf";
    private static final String ATT_ES = "layout_constraintEnd_toStartOf";
    private static final String ATT_EE = "layout_constraintEnd_toEndOf";
    private static final String ATT_TT = "layout_constraintTop_toTopOf";
    private static final String ATT_TB = "layout_constraintTop_toBottomOf";
    private static final String ATT_BT = "layout_constraintBottom_toTopOf";
    private static final String ATT_BB = "layout_constraintBottom_toBottomOf";
    private static final String ATT_BASE = "layout_constraintBaseline_toBaselineOf";
    private static final String[] ATTR_LEFT = new String[]{"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf"};
    private static final String[] ATTR_RIGHT = new String[]{"layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf", "layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf"};
    private static final String[] ATTR_TOP = new String[]{"layout_constraintTop_toBottomOf", "layout_constraintTop_toTopOf"};
    private static final String[] ATTR_BOTTOM = new String[]{"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf"};
    private static final String[] ATTR_BASE = new String[]{"layout_constraintBaseline_toBaselineOf"};
    static final String[][] ATTR_CONNECTIONS = new String[][]{ATTR_TOP, ATTR_BOTTOM, ATTR_LEFT, ATTR_RIGHT, ATTR_BASE};
    private static final Direction[] DIR_LEFT = new Direction[]{Direction.LEFT, Direction.RIGHT, Direction.LEFT, Direction.RIGHT};
    private static final Direction[] DIR_RIGHT = new Direction[]{Direction.RIGHT, Direction.LEFT, Direction.RIGHT, Direction.LEFT};
    private static final Direction[] DIR_TOP = new Direction[]{Direction.BOTTOM, Direction.TOP};
    private static final Direction[] DIR_BOTTOM = new Direction[]{Direction.TOP, Direction.BOTTOM};
    private static final Direction[] DIR_BASE = new Direction[]{Direction.BASELINE};
    static final Direction[][] ATTR_DIR_CONNECT = new Direction[][]{DIR_TOP, DIR_BOTTOM, DIR_LEFT, DIR_RIGHT, DIR_BASE};
    static Comparator<ScoutWidget> sSortY = (w1, w2) -> w1.getDpY() - w2.getDpY();

    public ScoutWidget(NlComponent component2, ScoutWidget parent) {
        this.mNlComponent = component2;
        this.mParent = parent;
        this.mX = ConstraintComponentUtilities.getDpX(component2);
        this.mY = ConstraintComponentUtilities.getDpY(component2);
        this.mWidth = ConstraintComponentUtilities.getDpWidth(component2);
        this.mHeight = ConstraintComponentUtilities.getDpHeight(component2);
        this.mBaseLine = ConstraintComponentUtilities.getDpBaseline(component2) + this.mY;
        if (parent != null) {
            this.mRootDistance = ScoutWidget.distance(parent, this);
        }
        if (parent != null) {
            parent.addChild(this);
            this.mX -= parent.mX;
            this.mY -= parent.mY;
            this.mBaseLine -= parent.mY;
        }
    }

    void addChild(ScoutWidget widget) {
        String id = widget.mNlComponent.getLiveAttribute("http://schemas.android.com/apk/res/android", "id");
        this.myChildMap.put(id, widget);
    }

    ScoutWidget getChild(String id) {
        return this.myChildMap.get(id);
    }

    @Override
    public int compareTo(ScoutWidget scoutWidget) {
        if (this.mParent == null) {
            return -1;
        }
        if (this.mRootDistance != scoutWidget.mRootDistance) {
            return Float.compare(this.mRootDistance, scoutWidget.mRootDistance);
        }
        if (this.mY != scoutWidget.mY) {
            return Float.compare(this.mY, scoutWidget.mY);
        }
        if (this.mX != scoutWidget.mX) {
            return Float.compare(this.mX, scoutWidget.mX);
        }
        return 0;
    }

    public String toString() {
        return this.mNlComponent.toString() + "(" + this.mNlComponent.getId() + ") [ " + this.mX + " , " + this.mY + " ] " + this.mWidth + " x " + this.mHeight;
    }

    boolean isRoot() {
        return this.mParent == null;
    }

    public boolean isGuideline() {
        return ConstraintComponentUtilities.isLine(this.mNlComponent);
    }

    public boolean isVerticalGuideline() {
        return ConstraintComponentUtilities.isVerticalGuideline(this.mNlComponent);
    }

    public boolean isHorizontalGuideline() {
        return ConstraintComponentUtilities.isHorizontalGuideline(this.mNlComponent);
    }

    public static ScoutWidget[] create(List<NlComponent> list, ScoutWidget parent) {
        ScoutWidget[] ret = new ScoutWidget[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new ScoutWidget(list.get(i), parent);
        }
        return ret;
    }

    public static ScoutWidget[] create(NlComponent[] array, boolean fromConvert) {
        ScoutWidget rootWidget;
        Object[] ret = new ScoutWidget[array.length];
        NlComponent root = null;
        if (array.length == 0) {
            return ret;
        }
        if (array.length == 1) {
            root = array[0];
        }
        for (int i = 1; i < ret.length; ++i) {
            NlComponent component1 = array[i - 1];
            NlComponent component2 = array[i];
            if (component1.getParent() != component2.getParent()) {
                if (component2.getParent() != component1) break;
                root = component1;
                break;
            }
            if (component1.getParent() == component2.getParent()) continue;
            if (component1.getParent() != component2) break;
            root = component2;
            break;
        }
        ret[0] = rootWidget = new ScoutWidget(root, null);
        int count = 1;
        for (int i = 0; i < ret.length; ++i) {
            if (array[i] == root) continue;
            int n = count++;
            ScoutWidget current = new ScoutWidget(array[i], rootWidget);
            ret[n] = current;
            if (!fromConvert) continue;
            current.mPreConvertDimension = new DimensionInfo(array[i], current);
        }
        rootWidget.mX = 0;
        rootWidget.mY = 0;
        Arrays.sort(ret, 1, ret.length);
        return ret;
    }

    float getLocation(Direction dir) {
        switch (dir) {
            case TOP: {
                return this.mY;
            }
            case BOTTOM: {
                return this.mY + this.mHeight;
            }
            case LEFT: {
                return this.mX;
            }
            case RIGHT: {
                return this.mX + this.mWidth;
            }
            case BASELINE: {
                return this.mBaseLine;
            }
        }
        return this.mBaseLine;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public int getHeightInt() {
        return this.mHeight;
    }

    public float getWidth() {
        return this.mWidth;
    }

    public int getWidthInt() {
        return this.mWidth;
    }

    final float getX() {
        return this.mX;
    }

    final float getY() {
        return this.mY;
    }

    public static void computeConstraints(ScoutWidget[] list) {
        ScoutProbabilities table = new ScoutProbabilities();
        table.computeConstraints(list);
        table.applyConstraints(list);
    }

    private static Direction lookupType(int dir) {
        return Direction.get(dir);
    }

    public void setDpX(int value) {
        ConstraintComponentUtilities.setScoutAbsoluteDpX(this.mNlComponent, value, true);
    }

    public void setDpY(int value) {
        ConstraintComponentUtilities.setScoutAbsoluteDpY(this.mNlComponent, value, true);
    }

    public void setDpHeight(int value) {
        ConstraintComponentUtilities.setScoutAbsoluteDpHeight(this.mNlComponent, value, true);
    }

    public void setDpWidth(int value) {
        ConstraintComponentUtilities.setScoutAbsoluteDpWidth(this.mNlComponent, value, true);
    }

    public void setHorizontalDimensionBehaviour(DimensionBehaviour behaviour) {
        switch (behaviour) {
            case FIXED: {
                this.setDpWidth(this.mWidth);
                break;
            }
            case MATCH_CONSTRAINT: {
                ConstraintComponentUtilities.setScoutAttributeValue(this.mNlComponent, "http://schemas.android.com/apk/res/android", "layout_width", "0dp");
                break;
            }
            case WRAP_CONTENT: {
                ConstraintComponentUtilities.setScoutAttributeValue(this.mNlComponent, "http://schemas.android.com/apk/res/android", "layout_width", "wrap_content");
                break;
            }
            case MATCH_PARENT: {
                ConstraintComponentUtilities.setScoutAttributeValue(this.mNlComponent, "http://schemas.android.com/apk/res/android", "layout_width", "match_parent");
            }
        }
    }

    public void setVerticalDimensionBehaviour(DimensionBehaviour behaviour) {
        switch (behaviour) {
            case FIXED: {
                this.setDpHeight(this.mHeight);
                break;
            }
            case MATCH_CONSTRAINT: {
                ConstraintComponentUtilities.setScoutAttributeValue(this.mNlComponent, "http://schemas.android.com/apk/res/android", "layout_height", "0dp");
                break;
            }
            case WRAP_CONTENT: {
                ConstraintComponentUtilities.setScoutAttributeValue(this.mNlComponent, "http://schemas.android.com/apk/res/android", "layout_height", "wrap_content");
                break;
            }
            case MATCH_PARENT: {
                ConstraintComponentUtilities.setScoutAttributeValue(this.mNlComponent, "http://schemas.android.com/apk/res/android", "layout_height", "match_parent");
            }
        }
    }

    private void connect(Direction sourceDirection, ScoutWidget target, Direction targetDirection, int gap) {
        ConstraintComponentUtilities.scoutConnect(this.mNlComponent, sourceDirection, target.mNlComponent, targetDirection, gap);
    }

    private void connectWeak(Direction dir2, ScoutWidget to2, Direction dir21, int gap) {
    }

    static ScoutWidget[] getWidgetArray(NlComponent base) {
        ArrayList<NlComponent> list = new ArrayList<NlComponent>(base.getChildren());
        list.add(0, base);
        return ScoutWidget.create(list.toArray(new NlComponent[list.size()]), false);
    }

    public static boolean isConnected(NlComponent component2, Direction dir) {
        String[] attrs;
        for (String attr : attrs = ATTR_CONNECTIONS[dir.ordinal()]) {
            String id = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", attr);
            if (id == null) continue;
            return true;
        }
        return false;
    }

    public Anchor getAnchor(Direction direction) {
        return new Anchor(direction);
    }

    public int getDpX() {
        return this.mX;
    }

    public int getDpY() {
        return this.mY;
    }

    public int getDpWidth() {
        return this.mWidth;
    }

    public int getDpHeight() {
        return this.mHeight;
    }

    public int getDpBaseline() {
        return this.mY;
    }

    public static boolean hasBaseline(@NotNull NlComponent component2) {
        return NlComponentHelperKt.getBaseline(component2) > 0;
    }

    boolean setCentered(int dir, ScoutWidget to1, ScoutWidget to2, Direction cDir1, Direction cDir2, float gap) {
        Direction ori = dir == 0 ? Direction.TOP : Direction.LEFT;
        Anchor anchor1 = this.getAnchor(ori);
        Anchor anchor2 = this.getAnchor(ori.getOpposite());
        if (this.mKeepExistingConnections && (anchor1.isConnected() || anchor2.isConnected())) {
            if (anchor1.isConnected() ^ anchor2.isConnected()) {
                return false;
            }
            if (anchor1.isConnected() && anchor1.getTarget().getOwner() != to1) {
                return false;
            }
            if (anchor2.isConnected() && anchor2.getTarget().getOwner() != to2) {
                return false;
            }
        }
        if (anchor1.isConnectionAllowed(to1) && anchor2.isConnectionAllowed(to2)) {
            if (!this.isResizable(dir)) {
                float stretchRatio;
                if (dir == 0) {
                    int height = this.getDpHeight();
                    stretchRatio = gap * 2.0f / (float)height;
                    if (this.isCandidateResizable(dir) && stretchRatio < 0.6f) {
                        this.setVerticalDimensionBehaviour(DimensionBehaviour.MATCH_CONSTRAINT);
                    } else {
                        gap = 0.0f;
                    }
                } else {
                    int width = this.getDpWidth();
                    stretchRatio = gap * 2.0f / (float)width;
                    if (this.isCandidateResizable(dir) && stretchRatio < 0.6f) {
                        this.setHorizontalDimensionBehaviour(DimensionBehaviour.MATCH_CONSTRAINT);
                    } else {
                        gap = 0.0f;
                    }
                }
            }
            if (to1.equals(to2)) {
                if (ConstraintComponentUtilities.wouldCreateLoop(this.mNlComponent, cDir1, to1.mNlComponent)) {
                    return false;
                }
                if (ConstraintComponentUtilities.wouldCreateLoop(this.mNlComponent, cDir2, to2.mNlComponent)) {
                    return false;
                }
                this.connect(cDir1, to1, cDir1, (int)gap);
                this.connect(cDir2, to2, cDir2, (int)gap);
            } else {
                float pos2;
                float pos1 = to1.getLocation(cDir1);
                Direction c1 = pos1 < (pos2 = to2.getLocation(cDir2)) ? ori : ori.getOpposite();
                Direction c2 = pos1 > pos2 ? ori : ori.getOpposite();
                int gap1 = ScoutWidget.gap(this, c1, to1, cDir1);
                int gap2 = ScoutWidget.gap(this, c2, to2, cDir2);
                if (ConstraintComponentUtilities.wouldCreateLoop(this.mNlComponent, c1, to1.mNlComponent)) {
                    return false;
                }
                if (ConstraintComponentUtilities.wouldCreateLoop(this.mNlComponent, c2, to2.mNlComponent)) {
                    return false;
                }
                this.connect(c1, to1, cDir1, Math.max(0, gap1));
                this.connect(c2, to2, cDir2, Math.max(0, gap2));
            }
            return true;
        }
        return false;
    }

    private static int gap(ScoutWidget widget1, Direction direction1, ScoutWidget widget2, Direction direction2) {
        switch (direction1) {
            case TOP: 
            case LEFT: {
                return ScoutWidget.getPos(widget1, direction1) - ScoutWidget.getPos(widget2, direction2);
            }
            case BOTTOM: 
            case RIGHT: {
                return ScoutWidget.getPos(widget2, direction2) - ScoutWidget.getPos(widget1, direction1);
            }
        }
        return 0;
    }

    private static int getPos(ScoutWidget widget, Direction direction) {
        switch (direction) {
            case TOP: {
                return widget.getDpY();
            }
            case BOTTOM: {
                return widget.getDpY() + widget.getDpHeight();
            }
            case LEFT: {
                return widget.getDpX();
            }
            case RIGHT: {
                return widget.getDpX() + widget.getDpWidth();
            }
        }
        return 0;
    }

    boolean setEdgeCentered(int dir, ScoutWidget to1, Direction cDir1) {
        Direction ori = dir == 0 ? Direction.TOP : Direction.LEFT;
        Anchor anchor1 = this.getAnchor(ori);
        Anchor anchor2 = this.getAnchor(ori.getOpposite());
        if (this.mKeepExistingConnections && (anchor1.isConnected() || anchor2.isConnected())) {
            if (anchor1.isConnected() ^ anchor2.isConnected()) {
                return false;
            }
            if (anchor1.isConnected() && anchor1.getTarget().getOwner() != to1) {
                return false;
            }
        }
        if (anchor1.isConnectionAllowed(to1)) {
            if (ConstraintComponentUtilities.wouldCreateLoop(this.mNlComponent, ori, to1.mNlComponent)) {
                return false;
            }
            this.connect(ori, to1, cDir1, 0);
            this.connect(ori.getOpposite(), to1, cDir1, 0);
        }
        return true;
    }

    boolean setConstraint(int dir, ScoutWidget to, int cDir, float gap) {
        Direction anchorType = ScoutWidget.lookupType(dir);
        if (to.isGuideline()) {
            cDir &= 2;
        }
        Direction cAnchorType = ScoutWidget.lookupType(cDir);
        Anchor anchor = this.getAnchor(anchorType);
        if (this.mKeepExistingConnections) {
            if (anchor.isConnected()) {
                return anchor.getTarget().getOwner() == to;
            }
            if (dir == Direction.BASELINE.getDirection()) {
                if (this.getAnchor(Direction.BOTTOM).isConnected()) {
                    return false;
                }
                if (this.getAnchor(Direction.TOP).isConnected()) {
                    return false;
                }
            } else if (dir == Direction.TOP.getDirection()) {
                if (this.getAnchor(Direction.BOTTOM).isConnected()) {
                    return false;
                }
                if (this.getAnchor(Direction.BASELINE).isConnected()) {
                    return false;
                }
            } else if (dir == Direction.BOTTOM.getDirection()) {
                if (this.getAnchor(Direction.TOP).isConnected()) {
                    return false;
                }
                if (this.getAnchor(Direction.BASELINE).isConnected()) {
                    return false;
                }
            } else if (dir == Direction.LEFT.getDirection() ? this.getAnchor(Direction.RIGHT).isConnected() : dir == Direction.RIGHT.getDirection() && this.getAnchor(Direction.LEFT).isConnected()) {
                return false;
            }
        }
        if (anchor.isConnectionAllowed(to)) {
            if (ConstraintComponentUtilities.wouldCreateLoop(this.mNlComponent, anchorType, to.mNlComponent)) {
                return false;
            }
            this.connect(anchorType, to, cAnchorType, (int)gap);
            return true;
        }
        return false;
    }

    boolean setWeakConstraint(int dir, ScoutWidget to, int cDir) {
        Direction direction = Direction.get(dir);
        Anchor anchor = this.getAnchor(direction);
        float gap = 8.0f;
        if (this.mKeepExistingConnections && anchor.isConnected()) {
            return anchor.getTarget().getOwner() == to;
        }
        if (anchor.isConnectionAllowed(to)) {
            this.connectWeak(ScoutWidget.lookupType(dir), to, ScoutWidget.lookupType(cDir), (int)gap);
            return true;
        }
        return false;
    }

    static float distance(ScoutWidget a, ScoutWidget b) {
        float ax1 = a.mX;
        float ax2 = a.mX + a.mWidth;
        float ay1 = a.mY;
        float ay2 = a.mY + a.mHeight;
        if (a.isVerticalGuideline()) {
            ay1 = -10000.0f;
            ay2 = 10000.0f;
        }
        if (a.isHorizontalGuideline()) {
            ax1 = -10000.0f;
            ax2 = 10000.0f;
        }
        float bx1 = b.mX;
        float bx2 = b.mX + b.mWidth;
        float by1 = b.mY;
        float by2 = b.mY + b.mHeight;
        if (b.isVerticalGuideline()) {
            by1 = -10000.0f;
            by2 = 10000.0f;
        }
        if (b.isHorizontalGuideline()) {
            bx1 = -10000.0f;
            bx2 = 10000.0f;
        }
        float xdiff11 = Math.abs(ax1 - bx1);
        float xdiff12 = Math.abs(ax1 - bx2);
        float xdiff21 = Math.abs(ax2 - bx1);
        float xdiff22 = Math.abs(ax2 - bx2);
        float ydiff11 = Math.abs(ay1 - by1);
        float ydiff12 = Math.abs(ay1 - by2);
        float ydiff21 = Math.abs(ay2 - by1);
        float ydiff22 = Math.abs(ay2 - by2);
        float xmin = Math.min(Math.min(xdiff11, xdiff12), Math.min(xdiff21, xdiff22));
        float ymin = Math.min(Math.min(ydiff11, ydiff12), Math.min(ydiff21, ydiff22));
        boolean yOverlap = ay1 <= by2 && by1 <= ay2;
        boolean xOverlap = ax1 <= bx2 && bx1 <= ax2;
        float xReturn = yOverlap ? xmin : (float)Math.hypot(xmin, ymin);
        float yReturn = xOverlap ? ymin : (float)Math.hypot(xmin, ymin);
        return Math.min(xReturn, yReturn);
    }

    public ScoutWidget getParent() {
        return this.mParent;
    }

    public boolean isCandidateResizable(int dimension) {
        if (this.mPreConvertDimension != null) {
            if (dimension == 0) {
                boolean ret = this.mHeight != this.mPreConvertDimension.myWrapHeight;
            } else {
                boolean ret = this.mWidth != this.mPreConvertDimension.myWrapWidth;
            }
        } else if (dimension == 0) {
            boolean ret = ConstraintComponentUtilities.hasUserResizedVertically(this.mNlComponent);
        } else {
            boolean bl = ConstraintComponentUtilities.hasUserResizedHorizontally(this.mNlComponent);
        }
        if (this.mPreConvertDimension != null) {
            if (dimension == 0) {
                return this.mHeight != this.mPreConvertDimension.myWrapHeight;
            }
            return this.mWidth != this.mPreConvertDimension.myWrapWidth;
        }
        if (dimension == 0) {
            return ConstraintComponentUtilities.hasUserResizedVertically(this.mNlComponent);
        }
        return ConstraintComponentUtilities.hasUserResizedHorizontally(this.mNlComponent);
    }

    public boolean isResizable(int dimension) {
        if (dimension == 0) {
            return ConstraintComponentUtilities.isVerticalResizable(this.mNlComponent);
        }
        return ConstraintComponentUtilities.isHorizontalResizable(this.mNlComponent);
    }

    public boolean hasBaseline() {
        return ConstraintComponentUtilities.hasBaseline(this.mNlComponent);
    }

    public ScoutWidget getNeighbor(Direction dir, ScoutWidget[] list) {
        ScoutWidget neigh = list[0];
        float minDist = Float.MAX_VALUE;
        switch (dir) {
            case LEFT: {
                float ay1 = this.getLocation(Direction.TOP);
                float ay2 = this.getLocation(Direction.BOTTOM);
                float ax = this.getLocation(Direction.LEFT);
                for (int i = 1; i < list.length; ++i) {
                    float bx;
                    ScoutWidget iw = list[i];
                    if (iw == this) continue;
                    float by1 = iw.getLocation(Direction.TOP);
                    float by2 = iw.getLocation(Direction.BOTTOM);
                    if (!(Math.max(ay1, by1) <= Math.min(ay2, by2)) || !((bx = iw.getLocation(Direction.RIGHT)) < ax) || !(ax - bx < minDist)) continue;
                    minDist = ax - bx;
                    neigh = iw;
                }
                return neigh;
            }
            case RIGHT: {
                float ay1 = this.getLocation(Direction.TOP);
                float ay2 = this.getLocation(Direction.BOTTOM);
                float ax = this.getLocation(Direction.RIGHT);
                for (int i = 1; i < list.length; ++i) {
                    float bx;
                    ScoutWidget iw = list[i];
                    if (iw == this) continue;
                    float by1 = iw.getLocation(Direction.TOP);
                    float by2 = iw.getLocation(Direction.BOTTOM);
                    if (!(Math.max(ay1, by1) <= Math.min(ay2, by2)) || !((bx = iw.getLocation(Direction.LEFT)) > ax) || !(bx - ax < minDist)) continue;
                    minDist = bx - ax;
                    neigh = iw;
                }
                return neigh;
            }
            case BOTTOM: {
                float ax1 = this.getLocation(Direction.LEFT);
                float ax2 = this.getLocation(Direction.RIGHT);
                float ay = this.getLocation(Direction.BOTTOM);
                for (int i = 1; i < list.length; ++i) {
                    float by;
                    ScoutWidget iw = list[i];
                    if (iw == this) continue;
                    float bx1 = iw.getLocation(Direction.LEFT);
                    float bx2 = iw.getLocation(Direction.RIGHT);
                    if (!(Math.max(ax1, bx1) <= Math.min(ax2, bx2)) || !((by = iw.getLocation(Direction.TOP)) > ay) || !(by - ay < minDist)) continue;
                    minDist = by - ay;
                    neigh = iw;
                }
                return neigh;
            }
            case TOP: {
                float ax1 = this.getLocation(Direction.LEFT);
                float ax2 = this.getLocation(Direction.RIGHT);
                float ay = this.getLocation(Direction.TOP);
                for (int i = 1; i < list.length; ++i) {
                    float by;
                    ScoutWidget iw = list[i];
                    if (iw == this) continue;
                    float bx1 = iw.getLocation(Direction.LEFT);
                    float bx2 = iw.getLocation(Direction.RIGHT);
                    if (!(Math.max(ax1, bx1) <= Math.min(ax2, bx2)) || !(ay > (by = iw.getLocation(Direction.BOTTOM))) || !(ay - by < minDist)) continue;
                    minDist = ay - by;
                    neigh = iw;
                }
                return neigh;
            }
        }
        return null;
    }

    public boolean isConnected(Direction direction) {
        return this.getAnchor(direction).isConnected();
    }

    public boolean isConnected(Direction direction, ScoutWidget to) {
        Anchor anchor = this.getAnchor(direction);
        if (anchor.isConnected()) {
            return anchor.getTarget().getOwner() == to;
        }
        return false;
    }

    private boolean isDistanceToRootCache(Direction direction) {
        int directionOrdinal = direction.getDirection();
        Float f = Float.valueOf(this.mDistToRootCache[directionOrdinal]);
        return !(f.floatValue() < 0.0f);
    }

    private void cacheRootDistance(Direction d, float value) {
        this.mDistToRootCache[d.getDirection()] = value;
    }

    public float connectedDistanceToRoot(ScoutWidget[] list, Direction direction) {
        float value = this.recursiveConnectedDistanceToRoot(list, direction);
        this.cacheRootDistance(direction, value);
        return value;
    }

    private float recursiveConnectedDistanceToRoot(ScoutWidget[] list, Direction direction) {
        if (this.isDistanceToRootCache(direction)) {
            return this.mDistToRootCache[direction.getDirection()];
        }
        Anchor anchor = this.getAnchor(direction);
        if (anchor == null || !anchor.isConnected()) {
            return Float.NaN;
        }
        float margin = anchor.getMargin();
        Anchor toAnchor = anchor.getTarget();
        ScoutWidget toWidget = toAnchor.getOwner();
        if (list[0] == toWidget) {
            return margin;
        }
        if (toAnchor.getType() == direction) {
            for (ScoutWidget scoutWidget : list) {
                if (scoutWidget != toWidget) continue;
                float dist = scoutWidget.recursiveConnectedDistanceToRoot(list, direction);
                scoutWidget.cacheRootDistance(direction, dist);
                return margin + dist;
            }
        }
        if (toAnchor.getType() == direction.getOpposite()) {
            for (ScoutWidget scoutWidget : list) {
                if (scoutWidget != toWidget) continue;
                float dist = scoutWidget.recursiveConnectedDistanceToRoot(list, direction);
                scoutWidget.cacheRootDistance(direction, dist);
                return (margin += scoutWidget.getLength(direction)) + dist;
            }
        }
        return Float.NaN;
    }

    private float getLength(Direction direction) {
        switch (direction) {
            case TOP: 
            case BOTTOM: {
                return this.mHeight;
            }
            case LEFT: 
            case RIGHT: {
                return this.mWidth;
            }
        }
        return 0.0f;
    }

    public boolean isCentered(int orientationVertical) {
        if (this.isGuideline()) {
            return false;
        }
        if (orientationVertical == 0) {
            return this.getAnchor(Direction.TOP).isConnected() && this.getAnchor(Direction.BOTTOM).isConnected();
        }
        return this.getAnchor(Direction.LEFT).isConnected() && this.getAnchor(Direction.RIGHT).isConnected();
    }

    public boolean hasConnection(Direction dir) {
        Anchor anchor = this.getAnchor(dir);
        return anchor != null && anchor.isConnected();
    }

    public Rectangle getRectangle() {
        if (this.mRectangle == null) {
            this.mRectangle = new Rectangle();
        }
        this.mRectangle.x = this.getDpX();
        this.mRectangle.y = this.getDpY();
        this.mRectangle.width = this.getDpWidth();
        this.mRectangle.height = this.getDpHeight();
        return this.mRectangle;
    }

    public int gap(Direction direction, ScoutWidget[] list) {
        int rootWidth = list[0].getDpWidth();
        int rootHeight = list[0].getDpHeight();
        Rectangle rect = new Rectangle();
        switch (direction) {
            case TOP: {
                rect.y = 0;
                rect.x = this.getDpX() + 1;
                rect.width = this.getDpWidth() - 2;
                rect.height = this.getDpY();
                break;
            }
            case BOTTOM: {
                rect.y = this.getDpY() + this.getDpHeight();
                rect.x = this.getDpX() + 1;
                rect.width = this.getDpWidth() - 2;
                rect.height = rootHeight - rect.y;
                break;
            }
            case LEFT: {
                rect.y = this.getDpY() + 1;
                rect.x = 0;
                rect.width = this.getDpX();
                rect.height = this.getDpHeight() - 2;
                break;
            }
            case RIGHT: {
                rect.y = this.getDpY() + 1;
                rect.x = this.getDpX() + this.getDpWidth();
                rect.width = rootWidth - rect.x;
                rect.height = this.getDpHeight() - 2;
                break;
            }
        }
        int min = Integer.MAX_VALUE;
        for (int i = 1; i < list.length; ++i) {
            int dist;
            Rectangle r;
            ScoutWidget scoutWidget = list[i];
            if (scoutWidget == this || !(r = scoutWidget.getRectangle()).intersects(rect) || min <= (dist = (int)ScoutWidget.distance(scoutWidget, this))) continue;
            min = dist;
        }
        if (min > Math.max(rootHeight, rootWidth)) {
            switch (direction) {
                case TOP: {
                    return this.getDpY();
                }
                case BOTTOM: {
                    return rootHeight - (this.getDpY() + this.getDpHeight());
                }
                case LEFT: {
                    return this.getDpX();
                }
                case RIGHT: {
                    return rootWidth - (this.getDpX() + this.getDpWidth());
                }
            }
        }
        return min;
    }

    public void setX(int x) {
        this.setDpX(x);
        this.mX = x;
    }

    public void setY(int y) {
        this.setDpY(y);
        this.mY = y;
    }

    public void setWidth(int width) {
        this.setDpWidth(width);
        this.mWidth = width;
    }

    public void setHeight(int height) {
        this.setDpHeight(height);
        this.mHeight = height;
    }

    public int rootDistanceY() {
        if (this.mNlComponent == null || this.mNlComponent.getParent() == null) {
            return 0;
        }
        int rootHeight = this.getParent().getDpHeight();
        int aY = this.getDpY();
        int aHeight = this.getDpHeight();
        return Math.min(aY, rootHeight - (aY + aHeight));
    }

    class Anchor {
        Direction myDirection;

        Anchor(Direction dir) {
            this.myDirection = dir;
        }

        public boolean isConnected() {
            String[] attrs;
            for (String attr : attrs = ATTR_CONNECTIONS[this.myDirection.ordinal()]) {
                String id = ScoutWidget.this.mNlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", attr);
                if (id == null) continue;
                return true;
            }
            return false;
        }

        public ScoutWidget getTargetWidget() {
            String[] attrs;
            int dir = this.myDirection.ordinal();
            for (String attr : attrs = ATTR_CONNECTIONS[dir]) {
                String id = ScoutWidget.this.mNlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", attr);
                if (id == null) continue;
                return ScoutWidget.this.getParent().getChild(id);
            }
            return null;
        }

        public Anchor getTarget() {
            int dir = this.myDirection.ordinal();
            String[] attrs = ATTR_CONNECTIONS[dir];
            for (int i = 0; i < attrs.length; ++i) {
                String attr = attrs[i];
                String id = ScoutWidget.this.mNlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", attr);
                if (id != null && id.equalsIgnoreCase("parent")) {
                    return ScoutWidget.this.getParent().getAnchor(ATTR_DIR_CONNECT[dir][i]);
                }
                if (id == null || ScoutWidget.this.getParent() == null || ScoutWidget.this.getParent().getChild(id) == null) continue;
                return ScoutWidget.this.getParent().getChild(id).getAnchor(ATTR_DIR_CONNECT[dir][i]);
            }
            return null;
        }

        ScoutWidget getOwner() {
            return ScoutWidget.this;
        }

        public boolean isConnectionAllowed(ScoutWidget component2) {
            if (this.isConnected()) {
                return false;
            }
            if (ScoutWidget.this.getParent() == component2) {
                return true;
            }
            switch (this.myDirection) {
                case TOP: 
                case BOTTOM: 
                case BASELINE: {
                    if (ScoutWidget.this == component2.getAnchor(Direction.TOP).getTargetWidget()) {
                        return false;
                    }
                    if (ScoutWidget.this == component2.getAnchor(Direction.BOTTOM).getTargetWidget()) {
                        return false;
                    }
                    return ScoutWidget.this != component2.getAnchor(Direction.BASELINE).getTargetWidget();
                }
                case LEFT: 
                case RIGHT: {
                    if (ScoutWidget.this == component2.getAnchor(Direction.LEFT).getTargetWidget()) {
                        return false;
                    }
                    return ScoutWidget.this != component2.getAnchor(Direction.RIGHT).getTargetWidget();
                }
            }
            return true;
        }

        public int getMargin() {
            return ConstraintComponentUtilities.getMargin(ScoutWidget.this.mNlComponent, this.myDirection.getMarginString());
        }

        public Direction getType() {
            return this.myDirection;
        }
    }

    static class DimensionInfo {
        int myHeight;
        int myWidth;
        int myWrapWidth;
        int myWrapHeight;

        public DimensionInfo(NlComponent component2, ScoutWidget widget) {
            this.myWidth = this.convert(component2, "layout_conversion_absoluteWidth");
            this.myHeight = this.convert(component2, "layout_conversion_absoluteHeight");
            String ww = component2.getLiveAttribute("http://schemas.android.com/tools", "layout_conversion_wrapWidth");
            String wh = component2.getLiveAttribute("http://schemas.android.com/tools", "layout_conversion_wrapHeight");
            int wrapWidth = ww == null ? 0 : Integer.parseInt(ww);
            int wrapHeight = wh == null ? 0 : Integer.parseInt(wh);
            wrapWidth = ConstraintComponentUtilities.pixelToDP(component2, wrapWidth);
            wrapHeight = ConstraintComponentUtilities.pixelToDP(component2, wrapHeight);
            this.myWrapWidth = ConstraintComponentUtilities.getDpWidth(component2);
            this.myWrapHeight = ConstraintComponentUtilities.getDpHeight(component2);
            widget.mWidth = this.myWidth;
            widget.mHeight = this.myHeight;
        }

        private int convert(NlComponent component2, String attr) {
            String s = component2.getAttribute("http://schemas.android.com/tools", attr);
            return Integer.parseInt(s.substring(0, s.length() - 2));
        }
    }

    public static enum DimensionBehaviour {
        FIXED,
        WRAP_CONTENT,
        MATCH_CONSTRAINT,
        MATCH_PARENT;

    }
}

