/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlComponentUtil;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NlDropInsertionPicker {
    private final JTree myTree;

    public NlDropInsertionPicker(@NotNull NlComponentTree tree) {
        this((JTree)((Object)tree));
    }

    NlDropInsertionPicker(@NotNull JTree tree) {
        this.myTree = tree;
    }

    @Nullable
    public Result findInsertionPointAt(@NotNull Point location, @NotNull List<NlComponent> dragged) {
        if (dragged.isEmpty()) {
            return this.findInsertionPointAt(location);
        }
        Result result = new Result();
        result.receiver = null;
        result.nextComponent = null;
        TreePath referencePath = this.myTree.getClosestPathForLocation(location.x, location.y);
        result.row = this.myTree.getRowForPath(referencePath);
        if (referencePath == null) {
            return null;
        }
        result.depth = 1;
        Object last = referencePath.getLastPathComponent();
        if (!(last instanceof NlComponent)) {
            return null;
        }
        NlComponent receiverComponent = (NlComponent)last;
        if (this.canChangeInsertionDepth(referencePath, receiverComponent)) {
            Rectangle referenceBounds;
            TreePath parentPath;
            while ((parentPath = referencePath.getParentPath()) != null && (referenceBounds = this.myTree.getPathBounds(referencePath)) != null && this.canSelectLowerDepth(result.row, result.depth) && location.x < referenceBounds.x) {
                --result.depth;
                referencePath = parentPath;
            }
            receiverComponent = (NlComponent)referencePath.getLastPathComponent();
        }
        if (this.canAddComponent(receiverComponent.getModel(), receiverComponent, dragged)) {
            result.receiver = receiverComponent;
            if (receiverComponent.getChildCount() != 0) {
                TreePath nextPath = this.myTree.getPathForRow(result.row + 1);
                result.nextComponent = nextPath == null ? null : (NlComponent)nextPath.getLastPathComponent();
            }
        } else {
            NlComponent parent = receiverComponent.getParent();
            --result.depth;
            if (parent == null) {
                result.receiver = receiverComponent;
            } else {
                result.receiver = parent;
                result.nextComponent = receiverComponent.getNextSibling();
            }
            if (!this.canAddComponent(result.receiver.getModel(), result.receiver, dragged)) {
                result.receiver = null;
                result.nextComponent = null;
                return null;
            }
        }
        return result;
    }

    public Result findInsertionPointAt(@NotNull Point location) {
        TreePath path = this.myTree.getSelectionPath();
        TreePath parent = path.getParentPath();
        TreePath referencePath = this.myTree.getClosestPathForLocation(location.x, location.y);
        Result result = new Result();
        result.shouldDelegate = true;
        result.receiver = (NlComponent)parent.getLastPathComponent();
        if (referencePath == parent) {
            result.depth = 1;
            result.row = this.myTree.getRowForPath(referencePath);
            return result;
        }
        if (referencePath.getParentPath() == parent) {
            result.depth = 0;
            result.row = this.myTree.getRowForPath(referencePath);
            return result;
        }
        return null;
    }

    private boolean canChangeInsertionDepth(@NotNull TreePath path, @NotNull NlComponent component2) {
        return component2.getNextSibling() == null && this.myTree.getExpandedDescendants(path) == null;
    }

    protected boolean canAddComponent(@NotNull NlModel model, @NotNull NlComponent receiver, @NotNull List<NlComponent> dragged) {
        return model.canAddComponents(dragged, receiver, receiver.getChild(0)) || NlComponentHelperKt.isMorphableToViewGroup(receiver) && !NlComponentUtil.isDescendant(receiver, dragged);
    }

    private boolean canSelectLowerDepth(int row, int relativeDepth) {
        return row == this.myTree.getRowCount() - 1 || relativeDepth > -1;
    }

    public static class Result {
        NlComponent receiver;
        NlComponent nextComponent;
        int depth;
        int row;
        boolean shouldDelegate = false;
    }
}

