/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlComponentUtil;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEvent;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.tools.idea.uibuilder.structure.NlDropInsertionPicker;
import com.android.tools.idea.uibuilder.structure.NlTreeUtil;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDropListener
extends DropTargetAdapter {
    public static final HashSet<String> ourCopyableAttributes = new HashSet(Arrays.asList("layout_width", "layout_height", "id", "background"));
    private final List<NlComponent> myDragged = new ArrayList<NlComponent>();
    private final NlComponentTree myTree;
    private DnDTransferItem myTransferItem;
    protected NlComponent myDragReceiver;
    protected NlComponent myNextDragSibling;
    private final NlDropInsertionPicker myInsertionPicker;

    public NlDropListener(@NotNull NlComponentTree tree) {
        this(tree, new NlDropInsertionPicker(tree));
    }

    NlDropListener(@NotNull NlComponentTree tree, @NotNull NlDropInsertionPicker insertionPicker) {
        this.myTree = tree;
        this.myInsertionPicker = insertionPicker;
    }

    @Override
    public void dragEnter(@NotNull DropTargetDragEvent dragEvent) {
        NlDropEvent event = new NlDropEvent(dragEvent);
        this.captureDraggedComponents(event, true);
        this.updateInsertionPoint(event);
    }

    @Override
    public void dragOver(@NotNull DropTargetDragEvent dragEvent) {
        NlDropEvent event = new NlDropEvent(dragEvent);
        this.updateInsertionPoint(event);
    }

    @Override
    public void dragExit(@NotNull DropTargetEvent event) {
        this.myTree.clearInsertionPoint();
        this.clearDraggedComponents();
    }

    @Override
    public void drop(@NotNull DropTargetDropEvent dropEvent) {
        NlDropInsertionPicker.Result finderResult = this.myInsertionPicker.findInsertionPointAt(dropEvent.getLocation(), this.myDragged);
        if (finderResult != null) {
            if (finderResult.shouldDelegate) {
                DelegatedTreeEvent.Type type = DelegatedTreeEvent.Type.DROP;
                boolean eventHandled = NlTreeUtil.delegateEvent(type, this.myTree, finderResult.receiver, finderResult.row);
                if (eventHandled) {
                    dropEvent.acceptDrop(3);
                    dropEvent.dropComplete(true);
                }
            } else {
                NlDropEvent event = new NlDropEvent(dropEvent);
                InsertType insertType = this.captureDraggedComponents(event, false);
                this.myDragReceiver = finderResult.receiver;
                this.myNextDragSibling = finderResult.nextComponent;
                this.performDrop(dropEvent, insertType);
            }
        }
        this.myTree.clearInsertionPoint();
        this.clearDraggedComponents();
    }

    @Nullable
    private InsertType captureDraggedComponents(@NotNull NlDropEvent event, boolean isPreview) {
        this.clearDraggedComponents();
        ScreenView screenView = this.myTree.getScreenView();
        if (screenView == null) {
            return null;
        }
        NlModel model = screenView.getModel();
        if (event.isDataFlavorSupported(ItemTransferable.DESIGNER_FLAVOR)) {
            try {
                this.myTransferItem = (DnDTransferItem)event.getTransferable().getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                InsertType insertType = this.determineInsertType(event, isPreview);
                if (insertType.isMove()) {
                    this.myDragged.addAll(NlTreeUtil.keepOnlyAncestors(model.getSelectionModel().getSelection()));
                } else {
                    this.myDragged.addAll(NlTreeUtil.keepOnlyAncestors(NlModelHelperKt.createComponents(model, screenView, this.myTransferItem, insertType)));
                }
                return insertType;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
            }
        }
        return null;
    }

    @NotNull
    private InsertType determineInsertType(@NotNull NlDropEvent event, boolean isPreview) {
        NlModel model = this.myTree.getDesignerModel();
        if (model == null || this.myTransferItem == null) {
            return InsertType.MOVE_INTO;
        }
        DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
        return model.determineInsertType(dragType, this.myTransferItem, isPreview);
    }

    private void clearDraggedComponents() {
        this.myDragged.clear();
    }

    private void updateInsertionPoint(@NotNull NlDropEvent event) {
        NlDropInsertionPicker.Result result = this.myInsertionPicker.findInsertionPointAt(event.getLocation(), this.myDragged);
        if (result == null) {
            this.myTree.clearInsertionPoint();
            event.reject();
        } else {
            this.myDragReceiver = result.receiver;
            this.myNextDragSibling = result.nextComponent;
            this.myTree.markInsertionPoint(result.row, result.depth);
            event.accept(this.determineInsertType(event, true) == InsertType.COPY ? event.getDropAction() : 1);
        }
    }

    protected void performDrop(@NotNull DropTargetDropEvent event, InsertType insertType) {
        this.myTree.skipNextUpdateDelay();
        NlModel model = this.myTree.getDesignerModel();
        assert (model != null);
        if (NlComponentHelperKt.isGroup(this.myDragReceiver) && model.canAddComponents(this.myDragged, this.myDragReceiver, this.myDragReceiver.getChild(0))) {
            this.performNormalDrop(event, insertType, model);
        } else if (!this.myDragReceiver.isRoot() && !NlComponentUtil.isDescendant(this.myDragReceiver, this.myDragged) && NlComponentHelperKt.isMorphableToViewGroup(this.myDragReceiver)) {
            this.morphReceiverIntoViewGroup(model);
            this.performNormalDrop(event, insertType, model);
        } else {
            ViewHandler handler = NlComponentHelperKt.getViewHandler(this.myDragReceiver);
            if (handler instanceof ViewGroupHandler) {
                ViewGroupHandler groupHandler = (ViewGroupHandler)handler;
                groupHandler.performDrop(model, event, this.myDragReceiver, this.myDragged, this.myNextDragSibling, insertType);
            }
        }
    }

    private void performNormalDrop(@NotNull DropTargetDropEvent event, @NotNull InsertType insertType, @NotNull NlModel model) {
        try {
            model.addComponents(this.myDragged, this.myDragReceiver, this.myNextDragSibling, insertType);
            event.acceptDrop(insertType == InsertType.COPY ? event.getDropAction() : 1);
            event.dropComplete(true);
            model.notifyModified(NlModel.ChangeType.DROP);
        }
        catch (Exception exception) {
            Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
            event.rejectDrop();
        }
    }

    private void morphReceiverIntoViewGroup(@NotNull NlModel model) {
        AttributesTransaction transaction = this.myDragReceiver.startAttributeTransaction();
        for (AttributeSnapshot attribute : this.myDragReceiver.getAttributes()) {
            if ("tools".equals(attribute.prefix) || ourCopyableAttributes.contains((Object)attribute.name) || attribute.namespace == null) continue;
            transaction.removeAttribute(attribute.namespace, attribute.name);
        }
        NlWriteCommandAction.run(this.myDragReceiver, "", () -> {
            XmlTag tag = this.myDragReceiver.getTag();
            tag.setName("android.support.constraint.ConstraintLayout");
            this.myDragReceiver.setTag(tag);
            transaction.commit();
        });
    }
}

